; Hugi Compo 21 - Tic Tac Toe
; By Exophase
;
; This is my first compo and actually my first 16bit DOS program. It's been a lot
; of fun pushing myself harder.
;
; I'm surprised I was able to get it down this low... I know it's not much compared
; to the others, but it was very challenging. I really look forward to seeing the 
; winning entries!
;
; Compile with NASM:
; nasm ttt.asm -f bin -o ttt.com

org 100h
x_left equ 15
y_top equ 9

start:
  push word 0b800h
  pop es
  
 s2: 
  mov ax, 01h                                               ; text mode 40x25
  int 10h                                                   ; set it
    
  mov bl, 2                                                 ; set loop counter to 2
  mov ax, 07C4h                                             ; color grey on white, char C4h
  mov di, ((y_top + 2) * 80) + (x_left * 2)

 hline:
  mov cl, 11
  rep stosw    
  mov di, ((y_top + 4) * 80) + (x_left * 2)
  dec bx
  jnz hline

  mov ah, 2                                                 ; turn off the cursor
  mov dh, 0FFh
  int 10h

  mov bp, 2  
  mov di, ((y_top + 1) * 80) + ((x_left + 3) * 2)
 vline_out:  
  mov al, 0C5h                                              ; al becomes char C5h
  mov dl, 0B3h                                              ; alternate char, 0B3h
  mov cl, 5
 vline_in:
  xchg al, dl                                               ; flip the chars
  stosb
  add di, byte 79
  loop vline_in
  mov di, ((y_top + 1) * 80) + ((x_left + 7) * 2)
  dec bp
  jnz vline_out
                                                             
 player_turn: 
  mov ah, 0
  int 16h                                                   ; wait for key input  
  cmp al, 1Bh                                               ; check to see if escape was pressed  
  je quit
  sub al, '0'
  ;js player_turn                                            ; less than zero indicates non 0-9
  jz comp_turn
  cmp al, 9                                                 ; modulo by 10, 0 is comp turn
  ja player_turn                                            ; and carry indicates non 0-9
  dec ax
  call test_move
  jc player_turn   
  bts bp, ax
  mov dl, 'X'
  call draw
 
 comp_turn:  
  call negamax                                              ; determine the computer's move
  mov al, dh                                                ; load the move
  je win                                                    ; if so, go to end game routine
  bts bx, ax                                                ; set the move
  mov dl, 'O'                                               ; load the draw char
  call draw                                                 ; draw it
  mov si, WinMsg                                            ; load win message
  je win                                                    ; if so, go to win routine
  call check_tie_setup                                      ; see if it ties
  jne player_turn                                           ; if not so, let the player move

 win:                                                       ; position to draw at
  mov di, (20 * 80) + (17 * 2)
  mov cl, 7                                                 ; number of chars to draw
 pr_win:
  movsb
  inc di
  loop pr_win

  mov ah, 0                                                 ; interrupt 16, 0 - keyboard scan
  int 16h  
 
 quit:
  cmp al, 1Bh                                               ; see if esc was pressed  
  jne s2    
  mov ax, 03h  
  int 10h
  ret

WinMsg db "O wins!"
TieMsg db "A draw!"

draw:
  aam 3
  mov di, ((y_top + 5) * 80) + 32  
  shl al, 1
  neg al
  aad 40  
  cbw
  shl ax, 2
  sub di, ax  
  mov al, dl
  stosb

check_win:                                                  ; check against bx
  mov cl, 8
  mov si, win_list 
 win_loop:  
  mov al, cl                                                ; compute the 9th bit
  aam 6                                                     ; the first three (8-6) will have it
  lodsb
  mov di, bx  
  and di, ax
  cmp di, ax
  
  loopne win_loop
  ret

test_move:
  mov di, bp                                                ; player's moves
  or di, bx                                                 ; computer's moves
  bt di, ax                                                 ; test the bit
  ret

win_list db 11000000b
         db 00100100b        
         db 00010001b        
         db 00111000b
         db 00000111b
         db 10010010b
         db 01001001b
         db 01010100b

other_win:
  dec ax
  ret

negamax:
  xchg bp, bx
  call check_win                                            ; see if current's grid wins  
  xchg bp, bx
  mov al, 0  
  je other_win
  call check_tie
  je n_ret
  mov dl, -2                                                ; current highest                                                
  mov al, 8                                                 ; loop counter
 ng_loop:                                                   ; if they can't go to the next part
  call test_move                                            ; determine if current can move there
  jc ng_loop_next_3
  push bp                                                   ; push everything that's important
  push bx
  push ax
  push dx  
  bts bx, ax                                                ; set the bit in the grid
  xchg bp, bx
  call negamax                                              ; get negamax value                                                                   
  neg al                                                    ; negate it
  pop dx                                                    ; restore the high value
  cmp al, dl                                                ; compare the high against the new
  jng ng_loop_next
  mov dl, al                                                ; set the high to the new
  pop ax 
  mov dh, al                                                ; set the best position
  push ax
 ng_loop_next:
  pop ax
 ng_loop_next_2:
  pop bx
  pop bp  
 ng_loop_next_3:
  dec ax
  jns ng_loop
  mov al, dl
 n_ret:
  
check_tie_setup:
  mov si, TieMsg
check_tie:
  call test_move
  cmp di, 111111111b
  ret
