;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 13.Mar.2003 - 221 bytes Entry for the Hugi Size Coding Compo #21
;		 by Asko Vuori
;		    Pyh. Katariinantie 14 B 26
;		    20780 Kaarina
;		    Finland
; compile:
;	tasm /m9 entry
;	tlink /t /x entry
; tasm options:
;	/dMODE1		- use video mode 1 (+1 byte)
;	/dSAME		- play with same result values (+2 bytes)
;	/dUSE186	- use 80186 instructions (+4 bytes)
;
; Version history:
;   245 - 3.Mar.2003 by ATV
;   241 - 7.Mar.2003 by ATV
;   221 - 13.Mar.2003 by ATV
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;The computer marks its moves with an "O" and the player uses an "X". The
; numeric keypad is used to make the player's move.
;
;			 7  8  9
;			
;			 4  5  6
;			
;			 1  2  3
;
;The player always goes first, but the 0 key is used to skip a move. Thus
; it can be used to let the computer play first.
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	Title	Tic-Tac-Toe

X0	equ	16	;screen coordinates of character in upper-left position
Y0	equ	10	;(used to position grid on screen)

	.model	tiny
	.radix	10
	.code
IFDEF USE186
	.186				;(pusha, push v16, shl v8, imul)
ELSE
	.386				;(bt)
ENDIF
	org	100h			;assume: si=01??h

start:	push	0B834h			;screen segment
	pop	es
main:	xor	ax, ax			;mode 0, set 40x25 screen and clear it
IFDEF MODE1
	inc	ax			;mode 1, set 40x25 screen and clear it
ENDIF
	int	10h
	xchg	ax, si			;turn off the annoying cursor (ah=1)
	mov	ch, 20h
	int	10h
IFDEF NUMBERS AND NOT USE186
	mov	si, 0008h		;show dark numbers (+16 bytes)
nums:	pusha
	mov	bx, 0831h
	lea	ax, [bx+si]
	call	domov2
	popa
	dec	si
	jns	nums
ENDIF
	mov	di, (Y0+3)*80+(X0-1)*2-340h	;draw grid
	mov	ax, 07C4h		;write character ( = C4h) at cursor
hline:	mov	cx, 11			;do it 11 times
	rep	stosw
	sub	di, 160+11*2		;next line up
	jnc	hline			;loop 2 times (di=00EEh-2*A0h=FFAEh)
	mov	di, (Y0+4)*80+(X0+2)*2-340h
	inc	ax			;write character ( = C5h) at cursor
vline:	xor	al, 0B3h xor 0C5h	;write character ( = B3h) at cursor
	stosw
	add	di, 6
	stosw
	sub	di, 80+10		;next row up
	jnc	vline			;loop 5 times (di=0144h-5*50h=FFB4h)

	mov	dx, 01FFh		;empty places
	mov	bx, dx			;initialize player's and computer's
	mov	bp, dx			;bit arrays to empty

play:	xchg	bx, bp			;swap player/computer
;#################### GET PLAYER'S MOVE (X) ####################
redo:	mov	ah, 0			;wait for keystroke
	int	16h

	dec	ah			;is it an Esc?
	je	quit			;quit if so

	sub	al, '0'
	je	skip			;skip move? (computer goes first?)
	cmp	al, 9
	ja	redo			;legal keystroke (0..9)?
	cbw
IFDEF USE186
	xchg	cx, ax			;cx = index 1..9 where bit is placed
	mov	di, dx
	shr	di, cl			;loop if occupied by an X or O
	jnc	redo			;is position empty?
	mov	si, cx			;si = index 1..9 where bit is placed
ELSE
	dec	ax
	bt	dx, ax			;loop if occupied by an X or O
	jnc	redo			;is position empty?
	xchg	ax, si			;si = index 0..8 where bit is placed
ENDIF
	mov	al, 'X' 		;player's character (X)
	call	domov			;do player's move
	je	gameover		;Z flag set if no more moves

;#################### GET COMPUTER'S MOVE (O) ####################
skip:	call	try			;get value
	mov	al, 'O' 		;computer's character (O)
	call	domov			;do best move
	jne	play			;Z flag set if no more moves
gameover:
	mov	cl, 07h
	mov	di, 20*80+17*2-340h
domsg1:	lodsb
	stosw				;normal white on black (ah=7)
	loop	domsg1

	xchg	ax, cx			;ah=0 wait for keystroke
	int	16h

	dec	ah			;is it an Esc?
	jne	main			;repeat games until Esc
quit:	mov	al, 03h			;clear screen & restore flashing cursor
	int	10h

dowin:	mov	si, offset MsgOWin	;display "O wins!" message
	;mov	[si], al 		;dummy - player can't win
IFDEF SAME
	;cx = 1..8, it passes the test suit with different executions
	;and games played counts. Compile with /dSAME options to get
	;same results as example (cx=1).
	mov	cl, 1			;1 = the worst value for player (X)
ENDIF
	ret				;return to subroutine won or DOS

;############################################################################
;Mark move in player's/computer's bit array and display it
; Inputs:
;  bx = player's bit array
;  si = index 0..8 where bit is placed (with USE186 1..9)
;  al = character to display (X or O)
; Outputs:
;  Returns Z flag set if there are no more moves available (Win or Cat's game)
;  si = message offset
domov:	mov	ah, 07h			;normal white on black
domov2:	mov	cx, si
IFDEF USE186
	lea	di, [si+((Y0+6)*80+X0*2+16-340h)/8]	;cursor position
rows1:	sub	di, 20+3
	sub	si, 3
	ja	rows1
ELSE
	lea	di, [si+((Y0+6)*80+X0*2+24-340h)/8]	;cursor position
rows1:	sub	di, 20+3
	sub	si, 3
	jnb	rows1
ENDIF
	shl	di, 3			;di=StartXY-(i/3)*160+(i%3)*8
	stosw				;display character

;############################################################################
;Return with Z flag set if cat's or bx has won (3 in a row)
; Outputs:
;  cx = value of node if Z flag set
IFDEF USE186
won:	rcr	bx, cl			;make move
	cmc
	rcl	bx, cl
ELSE
won:	btc	bx, cx			;make move
ENDIF
	mov	cl, 8			;8 table patterns
	mov	si, offset Tbl
won10:	push	ax			;if first 3 patterns set ah=1
	imul	ax, cx, 43		;ah=cx/6   (works for 0-130)
	lodsb
	test	ax, bx			;is all 3 places used?
	pop	ax
	je	dowin			;jump if won (set Z flag)
	loop	won10			;return cx=0 (cat's)

	and	dx, bx			;set cat status (set Z flag)
	ret

;############################################################################
;Recursive tree search. Returns the value of a node. Terminal nodes have these
; values:
; +1 if computer (O) wins
; -1 if player (X) wins
;  0 if cat's game
;Non-terminal nodes have the value returned by their sub-nodes. A sub-node
; returns the best value. For the computer it's the largest value; for the
; player it's the smallest value.
;
;Inputs:
; bp/bx = player's/computer's bit array (X or O)
;Outputs:
; ax = value of node
; si = index (position of best value)
;Register usage:
; cx = position and loop counter
; di = value of node

try:	xchg	bx, bp			;swap player/computer
	;mov	ax, -1			;-1 = the worst value for computer (O)
	mov	ah, -1			;-1 = the worst value for computer (O)
IFDEF USE186
	mov	cl, 9			;for 9 down thru 1...
try10:	mov	di, dx
	shr	di, cl			;is position empty?
ELSE
	mov	cl, 8			;for 8 down thru 0...
try10:	bt	dx, cx			;is position empty?
ENDIF
	jnc	try60			;loop if occupied by an X or O
	pusha
	pop	di			;use di to pop best move
;Check for a win or cat's
	call	won			;Z flag set if bx has won or draw
	je	try30			;return cx

;Else return the best value of a sub-node (recurse)
	call	try			;get value
	xchg	ax, cx
	neg	cx
try30:	push	cx			;return value of best move
	popa
	cmp	ax, di			;is new best value?
	jge	try60
	xchg	ax, di			;save best value
	mov	si, cx			;also save position of best value
IFDEF USE186
try60:	loop	try10			;next position
ELSE
try60:	dec	cx
	jns	try10			;next position
ENDIF
	ret

;Table of winning patterns (first 3 need +100h)
Tbl	db	11h, 24h, 0C0h, 07h, 38h, 49h, 54h, 92h
MsgDraw	db	"A draw!"
MsgOWin	db	"O wins!"

	end	start
