	page	240, 132
;EXAMPLE.ASM	4-Feb-2003		Boreal		loren_blaney@idcomm.com
;Hugi Compo 21: Tic-Tac-Toe
;
;The computer marks its moves with an "O" and the player uses an "X". The
; numeric keypad is used to make the player's move.
;
;                         7  8  9
;                        
;                         4  5  6
;                        
;                         1  2  3
;
;The player always goes first, but the 0 key is used to skip a move. Thus
; it can be used to let the computer play first.
;
;Assemble:
; tasm /m
; tlink /t

X0	equ	35-19	;screen coordinates of character in upper-left position
Y0	equ	10	;(used to position grid on screen)

	.model	tiny
	.code
	.486
	org	100h
start:
main:	mov	ax, 0001h		;set 40x25 screen and clear it
	int	10h

	mov	ah, 01h			;turn off annoying cursor
	mov	ch, 20h
	int	10h

	mov	dx, (Y0+1)*100h+X0-1	;draw grid
	call	hline
	mov	dx, (Y0+3)*100h+X0-1
	call	hline
	mov	dx, Y0*100h+X0+2
	call	vline
	mov	dx, Y0*100h+X0+6
	call	vline

	xor	ax, ax			;initialize player's bit arrays to empty
	mov	XMoves, ax
	mov	OMoves, ax
play:					;play one game
;#################### GET PLAYER'S MOVE (X) ####################
redo:	mov	ah, 0			;wait for keystroke
	int	16h

	cmp	al, 1Bh			;is it an Esc?
	je	quit			;quit if so

	cmp	al, '0'			;skip move? (computer goes first?)
	je	skip

	jb	redo			;legal keystroke (0..9)?
	cmp	al, '9'
	jg	redo

	sub	al, '1'			;is position empty?
	mov	cl, al
	mov	ax, 1
	shl	ax, cl
	test	ax, XMoves		;loop if occupied by an X
	jne	redo
	test	ax, OMoves		;loop if occupied by an O
	jne	redo

	mov	al, 'X'			;character to display (X or O)
	mov	bx, offset XMoves	;address of player's bit array
	call	domov			;cl = index 0..8 where bit is placed

	mov	cx, XMoves		;get player's array
	call	won			;Z flag set if player cx has won
	jne	noXwin

	mov	ax, 1301h		;display "X wins!" message
	mov	bx, 07h			;normal white on black
	mov	cx, 7
	mov	dx, 20*100h+17
	mov	bp, offset MsgXWin
	int	10h
	jmp	gameover
noXwin:
skip:
	call	cats			;Z flag set if no more moves
	je	gameover

;#################### GET COMPUTER'S MOVE (O) ####################
	mov	dx, -1			;assume the worst value for computer (O)
	mov	cx, 8			;for 8 down thru 0...
play20:	mov	ax, 1			;is position empty?
	shl	ax, cl
	test	ax, XMoves
	jne	play40			;jump if occupied
	test	ax, OMoves
	jne	play40

	push	OMoves			;make tenative move for computer
	or	OMoves, ax

	push	cx
	push	dx
	mov	bx, offset OMoves
	call	try			;get value
	pop	dx
	pop	cx
	cmp	ax, dx			;save best (highest) value
	jle	play30
	mov	dx, ax
	mov	di, cx			;also save position of best value
play30:
	pop	OMoves			;undo tenative move
play40:
	dec	cx			;next position
	jns	play20

	mov	al, 'O'			;character to display (X or O)
	mov	bx, offset OMoves	;address of player's bit array
	mov	cx, di			;cl = index 0..8 where bit is placed
	call	domov			;do best move


	mov	cx, OMoves		;get computer's array
	call	won			;Z flag set if player cx has won
	jne	noOwin

	mov	ax, 1301h		;display "O Wins!" message
	mov	bx, 07h			;normal white on black
	mov	cx, 7
	mov	dx, 20*100h+17
	mov	bp, offset MsgOWin
	int	10h
	jmp	gameover
noOwin:
	call	cats			;Z flag set if no more moves
	jne	play
gameover:
	mov	ah, 0			;wait for keystroke
	int	16h

	cmp	al, 1Bh			;is it an Esc?
	jne	main			;no--loop for another game
quit:
	mov	ax, 0003h		;clear screen and restore cursor
	int	10h
	ret				;return to DOS

;###############################################################################
;Draw a horizontal line starting at cursor position in dx

hline:	mov	ah, 02h			;set cursor position
	xor	bx, bx			;page 0
	int	10h

	mov	ax, 0AC4h		;write character ( = C4h) at cursor
	mov	cx, 11			;do it 11 times
	int	10h
	ret

;###############################################################################
;Draw a vertical line over the horizontal line.
; Starts at cursor position in dx

vline:	mov	bp, 5			;draw 5 characters

vlin05:	mov	ah, 02h			;set cursor position to dx
	xor	bx, bx			;page 0
	int	10h

	mov	ax, 0AB3h		;write character ( = B3h) at cursor
	test	bp, 0001h
	jne	vlin10
	mov	al, 0C5h		;write character ( = C5h) at cursor
vlin10:	mov	cx, 1			;do it once
	int	10h

	inc	dh			;next row down
	dec	bp			;loop for 5 characters
	jne	vlin05
	ret

;###############################################################################
;Make move in player's bit array and display it
; Inputs:
;  bx = address of player's bit array
;  cl = index 0..8 where bit is placed
;  al = character to display (X or O)

domov:	pusha
	push	ax			;save character to display
	mov	ax, 1			;make move
	shl	ax, cl
	or	[bx], ax

;Display move
	mov	al, cl			;i=cx/3
	cbw
	mov	cl, 3
	div	cl			;al:= ax/cl; ah:= rem
	shl	ah, 2			;x=rem*4
	mov	dl, ah
	neg	al			;y=(2-i)*2
	add	al, 2
	shl	al, 1
	mov	dh, al
	add	dx, Y0*100h+X0

	mov	ah, 02h			;set cursor position to dx
	xor	bx, bx			;page 0
	int	10h

	pop	ax			;get character to display
	mov	ah, 0Ah			;write character at cursor
	mov	cx, 1			;do it once
	int	10h

	popa
	ret

;###############################################################################
;Returns the value of a node. Terminal nodes have values as follows:
; +1 if computer (O) wins
; -1 if player (X) wins
;  0 if cat's game
;Non-terminal nodes have the value returned by their sub-nodes. A sub-node
; returns the best value. For the computer it's the largest value; for the
; player it's the smallest value.
;
;Inputs:
; bx = address of player's bit array (O or X)
;Outputs:
; ax = value of node
;Register usage:
; cx = position and loop counter
; dx = value of node

try:
;If terminal node (win or cat's) then evaluate it
;Check for a win
	mov	cx, [bx]		;get player's array (O or X)
	call	won			;Z flag set if player cx has won
	jne	nowin
	mov	ax, 1
	cmp	bx, offset OMoves
	je	try99
	mov	ax, -1
	jmp	try99
nowin:
;Check for a cat's game
	mov	ax, XMoves		;if all positions are occupied (cat's)
	or	ax, OMoves
	cmp	ax, 1FFh
	mov	ax, 0			;return a 0
	je	try99

;Else return the best value of a sub-node (recurse)
;If trying move for player (X) then make tenative move for the computer (O)
	cmp	bx, offset XMoves
	jne	try50

	mov	dx, -1			;assume the worst value for computer (O)
	mov	cx, 8			;for 8 down thru 0...
try20:	mov	ax, 1			;is position empty?
	shl	ax, cl
	test	ax, XMoves
	jne	try40			;jump if occupied
	test	ax, OMoves
	jne	try40

	push	OMoves			;make tenative move for computer
	or	OMoves, ax

	push	cx
	push	dx
	mov	bx, offset OMoves
	call	try			;get value
	pop	dx
	cmp	ax, dx			;save best (highest) value
	jle	try30
	mov	dx, ax
try30:	pop	cx
	pop	OMoves			;undo tenative move
try40:
	dec	cx			;next position
	jns	try20
	jmp	try90
try50:
;Trying move for computer (O) so make tenative move for the player (X)
	mov	dx, +1			;assume the worst value for player (X)
	mov	cx, 8			;for 8 down thru 0...
try60:	mov	ax, 1			;is position empty?
	shl	ax, cl
	test	ax, XMoves
	jne	try80			;jump if occupied
	test	ax, OMoves
	jne	try80

	push	XMoves			;make tenative move for player
	or	XMoves, ax

	push	cx
	push	dx
	mov	bx, offset XMoves
	call	try			;get value
	pop	dx
	cmp	ax, dx			;save best (lowest) value
	jge	try70
	mov	dx, ax
try70:	pop	cx
	pop	XMoves			;undo tenative move
try80:
	dec	cx			;next position
	jns	try60
try90:
	mov	ax, dx			;return value of best move
try99:	ret

;###############################################################################
;Return with Z flag set if player's array in cx has won (3 in a row)

won:	pusha
	mov	bx, 14			;for 14 downto 0 step 2
won10:	mov	ax, cx
	and	ax, [bx+Tbl]
	cmp	ax, [bx+Tbl]
	je	won90			;jump if won
	dec	bx
	dec	bx
	jns	won10
won90:	popa
	ret

;Table of winning patterns
Tbl	dw	0007h, 0038h, 01C0h, 0049h, 0092h, 0124h, 0111h, 0054h

;###############################################################################
;Returns Z flag set if there are no more moves available (Cat's game)

cats:	pusha
	mov	ax, XMoves		;if all positions are occupied
	or	ax, OMoves
	cmp	ax, 1FFh
	jne	cats90			;jump if not (Z flag is clear)

	mov	ax, 1301h		;display "Cat's" message
	mov	bx, 07h			;normal white on black
	mov	cx, 7
	mov	dx, 20*100h+17
	mov	bp, offset MsgCats
	int	10h

	xor	ax, ax			;set eq status (set Z flag)
cats90:
	popa
	ret


MsgCats	db	"A draw!"
MsgXWin	db	'X wins?'
MsgOWin	db	'O wins!'

XMoves	dw	?			;bit array of player's moves
OMoves	dw	?			;bit array of computer's moves
					;bit 0 corresponds to position 1, etc.
	end	start
