{ Tic-tac-toe implementation that evaluates boards without recursion,
  rather with an evaluation function such that choosing the best position
  makes the program unbeatable.
  
  Idea by Jean-Charles Meyrignac. }

program demo_tictactoe;
{$X+}

uses crt;

type
  player = (Naughts, Crosses, None, Draw);
  board = array[Naughts..Crosses] of word;

{------------------------------------}
{ Look on b for three pegs in a line }
{------------------------------------}

function won(var b: board): player;
const
  wins: array[1..8] of word = ($1C0, $38, $7, $124, $92, $49, $111, $54);
var
  i: word;
begin
  for i := 1 to 8 do
    if (b[Naughts] and wins[i]) = wins[i] then
      begin
        won := Naughts;
        exit;
      end
    else if (b[Crosses] and wins[i]) = wins[i] then
      begin
        won := Crosses;
        exit;
      end;

  if (b[Naughts] or b[Crosses]) = $1FF then
    won := Draw
  else
    won := None;
end;

procedure field;
  procedure print_line (n: integer; c1, c2: char);
  var
    s: string[11];
    i: integer;
  begin
    s[0] := #11;
    for i := 1 to 11 do
      if (i and 3) = 0 then
        s[i] := c2
      else
        s[i] := c1;

    gotoxy (16,n);
    write (s);
  end;

begin
  clrscr;
  print_line (11, ' ', '');
  print_line (12, '', '');
  print_line (13, ' ', '');
  print_line (14, '', '');
  print_line (15, ' ', '');
end;

procedure put_sign (position: word; who: player);
var
  x,y: integer;
begin
  if position = 0 then exit;

  y := 11;
  x := 17;
  while position < $100 do begin
    if x = 25 then
      begin
        x := 17;
        inc(y, 2)
      end
    else
      inc (x, 4);

    position := position shl 1;
  end;

  gotoxy (x, y);
  if who = Naughts then
    write ('O')
  else
    write ('X')
end;

{--------------------------------------}
{ Plays a game and returns the winner. }
{--------------------------------------}

procedure play_tictactoe;
var
  b: board;
  position: word;
  ch: char;
  winner: player;

  function best_move: word;
  const
    coef: array [0..8] of integer = (4,10,-10,-2,-10,10,0,-15,15);
    weight: array [0..8] of integer = (0,3,0,3,6,3,0,3,0);
  
    who = naughts;
    them = crosses;
    
  var
    new_board: board;
    position, i, curr: word;
    best, val: integer;
    cell: array [0..8] of integer;
  begin
    best := -32768;
    position := $100;

    while position > 0 do begin
      if (position and (b[Naughts] or b[Crosses])) = 0 then
        begin
          new_board[who] := b[who] or position;
          new_board[them] := b[them];

          curr := 1;
          for i := 0 to 8 do
	    begin
	      if (new_board[who] and curr) > 0 then
	        cell[i] := coef[weight[i]+2]
	      else if (new_board[them] and curr) > 0 then
	        cell[i] := coef[weight[i]+1]
	      else
	        cell[i] := coef[weight[i]];

	      curr := curr shl 1;
            end;

          val := cell[0]*cell[1]*cell[2] + cell[3]*cell[4]*cell[5] +
	    cell[6]*cell[7]*cell[8] + cell[0]*cell[4]*cell[8] +
	    cell[2]*cell[4]*cell[6] + cell[0]*cell[3]*cell[6] +
	    cell[1]*cell[4]*cell[7] + cell[2]*cell[5]*cell[8];

          {------------------------------------------------}
          { Check if the move is better than the last one. }
          {------------------------------------------------}

          if best < val then
            begin
              best_move := position;
              best := val;
            end

        end;

      position := position shr 1
    end;
  end;

  procedure pick_move;
  const
    moves:array['1'..'9'] of word = ($4,$2,$1,$20,$10,$8,$100,$80,$40);
  begin
    position := 0;
    repeat
      ch := readkey;
      if ch = #0 then
        readkey
      else if (ch in ['1'..'9']) then begin
        position := moves[ch];
        if (position and (b[Naughts] or b[Crosses])) = 0 then exit;
      end else if (ch = '0') and ((b[Naughts] or b[Crosses]) = 0) then
        exit
      else if ch = #27 then begin
        exit;
      end;
    until false;
  end;

  procedure show_winner;
  begin
    gotoxy(18,21);
    if winner = Draw then
      write ('A draw!')
    else if winner = Crosses then
      write ('X wins?')
    else
      write ('O wins!');

    readkey;
    asm MOV AX,3; INT 10H; end;
  end;

begin
  asm MOV AX,1; INT 10H; end;
  field;
  b[Naughts] := 0;
  b[Crosses] := 0;
  while (b[Naughts] or b[Crosses]) <> $1FF do begin
    pick_move;
    if ch = #27 then begin
      asm MOV AX,3; INT 10H; end;
      exit;
    end;

    b[Crosses] := b[Crosses] or position;
    put_sign (position, Crosses);
    winner := won(b);
    if winner <> None then begin
      show_winner;
      exit;
    end;

    position := best_move;

    b[Naughts] := b[Naughts] or position;
    put_sign (position, Naughts);
    winner := won(b);
    if winner <> None then begin
      show_winner;
      exit;
    end;
  end;

  show_winner;
end;    

begin
  play_tictactoe;
end.
