;compile: nasm -f bin -o checker.com checker.asm
;run: checker entry.com points.txt
SECTION .text

[org 100h]
	mov	ax,cs
	mov	word[wCodeSeg],ax
	mov	word[fcb1+2],ax
	mov	word[fcb2+2],ax


;	mov	ax,wStack
;	mov	sp,ax
;	add	ax,1fh
;	shr	ax,4
;	mov	dx,cs
;	add	dx,ax
;	mov	word[screenSeg],dx		;save screen's address
;	mov	word[screen1Seg],dx
;	add	dx,64000/16
;	mov	word[screen2Seg],dx
;	add	ax,(64000/16)*2			;2 screens
;	mov	bx,ax
;	mov	ah,4ah		;Resize memory
;	int	21h

	mov	ah,0x4a
	mov	bx,4096
	int	0x21
	mov	ah,0x48
	mov	bx,4096
	int	0x21
	mov	word [screenSeg],ax
	mov	word [screen1Seg],ax
	mov	ah,0x48
	mov	bx,4096
	int	0x21
	mov	word [screen2Seg],ax

	mov	si,81h
	call	SkipSpaces
	
	mov	di,userProg		;copy the user entry name
	call	CopyName

	call	SkipSpaces

	mov	di,inputfile	;copy the points file name
	call	CopyName
	call	copyname2psp
	
	mov	word[cmdline],80h		;Put cmdline into exec param
	mov	word[cmdline+2],cs

	mov	ax,3516h
	int	21h
	mov	word[wOld16],bx
	mov	word[wOld16+2],es	;Hook int 16h
	mov	ax,2516h
	mov	dx,int16
	int	21h

	mov	byte[bHookKeyFlag],1

	xor	ax,ax
	mov	es,ax
	mov	ax,word [es:0x20*4]
	mov	word [oldint20],ax
	mov	ax,word [es:0x20*4+2]
	mov	word [oldint20+2],ax
	
	mov	ax,word int20
	mov	word [es:0x20*4],ax
	mov	ax,cs
	mov	word [es:0x20*4+2],ax

	mov	ah,0x48
	mov	bx,4096
	int	0x21
	mov	es,ax
	mov	cx,0x100
	xor	si,si
	xor	di,di
	rep	movsb

	mov	ax,0x3d00
	mov	dx,refProg
	int	0x21
	mov	bx,ax
	mov	word [cs:filehandle],ax
	mov	cx,0xffff-0x100
	mov	ah,0x3f
	mov	dx,0x100
	push	es
	pop	ds
	int	0x21

	mov	word [cs:far_addr+2],es
	mov	word [cs:far_addr],0x100
	
	mov	word [cs:oldcs],cs
	mov	word [cs:oldip],afterjump
	
	push	es

	mov	word [cs:oldsp],sp

	mov	ax,es	
	mov	ds,ax
	mov	ss,ax
	mov	sp,0xfffe
	mov	word [0xfffe],0
	
	xor	ax,ax
	xor	bx,bx
	mov	cx,0x00ff
	xor	dx,dx
	mov	si,0x100
	mov	di,0xfffe
	mov	bp,0x0900
	
	db	0xea
far_addr:
	dw	0
	dw	0

afterjump:
	mov	sp,word [cs:oldsp]

	mov	ax,cs
	mov	ds,ax
	mov	ss,ax
	
	pop	es
	
	mov	ah,0x3e
	mov	bx,word [cs:filehandle]
	int	0x21


	
	mov	ax,word[cs:screen1Seg]	;reinit some variables
	mov	word[screenSeg],ax
	mov	byte[cs:bPassNum],2
	mov	byte[cs:bCopy],0	;Tell it is not the ref prog
	mov	byte[bHookKeyFlag],1


	mov	ax,0x3d00
	mov	dx,userProg
	int	0x21
	mov	bx,ax
	mov	word [cs:filehandle],ax
	mov	cx,0xffff-0x100
	mov	ah,0x3f
	mov	dx,0x100
	push	es
	pop	ds
	int	0x21
	
;	push	cs
;	pop	ds
;	mov	cx,0x10
;	mov	di,0x5c
;	mov	si,0x6c
;	rep	movsb

	mov	byte [es:0x5c],0

	push	cs
	pop	ds
	mov	si,0x80

.skipspaces:
	inc	si
	mov	al,byte [si]
	cmp	al,0x20
	je	short .skipspaces
	
	mov	cx,8
	mov	di,0x5d
	
.again1:
	mov	al,byte [si]
	cmp	al,'.'
	je	short .extension
	cmp	al,'Z'
	jbe	short .notcapitalize
	and	al,11011111b	;capitalize

.notcapitalize:
	mov	byte [es:di],al
	inc	si
	inc	di
	dec	cx
	jnz	short .again1
	
.extension:
	mov	al,' '
	rep	stosb
	
	mov	cx,3
	inc	si

.storeext:
	mov	al,byte [si]
	and	al,11011111b
	mov	byte [es:di],al
	inc	si
	inc	di
	loop	.storeext
	
	
	push	es
	pop	ds
	mov	dx,0x80
	mov	ah,0x1a
	int	0x21

	mov	word [cs:far_addr2+2],es
	mov	word [cs:far_addr2],0x100
	
	mov	word [cs:oldcs],cs
	mov	word [cs:oldip],afterjump2

	push	es

	mov	word [cs:oldsp],sp

	mov	ax,es	
	mov	ds,ax
	mov	ss,ax
	mov	sp,0xfffe
	mov	word [0xfffe],0
	
	xor	ax,ax
	xor	bx,bx
	mov	cx,0x00ff
	xor	dx,dx
	mov	si,0x100
	mov	di,0xfffe
	mov	bp,0x0900

	db	0xea
far_addr2:
	dw	0
	dw	0

afterjump2:

	mov	sp,word [cs:oldsp]
	mov	ax,cs
	mov	ds,ax
	mov	ss,ax
	
	pop	es
	
	mov	ah,0x49
	int	0x21



done:
	mov	ah,0x3e
	mov	bx,word [cs:filehandle]
	int	0x21

	xor	ax,ax
	mov	es,ax
	mov	ax,word [cs:oldint20]
	mov	word [es:0x20*4],ax
	mov	ax,word [cs:oldint20+2]
	mov	word [es:0x20*4+2],ax
	
	mov	es,word [screen1Seg]
	mov	ah,0x49
	int	0x21
	mov	es,word [screen2Seg]
	int	0x21



;done:
	mov ax,2516h
	lds dx,[cs:wOld16]	;Restore int 16h
	int 21h

	push cs
	pop ds

;	ret

	mov ah,0fh
	int 10h			;Check if we are in mode 3
	cmp al,3
	jnz @bad_mode
	
	mov byte[bModeExitError],0	;If yes don't count an error
@bad_mode:
	mov ax,3					;go to mode 3
	int 10h

@good_mode:
	xor bx,bx					;this hold the number of errors
	cmp byte[bBufferError],0
	jz @testMode
	
	mov bx,1
	mov dx,errScreen			;some pixels are wrong
	call print
	
@testMode:
	cmp byte[bModeExitError],0
	jz @exitminus1
	
	mov bx,1
	mov dx,errMode				;doesn't exit to mode 3
	call print

@exitminus1:
	or bx,bx
	jnz @exit

	mov dx,errVoid				;No error
	call print

@exit:
	mov al,bl
	mov ah,4ch		;Bye no error: exit code =0
	int 21h

;;Hook fuctions
;;;;;;;;;;;;;;;;;;
Old16:  popf
		db 0eah
wOld16	dw 0,0

int16:
	pushf

	cmp	byte [cs:bHookKeyFlag], 0
	jz	short Old16

	or	ah,ah
	jnz	short Old16
	
	mov	ax,391Fh
	dec	byte [cs:bPassNum]
;	jns	@int16_next
;	jmp	@int16_final

	js	@int16_final

;	mov	byte [cs:bHookKeyFlag],0
@int16_next:
	push	bx
	push	di
	push	ax
	push	dx
	push	es
	push	cx
	push	si
	push	ds

	cld
	mov	di,palRef
	cmp	byte[cs:bCopy],1	;Is it the ref prog or the entry prog?
	jz	@palRef
	mov	di,palUser
@palRef:
	xor	ax,ax				;Grab the palette and put it in palRef or palUser
	mov	dx,3c7h
	out	dx,al
	mov	es,word[cs:wCodeSeg]
	mov	cx,256*3		;get user palette
	mov	dx,3c9h
	rep	insb
	xor	di,di
	xor	si,si
	mov	ax,word[cs:screenSeg]
	mov	es,ax
	mov	ds,word[cs:screen]
	mov	cx,64000
	cmp	byte[cs:bCopy],0	;Check buffer if it is entry prog
	jz	@checkBuffer
	
;	jmp	@int16finish
	
	rep	movsb				;otherwise grab screen
	jmp	near @int16finish

@checkBuffer:				;Now check the texture
	xor	ax,ax
	xor	bx,bx
	mov	al,byte [es:si]		;al=ref pixel
	mov	bl,byte [ds:si]		;bl=user pixel
	
	mov	cx,3
	imul	bx,cx				;Now find the corresponding RGB triplets
	imul	ax,cx ;ax*3 bx*3	;in palUser and palRef
	mov	di,palRef
	add	di,ax
	add	bx,palUser
@nextComposante:
	mov	al,byte[cs:bx]
	cmp	byte [cs:di],al
	jnz @badpixel			;If the two RGB triplets don't match
	inc	di					;set bBufferError flag and leave this int
	inc	bx
	loop	@nextComposante
	inc	si					;otherwise check other pixels
	cmp	si,64000
	jnz	@checkBuffer
	dec	byte[cs:bBufferError]
	jmp	@int16finish
@badpixel:
	mov	byte[cs:bBufferError],2
@int16finish:
	mov	ax,word[cs:screen2Seg]	;next pass will write into screen2
	mov	word[cs:screenSeg],ax
	pop	ds
	pop	si
	pop	cx
	pop	es
	pop	dx
	pop	ax
	pop	di
	pop	bx
	inc	al		;al=20h=space key
@int16_final:	;otherwise al=1Fh=exit
	mov	byte [cs:bHookKeyFlag],1
	popf
	iret

;------------------------------------------------------

int20:
;	mov	ax,0x0e00+'a'
;	mov	bx,7
;	int	0x10
;
;.again:
;	mov	ah,1
;	int	0x16
;	jz	short .again
	add	sp,6
	mov	ax,word [cs:oldip]
	mov	word [cs:farjump],ax
	mov	ax,word [cs:oldcs]
	mov	word [cs:farjump+2],ax

	db	0xea
farjump:
	dw	0,0


;;Boring String functions
;;;;;;;;;;;;;;;;;;;

SkipSpc2:
	inc	si
SkipSpaces:
	cmp	byte [si],20h
	jbe	short SkipSpc2
	ret

CopyName:
	lodsb
	cmp al,20h
	jbe copyend
	stosb
	jmp CopyName
copyend:
	mov byte [di],0
	inc di
	ret

copyname2psp:
	mov di,81h		;leave a 20h char
	mov si,inputfile
@copy:
	lodsb
	cmp al,0
	jz @copynameend
	stosb
	jmp short @copy
@copynameend:
	mov byte[di],0dh
	sub di,81h
	mov ax,di
	mov byte[80h],al
	ret

print:
	mov ah,9
	int 21h
	ret

[SECTION .data]
screen dw 0a000h

bModeExitError db 1
bBufferError db 2

refProg db 'drw_ref.com',0

bPassNum db 2

bCopy db 1

bHookKeyFlag db 0

execParam: dw 0		;this are parameters for the exec fct
cmdline dd 0
fcb1 dw 6ch
	dw 0
fcb2 dw 5ch
	dw 0

errMode db "**! Your entry didn't exit to mode 3.",0dh,0ah,'$'
errScreen db '**! Some pixels are wrong.',0dh,0ah,'$'
errVoid db 'Nice! Everything is OK :)',0dh,0ah,'$'

oldss	dw 0
oldsp	dw 0
oldcs	dw 0
oldip	dw 0
oldint20 dw 0,0


[SECTION .bss]

userProg resb 13
inputfile resb 13

palRef resb 256*3
palUser resb 256*3

screenSeg resw 1
screen1Seg resw 1
screen2Seg resw 1

wOldSS resw 1
wOldSP resw 1

wCodeSeg resw 1

wEmulStack resw 200h
wStack resw 1
filehandle resw 1