;compile: nasm -f bin -o checker.com checker.asm
;run: checker entry.com points.txt
SECTION .text

[org 100h]
	mov ax,cs
	mov word[wCodeSeg],ax
	mov word[fcb1+2],ax
	mov word[fcb2+2],ax

	mov ax,wStack
	mov sp,ax
	add ax,1fh
	shr ax,4
	mov dx,cs
	add dx,ax
	mov word[screenSeg],dx		;save screen's address
	mov word[screen1Seg],dx
	add dx,64000/16
	mov word[screen2Seg],dx
	add ax,(64000/16)*2			;2 screens
	mov bx,ax
	mov ah,4ah		;Resize memory
	int 21h

	mov si,81h
	call SkipSpaces
	
	mov di,userProg		;copy the user entry name
	call CopyName

	call SkipSpaces

	mov di,inputfile	;copy the points file name
	call CopyName
	call copyname2psp
	
	mov word[cmdline],80h		;Put cmdline into exec param
	mov word[cmdline+2],cs

	mov ax,3516h
	int 21h
	mov word[wOld16],bx
	mov word[wOld16+2],es	;Hook int 16h
	mov ax,2516h
	mov dx,int16
	int 21h

	mov word[wOldSS],ss		;save old ss and sp will be modified by
	mov word[wOldSP],sp		;the running prog. 4bh

	mov ax,4b00h		;Run the reference prog.
	mov dx,refProg
	mov bx,execParam
	mov byte[bHookKeyFlag],1
	push cs
	pop es
	int 21h
	mov byte[cs:bHookKeyFlag],0

	mov ax,word[cs:screen1Seg]	;reinit some variables
	mov word[screenSeg],ax
	mov byte[cs:bPassNum],2
	mov byte[cs:bCopy],0	;Tell it is not the ref prog
	mov ax,4b00h		;Run the entry
	mov dx,userProg
	mov bx,execParam
	mov byte[cs:bHookKeyFlag],1
	mov es,word[cs:wCodeSeg]
	int 21h
	mov byte[cs:bHookKeyFlag],0

	cli
	mov ss,word[cs:wOldSS]		;reload old ss and sp
	mov sp,word[cs:wOldSP]
	sti
	
	mov ax,2516h
	lds dx,[cs:wOld16]	;Restore int 16h
	int 21h

	push cs
	pop ds

	mov ah,0fh
	int 10h			;Check if we are in mode 3
	cmp al,3
	jnz @bad_mode
	
	mov byte[bModeExitError],0	;If yes don't count an error
@bad_mode:
	mov ax,3					;go to mode 3
	int 10h

@good_mode:
	xor bx,bx					;this hold the number of errors
	cmp byte[bBufferError],0
	jz @testMode
	
	mov bx,1
	mov dx,errScreen			;some pixels are wrong
	call print
	
@testMode:
	cmp byte[bModeExitError],0
	jz @exitminus1
	
	mov bx,1
	mov dx,errMode				;doesn't exit to mode 3
	call print

@exitminus1:
	or bx,bx
	jnz @exit

	mov dx,errVoid				;No error
	call print

@exit:
	mov al,bl
	mov ah,4ch		;Bye no error: exit code =0
	int 21h

;;Hook fuctions
;;;;;;;;;;;;;;;;;;
Old16:  popf
		db 0eah
wOld16	dw 0,0

int16:
	pushf

	cmp	byte [cs:bHookKeyFlag], 0
	jz	short Old16

	or ah,ah
	jnz short Old16
	
	mov ax,391Fh
	dec byte [cs:bPassNum]
	jns @int16_next
	jmp @int16_final

	mov	byte [cs:bHookKeyFlag],0
@int16_next:
	push bx
	push di
	push ax
	push dx
	push es
	push cx
	push si
	push ds

	cld
	mov di,palRef
	cmp byte[cs:bCopy],1	;Is it the ref prog or the entry prog?
	jz @palRef
	mov di,palUser
@palRef:
	xor ax,ax				;Grab the palette and put it in palRef or palUser
	mov dx,3c7h
	out dx,al
	mov es,word[cs:wCodeSeg]
	mov cx,256*3		;get user palette
	mov dx,3c9h
	rep insb
	xor di,di
	xor si,si
	mov ax,word[cs:screenSeg]
	mov es,ax
	mov ds,word[cs:screen]
	mov cx,64000
	cmp byte[cs:bCopy],0	;Check buffer if it is entry prog
	jz @checkBuffer
	rep movsb				;otherwise grab screen
	jmp near @int16finish

@checkBuffer:				;Now check the texture
	xor ax,ax
	xor bx,bx
	mov al,byte [es:si]		;al=ref pixel
	mov bl,byte [ds:si]		;bl=user pixel
	
	mov cx,3
	imul bx,cx				;Now find the corresponding RGB triplets
	imul ax,cx ;ax*3 bx*3	;in palUser and palRef
	mov di,palRef
	add di,ax
	add bx,palUser
@nextComposante:
	mov al,byte[cs:bx]
	cmp byte [cs:di],al
	jnz @badpixel			;If the two RGB triplets don't match
	inc di					;set bBufferError flag and leave this int
	inc bx
	loop @nextComposante
	inc si					;otherwise check other pixels
	cmp si,64000
	jnz @checkBuffer
	dec byte[cs:bBufferError]
	jmp @int16finish
@badpixel:
	mov byte[cs:bBufferError],2
@int16finish:
	mov ax,word[cs:screen2Seg]	;next pass will write into screen2
	mov word[cs:screenSeg],ax
	pop ds
	pop si
	pop cx
	pop es
	pop dx
	pop ax
	pop di
	pop bx
	inc al		;al=20h=space key
@int16_final:	;otherwise al=1Fh=exit
	mov	byte [cs:bHookKeyFlag],1
	popf
	iret

;;Boring String functions
;;;;;;;;;;;;;;;;;;;

SkipSpc2:
	inc	si
SkipSpaces:
	cmp	byte [si],20h
	jbe	short SkipSpc2
	ret

CopyName:
	lodsb
	cmp al,20h
	jbe copyend
	stosb
	jmp CopyName
copyend:
	mov byte [di],0
	inc di
	ret

copyname2psp:
	mov di,82h		;leave a 20h char
	mov si,inputfile
@copy:
	lodsb
	cmp al,0
	jz @copynameend
	stosb
	jmp short @copy
@copynameend:
	mov byte[di],0dh
	sub di,81h
	mov ax,di
	mov byte[80h],al
	ret

print:
	mov ah,9
	int 21h
	ret

[SECTION .data]
screen dw 0a000h

bModeExitError db 1
bBufferError db 2

refProg db 'drw_ref.com',0

bPassNum db 2

bCopy db 1

bHookKeyFlag db 0

execParam: dw 0		;this are parameters for the exec fct
cmdline dd 0
fcb1 dw 6ch
	dw 0
fcb2 dw 5ch
	dw 0

errMode db "**! Your entry didn't exit to mode 3.",0dh,0ah,'$'
errScreen db '**! Some pixels are wrong.',0dh,0ah,'$'
errVoid db 'Nice! Everything is OK :)',0dh,0ah,'$'

[SECTION .bss]

userProg resb 13
inputfile resb 13

palRef resb 256*3
palUser resb 256*3

screenSeg resw 1
screen1Seg resw 1
screen2Seg resw 1

wOldSS resw 1
wOldSP resw 1

wCodeSeg resw 1

wEmulStack resw 200h
wStack resw 1