/*Generate a set of points and merge it with a palette.*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define RESX 128
#define RESY 128

int main(char *argv[], int argc) {
 char eof=0x1a;
 char c;
 int npt,filesize;
 char fpal[255];
 char fname[255];
 FILE *handle,*hpal;
 int coordx, coordy;

 srand((unsigned)time(NULL));
 printf("Number of points to generate: ");
 scanf("%d", &npt);
 printf("Palette filename: ");
 scanf("%s", fpal);
 printf("Output filename: ");
 scanf("%s", fname);

 handle=fopen(fname,"wb");

 hpal=fopen(fpal,"rb");
 if(!hpal) {
  printf("%s not found.\n",hpal);
  close(fname);
  exit(-1);
 }
 fseek(hpal,0,SEEK_END);
 filesize=ftell(hpal);
 fseek(hpal,0,SEEK_SET);

 while(filesize--) {
  fread(&c,sizeof(char),1,hpal);
  fwrite(&c,sizeof(char),1,handle);
 }

 while(npt--) {
  coordx=(int)(127*(float)rand()/RAND_MAX);
  coordy=(int)(127*(float)rand()/RAND_MAX);
  fprintf(handle, "%d %d\r\n", coordx, coordy);
 }
 fwrite(&eof,sizeof(char),1,handle); 
 fclose(handle);
}
