#!/usr/bin/perl -w

# This script converts a gradient POV file created by The GIMP 
# into a 256-colors palette for DOS mode 13h

use POSIX;

if($#ARGV!=0) {
  print "Usage: pov2grad.pl fichier.pov\n";
  exit;
}

my($INPUTFILE,$a,@start,@end,@RGB,$i);

open(INPUTFILE,"<$ARGV[0]")||die "Impossible d'ouvrir $ARGV[0]";

while (<INPUTFILE>) {
  s/^\s+//;
  s/\s+$//;
  last if( /^\[.*\]$/ );
}


while (1) {
  my $line=<INPUTFILE>;
  last if(!is_valid($line));
  @start=get_line($_);
  @end=get_line($line);
  $_=$line;
  $i=floor($start[0])*3;
  interpol(\@start,\@end,\@RGB,$i);
}
$i=floor($start[0])*3;
interpol(\@start,\@end,\@RGB,$i);
$i=floor($end[0])*3;
$RGB[$i]=floor($end[1]);
$RGB[$i+1]=floor($end[2]);
$RGB[$i+2]=floor($end[3]);

for($i=0;$i<256*3;$i+=3) {
  print $RGB[$i], " ", $RGB[$i+1], " ", $RGB[$i+2], chr(13),chr(10);
}

sub interpol {
  my ($start, $end,$reg,$i)=@_;

  my $step=$end[0]-$start[0];
  return($i) if($step==0);

  my $deltaR=($end[1]-$start[1])/$step;
  my $deltaG=($end[2]-$start[2])/$step;
  my $deltaB=($end[3]-$start[3])/$step;
  my @dest=@start;

  while ($step!=0) {
    #print floor($dest[1])," ",floor($dest[2])," ",floor($dest[3]),"\n";
    $RGB[$i]=floor($dest[1]);
    $RGB[$i+1]=floor($dest[2]);
    $RGB[$i+2]=floor($dest[3]);
    $dest[1]+=$deltaR;
    $dest[2]+=$deltaG;
    $dest[3]+=$deltaB;
    $i+=3;
    $step--;
  }
  return $i;
}

sub get_line {
  $_=$_[0];
  s/^\s+//;
  s/\s+$//;
  my @ret=m/\d+\.\d+/g;
  $ret[0]=floor(255*$ret[0]);
  $ret[1]=floor(63*$ret[1]);
  $ret[2]=floor(63*$ret[2]);
  $ret[3]=floor(63*$ret[3]);
  return(@ret);
}

sub is_valid {
  $_[0]=~s/^\s+//;
  $_[0]=~s/\s+$//;
  return ($_[0]=~/\d+\.\d+/);
}
