#include <stdio.h>
#include <stdlib.h>

#define RESX 128
#define RESY 128

int get_file_size(FILE *handle) {
  int s;
  
  fseek(handle,0,SEEK_END);
  s=ftell(handle);
  fseek(handle,0,SEEK_SET);
  
  return s;
}

int exit_error(char *fname, FILE *handle1, FILE *handle2) {
  printf("Can't open %s\n", fname);
  if(handle1) fclose(handle1);
  if(handle2) fclose(handle2);
  exit(1);
}

int main() {
  int x,y;
  unsigned char eof=0x1a;
  unsigned char c;
  FILE *hInFile, *hOutFile, *hPal;
  char infile[255];
  char fpal[255];
  char outfile[255];
  unsigned int palFileSize, rawFileSize;
  
  printf("Output filename: ");
  scanf("%s",outfile);
  hOutFile=fopen(outfile,"wb");
  if(!hOutFile)
    exit_error(outfile, NULL, NULL);
  
  printf("Raw file name: ");
  scanf("%s",infile);
  hInFile = fopen(infile,"rb");
  if(!hInFile)
    exit_error(infile, hOutFile, NULL);
  rawFileSize=get_file_size(hInFile);
  
  printf("Palette file name: ");
  scanf("%s", fpal);
  hPal=fopen(fpal,"rb");
  if(!hPal)
    exit_error(fpal, hOutFile, hInFile);
  palFileSize=get_file_size(hPal);  
  
  while(palFileSize--) {
    fread(&c,sizeof(char),1,hPal);
    fwrite(&c,sizeof(char),1,hOutFile);
  }

  for(y=0; y<RESY; y++)
    for(x=0; x<RESX; x++) {
      fread(&c,sizeof(char),1,hInFile);
      if(c==0)
        fprintf(hOutFile,"%d %d\r\n",x,y);
    }
 
  fwrite(&eof,sizeof(char),1,hOutFile); 
  fclose(hOutFile);
  fclose(hInFile);
  fclose(hPal);
  
  return 0;
}