; 4th entry for HC19 by Ruud
;
; Compiled using tasm /ml /m5, linked using tlink /t
; 
; Thanx Ben for all the work you have put into this compo, and
; ADOK for his input and the hosting of ALL compo's.
;
; Thanx all others for making the compo worth while


                    .MODEL    TINY
                    .386

                    .CODE
                    ORG       100h

Start:              mov       dh,0fh              ;This sceem is needed
                    or        al,5ch              ; to clear CF at start
                    xchg      ax,dx               ;dx=5ch, ah=0fh
                    int       21h                 ;Open the file (FCB)
                    xchg      [bx+69h],si         ;Record size = 1
                    xchg      ax,si               ;ax=8000h, si=0f00h
                    push      si                  ;0f00 for palette buffer
                                                  ;points start at 1200h

; Get all bytes of data from the text file and store them in the buffer
;
; Rather complex way of doing things but the mov [si+bx+1],ax provides 
; a word 320 which is the screenwidth in mode 13h and the loop exits
; nicely with ax=13h and byte [si]=0 :-)

UpdateDigit:        dec       si
                    db        0d5h                ;aad 0ah, al=al+10ah, ah=0
Getch:              db        0ah                 ;or cl,[] = CLC and skip mov
                    db        89h                 ;opcode   mov [si+bx+1],ax
ScreenWidth         dw        140h                ;operands mov [si+bx+1],ax
                    mov       ah,14h              ;FCB read block
                    int       21h                 ;Read byte to DTA
                    lodsw                         ;Current value to ah
                    mov       al,ds:[80h]         ;al=DTA byte
NoInc:              dec       si                  ;previous byte
                    sbb       al,30h              ;Value of digit
                    jnb       UpdateDigit         ;Loop if valid decimal digit
                    jpe       Getch               ;20h, 0dh --> inc si
                    add       al,29h              ;13h for 1ah (parity odd)
                    jpe       NoInc               ;03h for 0ah -> parity even

                    pop       dx                  ;Buffer for palette
                    inc       cx                  ;Palette size

_int10:             int       10h                 ;Mode 13 or set palette
                    xor       ax,1001h            ;Toggle between 1012, 0013
                    jpe       _int10              ;Sceem to keep ah=0 :-)

; Drawing engine
;
; I have assumed (feel free to check it) that maxdist can not be less than 3
; for 500 pixels in a 128x128 field. So 4(Maxdist^2)>13h, which saves a SALC
;
; How it works:
;
; Simply set maxdist to 13h, and start drawing the image for this value.
; Every time maxdist is changed cx (screen byte counter) becomes zero
; (cx=0->64K down counter assures the entire screen segment is drawn ) so
; the entire image will be drawn for the new value. This means that the
; first 128 lines of the screen may be drawn twice. Instead of dx^2+dy^2
; 4*(dx^2+dy^2) is used for obvious reasons (no need to manipulate the dx
; and dy values, a simple "shl al,1" and "imul al" will do), es:di always
; holds a pointer to the current pixel, bp always holds the current value
; of maxdist, si points to the top of the point buffer.


NewMaxdist:         xchg      ax,bp               ;bp=new value of maxdist
                    xor       cx,cx               ;full screen for new maxdist

ScreenLoop:         mov       ax,0a000h           ;Initial mindist > 8000h
                    mov       es,ax               ;also needed here
                    mov       bh,12h              ;bx=1200h (point buffer)
                    sub       bx,si               ;rel point buffer

PointLoop:          push      di                  ;Pixel address
                    xchg      ax,di               ;di=mindist,ax=pixel address
                    xor       dx,dx               ;can't use cwd :-(
                    div       ScreenWidth         ;dx=x, ax=y

                    db        0b4h                ;mov ah,43h (for sign flag)
SqDy:               inc       bx                  ;Opcode is 43h (only once)
                    xchg      ax,dx               ;Swap coordinates
                    sub       al,[bx+si]          ;Get dx or dy
                    shl       ax,1                ;Need sign in bit 7 (*2)
                    imul      al                  ;Calculate 4*d?^2
                    jns       SqDy                ;Loop if we still need dy^2

                    add       ax,dx               ;4*(dx^2+dy^2) <= 8000h
                    cmp       ax,di               ;Check for minimum
                    jbe       HaveMin             ;>> ax already minimum
                    xchg      di,ax               ;ax=new mindist value
HaveMin:            pop       di                  ;Pixel address
                    inc       bx                  ;at next point in buffer
                    jne       PointLoop           ;Loop for all points

                    cmp       ax,bp               ;Check for maxdist
                    ja        NewMaxdist          ;Set new maxdist, and marker

                    mul       word ptr [bx+3bh]   ;mindist*0ffh
                    div       bp                  ;mindist*0ffh/maxdist
                    xor       al,[si]             ;drawing mode
                    stosb                         ;on screen ;-)
                    loop      ScreenLoop          ;Draw all with last maxdist

                    not       byte ptr [si]       ;Toggle drawing mode
                    int       16h                 ;Wait for key ah=0
                    
                    cmp       al,20h
                    je        ScreenLoop
                    mov       ax,3                ;-( here goes my byte

;-(                  aad       0e0h                ;low 20h+0e0*39h=0
;-(                  je        ScreenLoop          ;Loop if spacebar
;-(                  mov       al,3                ;AH 0 due to aad 0e0h :-)
                    
                    int       10h                 ;Back to text
                    ret                           ;Done... Have fun

                    END       Start


