;; nasmw -fbin -o entry.com entry.asm

; 19/9	90
; 23/9	328	+238
; 24/9	292	-36
; 25/9  256	-36
; 26/9	238	-18
; 30/9	213	-25
; 1/10	210	-3
; 3/10	205	-5


        org     100h

entry

;--- read the entire file - 21
		mov	dx, 0fffh
		mov	ax, 1A5Ch
		int	21h
		cbw
		xchg	dx,ax
		mov	si,ax
		int	21h
		mov	ah,14h
		mov	[6Bh+bx],dl
		int	21h


;--- Read points, last point address in bp - 30
		mov	di, input
		push	di

.te		xor	ax, ax
.ne		aad
		xchg	al, ah
		lodsb
		sub	al, 30h
		jns	.ne
		xchg	al, ah
		cmp	ah, 0dah
		je	.te
		mov	bp, di
		stosb
		cmp	ah, 0eah
		jne	.te

;--- mode 13h - 5
		cbw
		mov	al,13h
		int	10h

;--- Set palette - 13
		pop	si
		mov	cx, 300h
		mov	dx, 3c8h
		mov	al, 0
		out	dx, al
		inc	dx
		rep	outsb


;; ---- gather distbuf, maxdist & min_val - 58 bytes
		mov	di,distbuf
		cwd
		mov	bh,127
.line		mov	bl,127
.col		
                mov     ch, 07fh
		push	si
.apoint		lodsw

		push	bx
		xchg	al, bh

.sqrdist	sub	al, ah
		jns	short .xpos
		neg	al
.xpos		cmp	al, 64
		jna	short .nwrapx
		sub	al, 128
		neg	al
.nwrapx		mul	al
		xchg	ax, bx
                neg     cx
		js	.sqrdist

		add	ax, bx

		pop	bx

		cmp	ax, cx
		ja	short .nmin
		mov	cx, ax
.nmin		cmp	si, bp
		jne	short .apoint
		pop	si
					;ax=mindist
		xchg	ax, cx
		stosw
		cmp	ax, dx
		jb	short .nmax
		xchg	ax, dx
.nmax		dec	bl
		jns	short .col
		dec	bh
		jns	short .line
		mov	bp, dx		; bp=maxdist


;;---------------------------------------------------------------
		push	word 0a000h
		pop	es


redraw		mov	si, distbuf
		xor	di, di
		mov	bh, 200
.dline		mov	cx, 320
.dcol		push	bx
		mov	bl, cl
		add	bl, 03fh
		add	bh, 0b7h
		shl	bl, 1
		and	bh, 127
		mov	ax, word [si+bx]
		cwd
		mov	bx, 255
		imul	bx
		div	bp

		pop	bx
		and	bl, bl
		js	short .notv2
		sub	al, 255
		neg	al
.notv2		stosb
		

		loop	.dcol
		dec	bh
		jnz	short .dline

		xchg	ax,cx
		int	16h
		neg	bl

		cmp	al, 32
		je	redraw	
.die
		mov	ax, 03h
		int	10h
		ret



SECTION .bss
input		resb	500*2+256*3
distbuf		resw	128*128
