.model tiny
.code
.486
	org	80h
rddata	db	?		;default FCB buffer
	org	6Ah
recsize	db	?		;FCB size of record

	org	100h

	;assume ax=0000, bx=0000, cx = 00xx, si = 0100, bp=09xx

start:
;-------------------------------------------------
; open file			13 bytes
	mov	dx,5Ch
	mov	ah,0Fh
	int	21h		;al=00 - Ok, FFh - Error
	inc	ax
	mov	recsize,al
	jp	short mret

;-------------------------------------------------
; read file			30 bytes
	mov	si,8000h-300h
	push	si
	dec	si
next_num:
	inc	si
read_num:
	xor	ax,ax
add_char:
	aad			;ah*10+al
	mov	[si],al

	mov	ah,14h
	int	21h
	mov	al,rddata
	mov	ah,[si]
	sub	al,30h
	jae	short add_char	;30h..39h
	jp	short next_num	;0Dh(DD) and 20h(F0)
	daa			;ax=00DAh -> 0040h or 00EAh -> 0050h
	jnp	short read_num	;0Ah

;-------------------------------------------------
; set video mode 		4 bytes
	mov	al,13h		;ah=0
	int	10h
;-------------------------------------------------
; set palette			7 bytes
	pop	dx
	mov	ax,1012h
	inc	cx		;bx=0000h cx=0100h
	int	10h

;-------------------------------------------------
; out texture			70 bytes
	inc	bx		;for bp!=0
new_max:
	mov	bp,bx		;maximum, at start bx=1
	xor	di,di

loop_draw:
	push	si
	push	cx

	mov	ax,0a000h
	mov	es,ax

change_dist:
	xchg	ax,bx
points_loop:
	xor	dx,dx		;8 bytes x->dx y->ax
	mov	ax,di
	mov	cl,40h		;ch=01h
	div	cx		;

				;calculate distance dx*dx+dy*dy
dist_loop:			;13 bytes, use cx
	dec	si
	jns	short end_points_loop
	sub	al,[si]
	add	ax,ax
	imul	al
	xchg	ax,dx
	dec	cx
	jp	short dist_loop	;only once, cx=013Fh
	add	ax,dx

	cmp	ax,bx		;find minimum distance
	jb	short change_dist
	jmp	short points_loop
end_points_loop:

	pop	cx
	pop	si
	cmp	bp,bx		;bp - maximum of minumum distances
	jb	short new_max
                                ;ax<65535/320, ah=0
	mov	al,0FFh		;al=(255*bx/bp)^cl
	mul	bx
	div	bp
	xor	al,cl
	stosb			;out pixel
	or	di,di
	jne	short loop_draw

	int	16h		;ah=0 get key

	not	cl

	cmp	al,20h
	je	short loop_draw
	
;-------------------------------------------------
; return to text mode		6 bytes
mret:
	mov	ax,3
	int	10h
	retn

	end	start