	page	240, 132
;ENTRY.ASM	11-OCT-2002	Boreal		loren_blaney@idcomm.com
;Hugi Compo 19 (Thanx! Ben)
;Display Cellular Texture File
;
;Assemble:
; tasm /m
; tlink /t
;Run:
; entry points.txt

	.model	tiny
	.code
	.486
	org	100h

;ax=0, bx=0, cx=00FFh, si=0100h, df=0

FileBuf	equ	0F27h			;0Fxx=open FCB; 27=random block read
start:	mov	dx, FileBuf		;room for 7061 bytes for input file
	pusha				;save ax=0, cx=FFh, dx=FileBuf
;(ah=0)
	mov	al, 13h			;display 320x200x256 graphics
	int	10h

	mov	ax, 1A5Ch		;set DTA address to dx=FileBuf
	int	21h			;(returns nothing)

	cbw
	xchg	dx, ax			;ax=0F27h, dx=005Ch
	int	21h			;open FCB (returns al=0 if successful)

;cx=FFh = max number of 128-byte blocks to read
; 256 palette values:
; xx xx xx<cr><lf>  10 bytes maximum * 256 = 2560 bytes maximum
; 500 coordinates:
; xxx xxx<cr><lf>    9 bytes maximum * 500 = 4500 bytes maximum
; <eof>              1 byte         total = 2560 + 4500 + 1 = 7061
; 7061 / 128 = 55.16 blocks, so cx=255 is more than enough
;dx=5Ch
	lodsw				;random block read; ax:=27BAh
	int	21h			;returns cx = number of blocks read

;Convert FileBuf from ASCII to binary
	popa				;ax=0, cx=FFh, dx=FileBuf
	mov	si, dx			;si:=FileBuf (dx=address of color table)
	mov	di, dx			;di:=FileBuf = output pointer
conv10:	aad	10			;al:=ah*10+al; ah:=0
	mov	ah, al			;save binary value into ah
conv20:	lodsb				;get ASCII char; al:= ds:[si++]
	cmp	al, 0Ah			;eat linefeeds (yuck!)
	je	conv20
	sub	al, '0'			;convert digit ASCII to binary
	jae	conv10			;loop if digit
	mov	al, ah			;otherwise char was a 20h, 0Dh or 1Ah
	stosb				;es:[di++]:=al
	cbw				;ah:=0 (because all values are <=127)
	jp	conv20			;loop until end-of-file (1A-30=EA=odd)
	dec	di			;di = end of file (+1) and points to a 0
;(ax=0)
	inc	ax			;init MaxDist (via MinDist)
	xchg	bp, ax			;bp:=1 (0 can cause div-by-0 interrupt)
					;(largest value = 128^2/500/pi = 10.43)
;Load the palette
;bx=0 = first color register
;dx=FileBuf
	mov	ax, 1012h		;set block of color registers
	inc	cx			;cx:=0100h, number of color registers
	int	10h
;(ax<8000h)
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Fill screen with tiled textures
; ax = scratch
; bx = MaxDist = largest MinDist, pointer to coordinates in FileBuf
; cx = 100h -> 140h = 320, 2x loop
; dx = save distance, mul/div
; si = screen pointer
; di = address of end of coordinates (+1), points to 00/FF for version flipper
; bp = MinDist = (distance*2)^2 to nearest coordinate [0..(64*2)^2*2=32768]

tile00:	mov	bx, bp			;MaxDist:= MinDist
	xor	si, si			;reset screen pointer

;For all pixels in a tile, find the distance (*2^2) to the nearest coordinate
; in the input file and store it into MinDist (bp).
tile10:	push	bx			;save MaxDist
	mov	bx, FileBuf + 256*3	;point to coordinates in FileBuf
	mov	bp, 0A000h		;set MinDist to very large value that
	mov	es, bp			; just happens to = video memory :)

tile20:	cwd				;ax<8000h thus dx:=0
	mov	ax, si			;si / 320
	mov	cl, 40h			;cx:=140h = 320
	div	cx			;ax:=dx:ax/cx; dx:=rem

;Find the (warped/wrapped) distance (*2^2) between two points.
; Inputs: dl=X1, al=Y1, [bx]=X2, [bx+1]=Y2
; (Masking with 7Fh is unnecessary because MSB is shifted out.)
fn10:	xchg	ax, dx			;swap X1 & Y1 values; save partial dist
	sub	al, [bx]		;X1-X2 (and Y1-Y2)
	inc	bx
	shl	al, 1			;distance*2; extend bit 6 into bit 7
	imul	al			;squared; ax:=al*al
	dec	cx			;loop 2x, for X and Y (cl=3Fh, 3Eh)
	jp	fn10

	add	ax, dx			;distance*2^2 = (X1-X2)^2 + (Y1-Y2)^2
	cmp	ax, bp			;set MinDist to smallest value
	jae	fn20
	 xchg	bp, ax
fn20:
	mov	ax, 255			;set up for mul and clear MSB for cwd
	cmp	bx, di			;exit loop if EOF
	jb	tile20			;loop for all coordinates in FileBuf
	pop	bx			;restore MaxDist

	cmp	bp, bx			;put largest MinDist into MaxDist
	ja	tile00			; and start over
					;Color:= 255 * MinDist / MaxDist
	mul	bp			;dx:ax:= ax*bp
	div	bx			;ax:= dx:ax / bx
	xor	al, [di]		;display either version 1 or 2
;(ah=0)
	mov	es:[si], al		;display pixel
	inc	si			;loop for 64K pixels
	jne	tile10

	not	byte ptr [di]		;flip between versions 1 and 2
;(ah=0)
	int	16h			;get char from keyboard
	cmp	al, 20h			;if <space> then flip between
	je	tile10			; version 1 and version 2
					;jump if ax=3920h, which is < 8000h
	mov	ax, 0003h		;restore text mode
	int	10h
	ret				;return to DOS

	end	start
