; HC19 entry by Bonz

; 184 first working version
; 182 optimize distance calculation (TEST/JPO/XOR)
; 179 optimize assignments to CX at loop heaps
; 177 unify invert and vertical tile code
; 174 new, simpler file-reading loop
; 172 process [SI] a byte at a time (not a word)
; 170 draw twice, the first time to compute the maxdist
; 165 yet another file-reading loop, this time with FCBs
; 160 do vertical tiling while drawing
; 154 do 256 iterations per horizontal line (used to be 128)
; 153 do 512+200+4 instead of 128+200+4 iterations
; 152 avoid setting DS=ES
; 149 use executable code for DOS functions
; 147 use a guard to determine the end of the points
; 146 use XADD to execute the distance calculation twice

	org	100h
	
%ifndef DEBUG
%define VIDMODE 13h
%else
%define VIDMODE 3
	mov	cl, 0ffh		; Actually needs CL >= 0CEh
	mov	si, start		; SI must point to the DOS functions
	mov	bp, 91ah		; And BP>80h+3c8h (a bit less actually)
start:
%endif

	db	1ah, 0fh		; sbb cl, [bx] - clear CF
	db	14h, VIDMODE		; adc al, 13h

	int	10h
	
	mov	dx, 3c8h		; DTA address
	mov	di, dx
	
	mov	cl, 3			; number of DOS invocations we need
dos:
	lodsb				; get DOS function in AH
	mov	ah, al
	sub	[bx+5ch+14], bp		; record size = F6xxh bytes
	int	21h
	push	di			; push 3c8h three times
	mov	dx, 5ch			; FCB pointer for open and read funcs
	loop	dos

	pop	si			; SI points to DTA (DI already does)

 	cbw
	xchg	bp, ax			; BP=3 (mindist)
	xchg	bx, ax

read:
	mov	ah, -30h		; AH=D0xxh after whole file is read
	add	ah, [si]
	jc	accumulate		; If a digit, don't store anything
	jpo	no_store		; If LF or first iteration, do nothing
	stosb				; store accumulated value
no_store:
	xor	ax, ax			; reset accumulator
accumulate:	
	xchg	ah, al			; AH=old, AL=new
	aad				; AL=10*AH+AL, AH=0
	inc	si
	jns	read			; read until a 0

	; AX=0, BX=9xxh, CX=0, DX=5ch, BP=3, SI=8000h, DI=end of data

	pop	dx			; pop 3c8h again, this time for DAC
	out	dx, al			; reset the DAC
	inc	dx			; point to DAC data register

	xchg	si, ax			; AX=8000h
	stosw				; Store a signed guard after the data
	xchg	di, ax			; DI=starting address
	pop	si			; pop the third and final 3c8h
	mov	ch, 3			; Set CX=300h
	rep	outsb			; Output 256 colors to the palette


	; Usage of registers here
	;  AX = scratch in distance calculation
	;  BX = scratch in distance calculation
	;  CX = coord of current pixel (MSB's of CL/CH are bogus)
	;  DX = mindist for current pixel
	;  BP = maxdist so far (stabilizes after 256*128 iterations)
	;  SI = base of data
	;  DI = moves across VRAM
	;  SP = ahem, stack pointer

dist_buffer:
	mov	dh, 7fh			; infinity
	push	si			; save pointer to points

next_point:
	mov	bx, 0a000h
	mov	es, bx
next_coord:
	lodsb				; load x in AX
	sub	al, cl			; compute x2-x1
	test	al, 192			; check valid range (-64..63)
	jp	adjust
	add	al, 128			; adjust if wrong
adjust:
	imul	al			; compute square
	xchg	ch, cl			; invert X/Y
	xadd	ax, bx			; get distance^2 in AX
	js	next_coord		; first time AX=(x2-x1)^2+0a000h

	cmp	ax, dx			; DX holds mindist
	jae	bigger
	xchg	ax, dx
bigger:
	test	[si], sp		; test sign bit of the new point
	jns	next_point		; loop unless it is the guard (8000h)

	pop	si

	cmp	dx, bp			; BP holds maxdist
	jbe	smaller			; second time through
	mov	bp, dx			; we draw it right
smaller:

	mov	ax, 255			; AL=AX*255/maxdist
	imul	dx
	idiv	bp			; AH=0
	stosb
	mov	[es:di+7fh], al

	inc	cx			; increment coordinates
	test	cl, cl
	jnz	dist_buffer
	add	di, byte 64		; End of line, advance to the next
	cmp	di, -256
	jne	dist_buffer		; for the second time

	; Now AH=0, DI = FF00h

invert:
	not	byte [es:di]		; Invert (nothing visible the 1st time)
	inc	di			; Go on until DI = 0
	jnz	invert

	int	16h			; AH=0 either from above or below
	cbw				; set AH=0
	cmp	al, 20h
	je	invert		; if space, go above
	mov	al, 3
	int	10h
	ret
