;*************************************************************************
; Program:       ENTRY.COM
; Created by:    alexione
; Contact:       Aleksa Todorovic <alexione@eunet.yu>
; Started:       7. 9. 2002.
; Last modified: 10. 10. 2002.
; Description:   Hugi Compo #19 competition entry
; Compile with:  nasm -fbin -o entry.com entry.asm
;*************************************************************************

        org     100h

;*************************************************************************
startup:
        mov     ah, 0A0h
        stosw ; [-2] <- 0A000h, DI <- 0

        mov     cl, 13h
        mov     dh, 0Fh

int10:
        xchg    ax, cx ; first time: CL <- 0
        int     10h

        mov     al, 5Ch
        xchg    ax, dx

        int     21h ; first time: open FCB, second time: quit

        rol     byte [di + 5Ch + 0Eh], 1 ; set record size to 1
;*************************************************************************



;*************************************************************************
; [BX] -> buffer for numbers
process_file:
        mov     bh, 80h - 3
        mov     si, bx

.read_number:
        xor     ax, ax

.next_char:
        aad     10
        mov     [bx], al

        mov     ah, 14h
        int     21h

        mov     al, [0080h]
        mov     ah, [bx] ; last time, AH = 0
        sub     al, '0' ; 0A/0D/1A/20 -> DA/DD/EA/F0
        jns     .next_char

        jpo     $ + 3 ; skips if 0A or 1A
        inc     bx

        sub     al, 0EAh
        jnz     .read_number ; jumps if not 1A
;*************************************************************************



;*************************************************************************
set_palette:
        mov     dx, 3C8h
        out     dx, al
        inc     dx

        mov     ch, 3 ; CX <- 0300h
        rep     outsb

        pop     es
;*************************************************************************



;*************************************************************************
; Note: largest possible value for maxdist is (64 * 2)^2 * 2 = 8000h
init_maxdist:
        inc     ax ; AX <- 1

set_maxdist:
        xchg    si, ax

draw_screen:
        xor     di, di

.loop:
        push    bx
        mov     bp, sp ; BX = distBuffer(x,y) * 4

.loop_points:
        mov     ax, di
        xor     dx, dx

        mov     cx, 320 ; = 140h
        div     cx

.loop_xy:
        dec     bx
        sub     al, [bx]

        add     al, al
        imul    al
        xchg    ax, dx

        add     cl, cl ; CL <- 80/00
        jnz     .loop_xy

        add     ax, dx

        cmp     bp, ax
        jbe     $ + 3
        xchg    bp, ax

        dec     bx
        inc     bx
        jno     .loop_points

        pop     bx

        xchg    ax, bp
        cmp     si, ax
        jb      set_maxdist

        dec     cx ; CX <- 255
        mul     cx
        div     si ; AH <- 0
        xor     al, [bx]
        stosb

        test    di, di
        jnz     .loop

        not     byte [bx]
;*************************************************************************



;*************************************************************************
check_key:
        int     16h

        mov     cl, 3
        cwd ; DX <- 0

        cmp     al, 20h
        jne     int10

        jmp     short draw_screen
;*************************************************************************
