;===============================================;
;           ****  Hugi Compo 18  ****           ;
;-----------------------------------------------;
; Decimal to Roman / Roman to Decimal Converter ;
;             99 bytes - XCIX bytes             ;
;-----------------------------------------------;
;            by TFx / Spinning Kids             ;
;                tfx3@libero.it                 ;
;===============================================;

; Compile:                                      
;       tasm -m2 entry.asm
;       tlink -t entry

        MODEL TINY
        CODESEG
        STARTUPCODE
        .386

bptr  	EQU <BYTE PTR>
wptr  	EQU <WORD PTR>

Start: 
		or 	ax,240Ah 		;db 0Dh, 0Ah, 24h	 :)))
		
		;***** get line from standard input *****;
GetLine:
		mov di,bp			;offset Input Buffer
GetChar:
		mov ah,07h
		int 21h				;get char 			
		stosb				;save char
				
		sub al,1Ah			;if char=1A...
		je  Exit			;...exit program
		jg  GetChar			;end of input line?

		sub di,bp			;calc input length
		xchg di,ax			;offset Roman String Buffer
		pusha
		rep movsb			;store 0D 0A 24 and D2RTab
		popa
		mov bx,0845h		;offset D2RTab
		mov cx,3999			;init counter
Rloop:
		pusha				
		xchg ax,cx
		
		;***** convert counter to Decimal *****;
NextDigit:
		cwd
		div wptr [bx-1]		;calc digit
		xchg ax,dx			
		dec si
		mov [si],al			
		add bptr [si],'0'	;save digit to Decimal String Buffer
		
		;***** convert Decimal to Roman *****;
L1:
		xlat				;get table entry
		aam 16				;split entry
		sub ax,si			;roman digit correction
		xlat				;get first char
		dec di
		mov [di],al			;save char to Roman String Buffer
		mov al,ah			;next char
		jnc L1				

		inc di				;discard last char
		and ax,dx			;no more digits?
		jnz NextDigit

		;***** compare input string and the generated one *****;
		
		xchg ax,bp			;offset Input Buffer
		xchg ax,di			;offset Roman String Buffer

		add bl,[di]			;if input is numeric...
		jns Comp			;...compare Input Buffer and Decimal String...
		xchg ax,si			;...else compare Input Buffer and Roman String
Comp: 
		rep cmpsb			;compare
		jne NotEq				
		
		;***** output the converted string *****;

		xchg ax,dx			;dx=offset string to print
		mov ah,9
		int 21h				;print string
NotEq:
		popa
		loop Rloop
		push si				;if counter=0 go to Start 
Exit:
		ret

		db  0Ah
D2RTab:
		db  00, 19h, 29h, 39h, 2Dh, 1Dh, 69h, 79h, 89h, 2Ah
RomChr:
		db  'IXCMVLD'	

		END	
