;--------------------------------------------------------------------
;                            "TRANS-ADOK"
;
; Suggestion for the Hugi size compo #15 by TAD ( tad_uk@bigfoot.com )
; Fixed by Bonz
;--------------------------------------------------------------------
; compile:
;       nasm -fbin -oeg2.com eg2.asm
;
; usage:
;       example <infile.bmp>  <outfile.bmp>
;--------------------------------------------------------------------
;
; This loads a 128x128 greyscale BMP file, and using keys '0...9'
; transforms/translates the image. The [ ] space key will save the
; result to the <outfile> then quit to DOS.
;
; The keys make sense if you look at the keypad (NUMLOCK ON!)
;                                       Ŀ
;                                       rotate  move  rotate 
;                                        +180'   /\    +90' 
;                                                           
;                   Ŀ             Ĵ
;                   789               move         move  
;                   Ĵ             < x-flip  >
;                   456                                  
;                   Ĵ             Ĵ
;                   123             rotate       rotate 
;                   Ĵ              -180'   \/    -90' 
;                    0 .                     move   (270) 
;                                Ĵ
;                                                             
;                                            y-flip     unused
;  [SPACE BAR ]  === QUIT !!!                                 
;                                       
;--------------------------------------------------------------------

BMP_FILESIZE    equ     17462

        org     256
go:
        mov     bp, 0082h
        call    ScanFilename

        ;; keep [SS:BP] for later <outfile> ;;
        push    bp

        ;; open <input> file ;;
        mov     dx, ax
        mov     ax, 3D00h
        int     21h
        mov     [filehandle], ax

        ;; read <input> file ;;
        mov     dx, bmpbuffer
        mov     cx, BMP_FILESIZE
        mov     bx, [filehandle]
        mov     ah, 3Fh
        int     21h

        ;; close <input> file ;;
        mov     bx, [filehandle]
        mov     ah, 3Eh
        int     21h

        ;; set mode 13 hex (320 x 200 x 256c) ;;
        mov     al, 13h
        mov     ah, 00h
        int     10h

        ;; set RGB palette (8 bit --> 6 bit VGA) ;;

        mov     dx, 3C8h
        mov     al, 0
        out     dx, al
        inc     dx
        lea     si, [bmppalette]
        mov     cx, 256
setpalt:
        mov     al, [si+2]
        shr     al, 2
        out     dx, al
        mov     al, [si+1]
        shr     al, 2
        out     dx, al
        mov     al, [si]
        shr     al, 2
        out     dx, al
        add     si, byte 4
        loop    setpalt

;;-------------------------------------------------------------------
; Main loop
;;-------------------------------------------------------------------
MainLoop:
        ;; Display image on screen ;;
        call    DrawBitmap

        ;; read <key> from STDIN ;;
        mov     ah, 08h
        int     21h

        ;; check for quit [SPACE] key ;;

        cmp     al, 32
        jz      DoQuit

        ;; check for other commands ;;

        sub     al, '0'
        cmp     al, 9
        ja      MainLoop                ; not '0...9' ?
        mov     ah, 6
        mul     ah
        add     ax, transforms
        mov     bp, ax                  ; [SS:BP] --> trans[form/late]

        mov     si, bmpimage     ; [DS:SI] --> 128x128 image
        push    DS
        pop     ES
        mov     di, workspace    ; [ES:DI] --> 128x128 temp

        call    TransImage

        ;; copy temp image --> BMP image ;;

        mov     si, workspace
        mov     di, bmpimage
        mov     cx, (128 * 128)
        rep     movsb

        jmp     MainLoop


;--------------------------------------------------------------------
; Quit - Save BMP <output> file then exit to DOS ;;
;--------------------------------------------------------------------
DoQuit:
        ;; restore BP and scan <outfile> from command-line ;;
        pop     bp
        call    ScanFilename

        ;; Create <output> file ;;
        mov     dx, ax
        mov     cx, 0000h
        mov     ah, 3Ch
        int     21h
        mov     [filehandle], ax

        ;; write <output> file ;;
        mov     dx, bmpbuffer
        mov     cx, BMP_FILESIZE
        mov     bx, [filehandle]
        mov     ah, 40h
        int     21h
        ;; close <output> file ;;
        mov     bx, [filehandle]
        mov     ah, 3Eh
        int     21h

        ;; text mode 3 ;;
        mov     al, 03h
        mov     ah, 00h
        int     10h

        ;; quit to DOS ;;
        mov     al, 00h
        mov     ah, 4Ch
        int     21h

;--------------------------------------------------------------------
; [DS:AX] = scan & mark end of command-line filename[SS:BP]
;--------------------------------------------------------------------
ScanFilename:
        mov     ax, bp
FindSpace:
        inc     bp
        cmp     byte [bp-1], 20h
        ja      short FindSpace
	dec	bp
        mov     byte [bp], 00h
FindNext:
        inc     bp
        cmp     byte [bp], 20h
        jbe     short FindNext
        ret

;--------------------------------------------------------------------
; Draw Bitmap on VGA screen (note: BMP image is upside down!!)
;--------------------------------------------------------------------
DrawBitmap:
        mov     ax, 0A000h
        mov     ES, ax
        mov     di, (320*36)+96         ; [ES:DI] --> screen(x:96,y:36)

        lea     si, [bmpimage+(128*127)]  ; [DS:SI] --> line 127 of BMP image

        mov     dl, 128                 ; 128 lines to copy
@@1:
        mov     cx, 128
        rep     movsb                   ; copy 1 line of BMP to screen
        add     di, (320 - 128)         ; next screen line
        sub     si, (128 + 128)         ; prev line of BMP image
        dec     dl
        jnz     short @@1
        ret

;--------------------------------------------------------------------
; Transform/Translate image[DS:SI] into[ES:DI] using matrix[SS:BP]
;--------------------------------------------------------------------
TransImage:
        mov     dh, 0           ; Y coord
Y_loop:
        mov     dl, 0           ; X coord
X_loop:
        ;; rotate(x,y) using matrix values XX,XY,YX,YY ;;
        ;;
        ;; x' = x * XX - y * XY
        ;; y' = x * YX + y * YY
        ;;

        mov     al,[bp+_XX]
        imul     dl
        mov     bl, al          ; x' = x * XX ...
        mov     al,[bp+_XY]
        imul    dh
        sub     bl, al          ;               - y * XY

        mov     al,[bp+_YX]
        imul    dl
        mov     bh, al          ; y' = x * YX
        mov     al,[bp+_YY]
        imul    dh
        add     bh, al          ;               + y * YY

        ;; translate(x,y) using matrix values H and V ;;
        ;;
        ;; x' = x + H
        ;; y' = y + V

        add     bl, [bp+_H]
        add     bh, [bp+_V]

        ;; wrap(nx,ny) to 0...127, 0...127 decimal ;;

        and     bl, 127
        and     bh, 127

        ;; calc source pixel address ;;

        shl     bl, 1           ; \ bx = bh * 128 + bl  :)
        shr     bx, 1           ; /

        mov     al, [si+bx]
        stosb
        inc     dl
        cmp     dl, 128
        jnz     short X_loop

        inc     dh
        cmp     dh, 128
        jnz     short Y_loop
        ret

;--------------------------------------------------------------------
; This is a matrix of mulipliers (XX,XY,YX,YY) and displacements
; used by the TransImage routine.
;--------------------------------------------------------------------
; the XX,XY and YX,YY pairs are the values for the standard 2d-rotate
; method:-
;       nx = x * cos(a)  -  y * sin(a)
;       ny = x * sin(a)  +  y * cos(a)
;
; Don't worry about the strange values... remember the BMP is
; stored UPSIDE-DOWN !!
;--------------------------------------------------------------------

section .data

_XX     equ     0
_XY     equ     1
_YX     equ     2
_YY     equ     3
_H      equ     4
_V      equ     5

;                       XX XY YX YY      H  V
transforms      db       1, 0, 0,-1,     0,-1   ; [0] y-flip
                db      -1, 0, 0,-1,    -1,-1   ; [1] rotate +180
                db       1, 0, 0, 1,     0, 1   ; [2] move down
                db       0, 1, 1, 0,    -1, 0   ; [3] rotate +90
                db       1, 0, 0, 1,     1, 0   ; [4] move left
                db      -1, 0, 0, 1,    -1, 0   ; [5] x-flip
                db       1, 0, 0, 1,    -1, 0   ; [6] move right
                db      -1, 0, 0,-1,    -1,-1   ; [7] rotate -180
                db       1, 0, 0, 1,     0,-1   ; [8] move up
                db       0,-1,-1, 0,     0,-1   ; [9] rotate -90 (270)

; ---------------------------------------------------------------

section .bss
filehandle:	resw 1
bmpbuffer:	resb 36h 
bmppalette:	resb 256*4
bmpimage:		resb 16384
workspace:	resb 128*128

