;------------------------------------------------------------------------------
; File: entry.asm
;
; Copyright (c) 2000, 2001 Guido Hahn. All Rights Reserved.
; meph@searchand-find.de
;
; This file was written for the Hugi Size Coding Competition #15: 
; on http://www.hugi.de/compo/
;
; ALIAS:    meph
; Country:  Germany
; Date:     10-13-2001               
; Compiler: ml (MASM) 6.15.8803	          
; Linker:   link (Segmented Linker) 5.60.339       
;                               
; ml /AT /Fl"entry.lst" entry.asm
;
; Size: 140 Bytes
; 
; THIS SOFTWARE IS PROVIDED BY GUIDO HAHN ``AS IS AND WITHOUT
; ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
; IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
; SUCH DAMAGE.
;
;------------------------------------------------------------------------------

;<snip>
;You may assume that
;  ... the registers have these values (all in hex):
;      (xx - means an unknown value which MUST NOT be assumed)
;
;          EAX = xxxx****
;                AL = 00 if first FCB has valid drive letter,  FF if not
;                AH = 00 if second FCB has valid drive letter, FF if not
;          EBX = xxxx0000
;          ECX = xxxx00FF
;          EDX = xxxxxxxx
;  DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;          ESI = xxxx0100
;          EDI = xxxxFFFE
;          EBP = xxxx09xx
;          ESP = xxxxFFFE
;          EIP = xxxx0100
;
;  EFLAGS (binary) = xxxxxxxx xxxxxxxx xxxx0x1x xx0x0x1x
;      i.e.
;          DF = 0
;          IF = 1
;          other flags = x
;
;          WORD [FFFE] = 0000
;          Layout of PSP: see [Memory Layout]
;<snip>

.586

deb_startup macro     ;;initialize register values				
      xor ax, ax
      xor bx, bx	
      mov cx, 0ffh
      mov dx, cs
      mov es, dx
      mov si, 100h
      mov di, 0fffeh
      mov sp, di
      mov bp, 0912h
      cld
endm

MakeTransform macro rot1, flip, move, rot2
  db rot1 or (flip shl 3) or (move shl 4) or (rot2 shl 5)
endm

setalc equ db 0d6h

FileBuffer    = 03c8h
FileSize      = 17462
ImageFileData = FileBuffer + 1078
ImageFileDataSize = 128*128

TmpImage      = FileBuffer+FileSize

VGASegment  = 0a000h + (35*320+96)/16
TopLeft     = 320
TopRight    = TopLeft + 127
BottomLeft  = TopLeft + 127*320
BottomRight = BottomLeft + 127


_cseg segment para public 'code' use16
assume cs:_cseg, ds:_cseg, es:_cseg, ss:_cseg
_cseg ends

_cseg segment
org 100h										
start:	  
ifdef DEBUG                    
    deb_startup
endif                       
    push 13h                            ;prepare switch to vidmode 13h      
    push 0082h                          ;offset of first filename
       
    mov bh, 3fh                         ;read file

fileio:
    push ds                            
    pop es
    xor ax, 3d20h                       ;open file    = 0000h xor 3d20h = 3d20h
                                        ;create file  = 0100h xor 3d20h = 3c20h
    mov sp, 0fffah
    pop di                              ;load offset of file name 
    mov dx, di                          ;dx=offset of filename
@@:  
    scasb
    jb @B    
    mov byte ptr[di-1], ch              ;terminate filename with zero   

    repe scasb                          ;skip spaces        
   
    int 21h                             ;open/create file
    xchg ax, bx                         ;bx=handle, ah=3fh/40h   
    sahf                                ;move ah into flags, ah=3fh/40h 
                                        ;(zf=0/zf=1) flag set
    
    mov cx, FileSize
    mov dx, FileBuffer
    int 21h                             ;read/write from/to file    

    pop ax                              ;set vidmode 13h/03h
    int 10h                             ;       "           
    jnz short setpal                    ;was write ? -> exit
exit:
    ret                                 ;return to dos    

setpal:   
    setalc                              ;cf=0 -> mov al, 0
                                        ;after a mode switch the index port 
                                        ;is reset to 0, that's where I start
                                        ;to fill the palette
    out dx, al
    inc dx
    
nextval:
    mov cx, 12

@@:
    out dx, al    
    loop @B
    inc ax   
    jns nextval                         ;write some values to void
    
    dec di
    push 03h                            ;prepare switch to vidmode 03h    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Table of transformation instructions, the final transformation is the 
; concatanation of rotation, flip, move and rotation.
; Base transforms are: rot0 - 90 deg rotation
;                      flip - flip
;                      move - downward modulo 128 translation
;                      rot1 - 90 deg rotation
;
; Note: since the rotation algorithmus is a do ... while loop, there is at least
;       one rotation. 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Ok, the idea is same as explained above. Unluckily the bitmaps have changed
; every time I have changed the algorithm. Because I'm too lazy to manual set 
; and clear bits inside the transformation bitmaps, I've written a programm 
; which finds all valid transformation for a given algorithm. That's the reason 
; I do not longer know how parts of the transformation work; I only know the  
; final result is as desired. :-))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
;
; Here is my choosen table, some bytes do usefull things, it saves three bytes.    
;
transforms:
    push di                             ;save offset of second filename
                                        ;db 057h 0 - vertically flip
mainloop:
    clc                                 ;db 0f8h 1 - rotate -180 deg
    sbb bl, bl                          ;bl=0
                                        ;db 01ah 2 - move down
                                        ;db 0dbh 3 - rotate -90 deg
    dec di                              ;db 04fh 4 - move left
    mov al, 073h                        ;db 0b0h 5 - horizontally flip
                                        ;db 073h 6 - move right
    test al, 0a7h                       ;db 0a8h 7 - rotate -180 deg 
                                        ;db 0a7h 8 - move up 
    mov ah, 08h                         ;prepare read from stdin:
                                        ;we aren't in text mode, so it doesn't
                                        ;matter to read with echo 
                                        ;db 0b4h 9 - rotate +90 deg

update:
    push VGASegment 
    pop es

    mov si, ImageFileData
    mov di, BottomLeft    
copyline:                               ;fill screen buffer and TmpImage
    mov cl, 128
@@:
    lodsb
    push ax                             ;store pixel on stack
    stosb
    loop @B
    
    sub di, 320+128
    jnz copyline

    int 21h                             ;read key from stdin

    aam 20h
    mov bh, 40h 
    jz fileio                           ;if jump is taken: ax=0100h
    add al, low(offset transforms -10h)
    xchg ax, di
    mov al, byte ptr[di]
        
    sub si, bx                          ;si=ImageFileData                  
                                       

next:
    dec bx
    js mainloop
    pop dx                              ;load pixel from stack
    pusha                               ;push bx, push ax             
    shl bx, 1                           ;extract x/y
    
rotation:    
    shr bl, 1                           ;bl = x, bh = y
jumpinrot:
    xchg bh, bl                         ;swap x/y    
    
    shl bl, 1                           ;this line replaces in combination 
                                        ;with 'shr bl,1' an 'and bl,7fh' 
                                        ;instruction. Additional this is the
                                        ;first instruction for remapping bx.
                                        ;see at mappixel 
                                        ;
doflip:       
    not bl                              ;bl = y'=- x; bh = x'=y                              
shift:
    shl al, 1  
    jc rotation
    jz short mappixel

flip:
    js doflip

move:
    inc bl
    jmp shift
    
    
mappixel: 
    shr bx, 1
                      
    mov byte ptr[si+bx], dl             ;store pixel into ImageFileData
    popa                                ;pop ax, pop bx    
    jmp next    
_cseg ends

end start