comment `====================================================================
Hugi Compo 15, by Sebastien Savatier (sebastien.savatier@lyon.msi-sa.fr).
Size : 138 bytes (a little bit disapointed, expected to do better).
----------------------------------------------------------------------------`
		.model tiny
		.386
		.CODE
		org 100h
start:		;
comment `====================================================================
Global areas
----------------------------------------------------------------------------`
bmp1		equ 4000h
fileheader	equ bmp1-1078		; 1078=436h
bmp2		equ bmp1+16384		; 8000h

comment `====================================================================
Set vdo mode 13
----------------------------------------------------------------------------`
		mov al,13h		; ah=0
		int 10h

comment `====================================================================
Open and read source file, using common subroutine with create and write.
----------------------------------------------------------------------------`
		mov di,82h
		mov ax,3D20h		; open read-only (and al=20 !)
		mov bh,3Fh		; read
		call filesub
		push di 		; saved for write file at exit
		; ax=cx=17462 (4436h)
		; dx=fileheader (3BCAh) (dx+ax=8000h)
		; bh=0, bl=xx (usualy 5)
		; di=00xx si=0100

comment `====================================================================
Set palette.
I'm not completly satisfied, but I love the "adc al,40h" to increment low
part of al once on four times.
Having to use "dec si" for loop control is painfull ...
I thought to save the 'mov dx,3C8' using fileheader=3C8, but it didn't save
bytes, making other optimizations impossible ...
----------------------------------------------------------------------------`
		mov dx,3C8h
		xor ax,ax		; clears CY
		out dx,al
		inc dx
		; CY must be clear before loop (ok)
b1_pal: 	adc al,40h
		out dx,al
		out dx,al
		out dx,al
		dec si
		jnz b1_pal
		; ax=003F bx=00xx cx=4436 dx=03C9 si=0 di=00xx CY

comment `====================================================================
Copy bitmap from bmp1 to vdo, upside-down.
Heavy job. Many manners to do it, none realy better ...
I choosed to proceed as follow :
Set first line of memory bitmap to last line on screen, and so on.
Use DI for loop control : on each loop, DI will be decreased by 320.
So, initializing DI to 128*320, will run DI to 0 after last line copied and
DI decreased. We just need to initialize ES with correct value, and it works.
----------------------------------------------------------------------------`
display:	;
		push es 			; save es
		push 0A2C2h			; so that es:di=last line
		pop es
		mov di,0A000h			; 128*320
		mov si,bmp1
b1_out: 	mov cx,64
		rep movsw
		sub di,128+320
		jnz b1_out
		; si=8000 (bmp1+16384), di=0, cx=0
		pop es				; restore es
		shr si,1			; -> si=4000 (bmp1)
		; We save si=4000 (used at exit to set bh=40, and used after
		; transform to put back bitmap to bmp1)
		push si

comment `====================================================================
Wait input and test space to exit.
----------------------------------------------------------------------------`
		; Wait input
		mov ah,8
		int 21h
		cmp al,20h	; space
		je exit 	; write bitmap and exit
		; CF is alway cleared by cmp if AL is a digit
		xchg ax,bp	; -> bp=083x

comment `====================================================================
Perform transform.
Uses CX as source coordinates (CH=y, CL=2*x), and compute BX=target
coordinates, using a suite of 1 to 8 basic transforms, parametrized by
the byte of trtable corresponding to the digit key pressed.
These are memory coordinates, not screen (y is reversed).
The elementary transforms used are :
    - flip diagonaly
    - rotate right (not y + flip diag)
    - shift left and rotate right
but they are scheduled using only one bit of AL at the time, using indirectly
the value of the previous high bit, via CF. I had to do a test program to
find a set of elementary transforms that permits all the final transforms
required for some values of the 'scheduler' byte !
----------------------------------------------------------------------------`
		; cx=0, si=bmp1, di=0 (not used), bp=083x, NC
b1_trans:	mov bx,cx
		mov al,trtable[bp-830h] 	; 'scheduler' byte from table
b2_trans:	cbw				; -> ah=FF or 00
		adc bl,ah			; dec x if NC and ah=FF
		xor bh,ah			; not y if ah=FF
		xchg bl,bh			; flip diagonaly
		; Re-normalize bh=y bl=2*x after xchg
		shr bh,1
		shl bl,1
		; ? another transform to perform
		shl al,1			; -> CF=lost high bit
		jnz b2_trans
		; Here, we always have CY. We transform bx to address in bmp2
		; by shifting right and setting high bit (bmp2=8000h), and
		; thus clearing CF.
		rcr bx,1
		; Transfer one pixel and loop
		lodsb
		mov [bx],al
		inc cx				; double-inc because cl=2*x
		inc cx
		jns b1_trans
		; cx=8000, si=bmp1+16384 (bmp2)

		; Put back transformed bitmap to bmp1
		pop di			; =bmp1, saved after display
		; cx=8000h, so we will copy too much, but who cares ?
		rep movsb
		; cx=0 si=0 di=C000
		; Loop to display
		jmp display

comment `====================================================================
Transforms table.
When more than one value where possible, I chosed the one that had the most
low bits at 0 (less loop during transform).
----------------------------------------------------------------------------`
trtable 	db  064h	; 0 vflip
		db  074h	; 1 drot
		db  0C9h	; 2 movdown
		db  0C8h	; 3 rrot
		db  0F0h	; 4 movleft
		db  067h	; 5 hflip
		db  0EBh	; 6 movright
		db  074h	; 7 drot
		db  093h	; 8 movup
		db  0CEh	; 9 lrot

comment `====================================================================
Save final bitmap and exit.
Returning to mode 3 is not requested.
----------------------------------------------------------------------------`
exit:		;
		pop bx			; saved bmp1 -> bh=40 (write)
		pop di			; address of dest filename
		; al is already 20h ("space to quit")
		mov ah,3Ch		; first operation will be create
		; Low 3 bits of cl must be zero (attribs for create) !
		; There is always true (cx=0 after display).

filesub:	; Common code with open/read
		; On entry : al=20h, di=points to space or begin of filename
		; ah=open (3D) or create (3C)
		; bh=read (3F) or write  (40)
		; First, skip spaces befor file name
b1_fsub:	mov dx,di
		scasb
		je b1_fsub
		; Then scan to the end of file name (may be space or 0D), and
		; set a nul.
b2_sub: 	scasb
		jb b2_sub
		mov [di-1],dh		; dh=0
		int 21h 		; open or create
		xchg ax,bx		; sets ah=bh (3F or 40) and bx=handle
		mov cx,17462		; size to read or write
		mov dx,fileheader	; address to read or write
		int 21h
		; Return if called for open/read, terminates program at exit
		; because returns to 0 (first word on stack), whitch contains
		; an int 20h.
		ret

comment `====================================================================
That's all.
----------------------------------------------------------------------------`
		end start
