;--------------------------------------------------------------------
; 18.09.2001	267
; 19.09.2001	258
;--------------------------------------------------------------------

.model tiny
.code
.386

BMP_FILESIZE	equ	17462

org	100h

start:
	; set mode 13h 
	mov	al, 13h			
	int	10h			

	mov	di, 0082h		
	call	ZeroTerminate
@@findnext:
	inc	di
	cmp	byte ptr [di], 20h
	jbe	short @@findnext


	; open input file
	mov	cx, BMP_FILESIZE	
	push	cx
	mov	ah, 3Dh
	int	21h			

	xchg	bx, ax			

	; read input file
	mov	dx, offset bmpfilebuf
	push	dx
	mov	ah, 3Fh			
	int	21h			

	call	ZeroTerminate
	push	dx

	; convert translation matrices 15byes=>60bytes.
	; must be done in less than 45 bytes then some bytes are saved
	mov	si, offset trans1			; 3
	mov	di, offset transforms			; 3
	@@loop_i:
		lodsb					; 1
		mov	cx, 4				; 3
		xchg	ax, bx				; 1
		@@loop_j:
			xor	dx, dx			; 2
			shr	bx, 1			; 2
			adc	dl, 0			; 3
			shr	bx, 1			; 2
			jnc	@@okas			; 2
				neg	dx		; 2
			@@okas:

			xchg	ax, dx			; 1
			stosb				; 1
			loop	@@loop_j		; 2

		cmp	si, offset trans1 + 15		; 3
		jl	@@loop_i			; 2
							;   33  :)

	; set RGB palette
	xor	ax, ax			
	mov	dx, 3C8h		
	out	dx, al			
	inc	dx			

@@setpalette:
	mov	cl, 12
@@pal:
	out	dx, al			
	loop	short @@pal		
	inc	al			
	jnz	short @@setpalette	

;;-------------------------------------------------------------------
; Main loop
;;-------------------------------------------------------------------
@@mainloop:
	; Display image on screen

	push	0a000h			
	pop	es			
	mov	di, (320*(36+128))+96	; [ES:DI] --> screen(x:96,y:36)
	mov	si, bmpimgbuf		; [DS:SI] --> line 127 of BMP image
	mov	dl, 128                 ; 128 lines to copy
@@1:
	mov	cl, 128			; 
	rep	movsb			; copy 1 line of BMP to screen
	sub	di, (320 + 128)         ; next screen line
	dec	dl			  
	jnz	short @@1		




	; read key from STDIN
	mov	ah, 08h			
	int	21h			

	; check for quit [SPACE] key ;;

	cmp	al, ' ' ;20h		
	jz	short @@finish		

	; check for other commands ;;
	sub	al, '0'			
	mov	ah, 6			 
	mul	ah			

	add	ax, offset transforms	
	xchg	si, ax			 

	mov	bp, offset bmpimgbuf	; [DS:bp] --> 128x128 image
	push	bp			; save it for later use
	push	DS			;
	pop	ES			; don't need 0a000h anymore
	mov	di, offset workspace	; [ES:DI] --> 128x128 temp
	push	di			; save it for later use



	mov	dh, 0	; Y coord
@@Y:
		mov	dl, 0	; X coord
	@@X:
	; save SI , because lods will change this
		push	si
	; rotate(x,y) using matrix values XX,XY,YX,YY ;;
	;
	; x' = x * XX - y * XY
	; y' = x * YX + y * YY
	;
		lodsb
		imul	dl
		XCHG	BX, AX		; x' = x * XX ...
		lodsb
		imul	dh
		sub	bl, al		;		- y * XY

		lodsb
		imul	dl
		mov	bh, al		; y' = x * YX
		lodsb
		imul	dh
		add	bh, al		;               + y * YY

	; translate(x,y) using matrix values H and V ;;
	;
	; x' = x + H
	; y' = y + V

		lodsw
		add	bl, al
		add	bh, ah

	; wrap(nx,ny) to 0...127, 0...127 decimal ;;

		and	bx, 07f7fh

	; calc source pixel address ;;

		shl	bl, 1           ; \ bx = bh * 128 + bl  :)
		shr	bx, 1           ; /
		add	bx, bp	
		mov	al, [bx]
		pop	si		
		stosb			
		inc	dl		
		cmp	dl, 128		
		jnz	short @@X	

	inc	dh			
	cmp	dh, 128			
	jnz	short @@Y		

	;; copy temp image --> BMP image ;;

	pop	si
	pop	di
	mov	cx, (128 * 128)
	rep	movsb

	jmp	short @@mainloop	


;--------------------------------------------------------------------
; Save output file and exit to DOS
;--------------------------------------------------------------------
@@finish:
	; restore DI and scan outfile from command-line
	pop	dx

	; Create output file
	xor	cx, cx			
	mov	ah, 3Ch			
	int	21h			

	xchg	ax, bx		; file handle is returned in ax, 
				; needed in bx

	; write output file
	pop	dx
	pop	cx
	mov	ah, 40h			
	int	21h			

	; close output file
	mov	ah, 3Eh			
	int	21h			

	; text mode 3 ;
	mov	ax, 0003h		
	int	10h			

	; quit to DOS
	ret				

;--------------------------------------------------------------------
; Zero terminate filename
;--------------------------------------------------------------------
ZeroTerminate:
        mov     dx, di
@@findspace:
        inc     di
        cmp     byte ptr [di-1], 20h
        ja      short @@findspace
	dec	di
        mov     byte ptr [di], 00h
        ret

;;--------------------------------------------------------------------
; This will be converted to what you can see in the comments below 
; "transforms". 15 bytes - this leaves us 45 bytes for code to convert
; it. 
;;--------------------------------------------------------------------
trans1	dw	0011110011000001b 	
	dw	0100000111111100b 	
	dw	0011000101000100b 	
	dw	0011000101000001b 	
	dw	0100000100110100b 	
	dw	1111110000110011b 	
	dw	1100110001000001b 	
	db	11000011b	 	

; 20 bytes ; 00 = 0, 01 = 1, 11 = -1
;trans1	dw	0000110011000001b 	; [0]
;	dw	0000111111000011b 	; [1]
;	dw	0000010001000001b 	; [2] *
;	dw	0000001100010100b 	; [3]
;	dw	0000000101000001b 	; [4] *
;	dw	0000001101000011b 	; [5]
;	dw	0000001101000001b 	; [6] *
;	dw	0000111111000011b 	; [7]
;	dw	0000110001000001b 	; [8] *
;	dw	0000110000111100b 	; [9]


;;--------------------------------------------------------------------
; This is a matrix of mulipliers (XX,XY,YX,YY) and displacements
; used by the TransImage routine.
;--------------------------------------------------------------------
; the XX,XY and YX,YY pairs are the values for the standard 2d-rotate
; method:-
;       nx = x * cos(a)  -  y * sin(a)
;       ny = x * sin(a)  +  y * cos(a)
;
; Don't worry about the strange values... remember the BMP is
; stored UPSIDE-DOWN !!
;--------------------------------------------------------------------
transforms:	db 80 dup(?)
; 60 bytes
;                       XX XY YX YY      H  V
;transforms      db       1, 0, 0,-1,     0,-1   ; [0] y-flip
;                db      -1, 0, 0,-1,    -1,-1   ; [1] rotate +180
;                db       1, 0, 0, 1,     0, 1   ; [2] move down
;                db       0, 1, 1, 0,    -1, 0   ; [3] rotate +90
;                db       1, 0, 0, 1,     1, 0   ; [4] move left
;                db      -1, 0, 0, 1,    -1, 0   ; [5] x-flip
;                db       1, 0, 0, 1,    -1, 0   ; [6] move right
;                db      -1, 0, 0,-1,    -1,-1   ; [7] rotate -180
;                db       1, 0, 0, 1,     0,-1   ; [8] move up
;                db       0,-1,-1, 0,     0,-1   ; [9] rotate -90 (270)
;
; ---------------------------------------------------------------

bmpfilebuf:	db BMP_FILESIZE-128*128 dup(?)
bmpimgbuf:	db 128*128 dup(?)
workspace:	db 128*128 dup(?)

end start