; Entry in the Hugi size compo #15
;
; Author: GreenGhost
;
; Compile with: nasm entry.asm -oentry.com

;set some constants
  FileSize equ 17462
  HeaderSize equ 1078
  ImageSize equ 128*128

;place the work area at a convenient place in memory
  Image equ 4000h
  FileBuffer equ Image-HeaderSize
  Buffer equ Image+ImageSize

org 256

Main:

  mov di,82h			;pointer to command line
  mov bx,3F3Dh			;codes for read and open
  call Setup			;set mode and read file
  push di				;store pointer for later

Work:

;draw image, set palette and copy to buffer
  push word 0A2D6h		;image position on screen
  pop es				;into es
  mov si,Image			;image from file
  mov di,127*320			;last line of screen image
  .NextLine:
    xor dx,dx			;set counter 0
    .NextCol:
      mov cx,12			;set 4 palette colors
      xchg dx,ax			;counter in ax
      mov dx,03C9h			;palette port
      .NextRGB:
        out dx,al
      loop .NextRGB
      xchg dx,ax			;counter back to dx
      lodsb				;get pixel
      stosb				;draw on screen
      mov [si+ImageSize-1],al		;copy to buffer
      inc dl
    jns .NextCol			;until dl=128
    sub di,320+128			;move to line above
  jae .NextLine			;until di<0
  push ds				;restore original es
  pop es

  ;si now points to buffer
  ;dx is 0080h
  ;cx is 0 (used as x & y below, or as file attribute)

;read key
  mov ah,08h
  int 21h

;check for space
  aam 20h				;ax=0100h (for space) or 0110h-0119h (for 0-9)
  jz Done				;quit if al=0

 ;transform
  xchg bp,ax			;offset to transformation code in bp
  .Next:

    mov bx,cx			;copy x & y
    mov ah,[byte bp+Trans-110h]	;get transformation code
    .NextTrans:
      shl ah,1			;get swap/subtract flag
      jc .NoSwap
        xchg bl,bh			;swap x & y
      .NoSwap
      sbb bl,dh			;subtract 1 from x if bit was set (dh is 0)
      shl ah,1			;get not flag
      salc				;sets al to 0 or FFh
      xor bl,al			;not x if bit was set
      shl ah,1			;get continue flag
    jc .NextTrans			;repeat until 0

    or bh,dl			;mask y and add 80h (will be 40h after shift)
    shl bl,1				;mask x
    shr bx,1			;x+y*128+4000h (points into image)
    lodsb				;get pixel
    mov [bx],al			;store in image

    inc cl				;x++
  jns .Next			;check if x=128
    add cx,dx			;x=0, y++
  jns .Next			;check if y=128
  jmp short Work

Trans:
  db 01100000b
  db 01101000b
  db 00110100b
  db 00101100b
  db 10000000b
  db 00101000b
  db 00101111b
  db 01101000b
  db 01111100b
;  db 01000000b	pop di = 5Fh = 01011111b works just as well

Done:

  pop di			;restore pointer
  mov bx,403Ch		;codes for write and create

Setup:

;set mode
  aad 10h			;makes ax=0010h or 0000h
  xor al,13h		;choose screen mode
  int 10h			;set screen mode

;get filename
  mov dx,di		;copy pointer to filename
  mov al,32		;space
  .NextChar:
    scasb			;check for space/cr
  jc .NextChar		;loop if >32
  mov [di-1],ah		;zero terminate filename
  rep scasb		;skip spaces to next filename
  dec di			;adjust to point to start of filename

;open/create
  mov ah,bl
  int 21h
  xchg bx,ax		;bx=handle, ah=cmd from bh (read/write)

;read/write
  mov dx,FileBuffer		;point to data area
  mov cx,FileSize
  int 21h

;return/quit
  ret

; The transformations are coded as an array of two bit commands, where each command
; is followed by a continue flag bit. As the commands are shifted out of the byte, the third
; continue flag will be zero. That means that the command code byte can have three commands.
;
; The commands are:
;   00 : exchange x & y (x)
;   01 : exchange x & y, not x (x!)
;   10 : subtract one from x (-)
;   11 : subtract one from x and not x (-!)
;
; The first bit determines if the exchange or subtract operation should be performed.
; The second bit determines if the not operation should be performed or not.
;
; x:	x transformation
; y:	y transformation
; work:	the operations to be performed
; cmd:	the commands needed
; code:	the bit representation  of the commands
;
;	x	y	work	cmd	code
;FlipV		y=-y	x ! x	x! x	01 1 00 0
;180	x=-x	y=-y	x ! x !	x! x!	01 1 01 0
;Down		y--	x - x	x - x	00 1 10 1 00 0
;CW	x=y	y=-x	! x	x x! x	00 1 01 1 00 0
;Left	x--		-	-	10 0
;FlipH	x=-x		!	x x!	00 1 01 0
;Right	x++		! - !	x x! -!	00 1 01 1 11 0
;180	x=-x	y=-y	x ! x !	x! x!	01 1 01 0
;Up		y++	x ! - ! x	x! -! x	01 1 11 1 00 0
;CCW	x=-y	y=x	x !	x!	01 0
