;--------------------------------------------------------------------
; Hugi size compo #15 entry by gbm <gbm@ii.pw.edu.pl>
;--------------------------------------------------------------------
; compile:
;       tasm -m4 entry.asm
;	tlink -t entry.obj
;      or:
;	ml -Fl entry.asm
;
; usage:
;       entry <infile.bmp> <outfile.bmp>
;--------------------------------------------------------------------
;
; This loads a 128x128 greyscale BMP file, and using keys '0...9'
; transforms/translates the image. The [ ] space key will save the
; result to the <outfile> then quit to DOS.
;
; The keys make sense if you look at the keypad (NUMLOCK ON!)
;                                       Ŀ
;                                       rotate  move  rotate 
;                                        +180'   /\    +90' 
;                                                           
;                   Ŀ             Ĵ
;                   789               move         move  
;                   Ĵ             < x-flip  >
;                   456                                  
;                   Ĵ             Ĵ
;                   123             rotate       rotate 
;                   Ĵ              -180'   \/    -90' 
;                    0 .                     move   (270) 
;                                Ĵ
;                                            y-flip     unused
;  [SPACE BAR ]  === QUIT !!!                                 
;--------------------------------------------------------------------

BMP_FILESIZE    equ     17462

;EAX = xxxx****
;	AL = 00 if first FCB has valid drive letter,  FF if not
;	AH = 00 if second FCB has valid drive letter, FF if not
;EBX = xxxx0000
;ECX = xxxx00FF
;EDX = xxxxxxxx
;	DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;ESI = xxxx0100
;EDI = xxxxFFFE
;EBP = xxxx09xx
;ESP = xxxxFFFE
;EIP = xxxx0100

	.model	tiny
	.386
	.code

salc	macro
	db	0d6h
	endm

        org     100h
start:
        mov     dx, 82h

        ; read input file
	mov	al, 13h
	call	fileop
        push    di

        ; set palette
	salc
        out     dx, al
        inc     dx
setpal:
	mov	cx, 12
set1:
        out     dx, al
	loop	set1
	inc	ax
	jnz	setpal

	mov	al, lid - offset parmtable + 30h

;;-------------------------------------------------------------------
; Main loop
;;-------------------------------------------------------------------

MainLoop:
	mov	bx, offset parmtable - 30h
	xlatb

	cbw
	shl	ax, 2
	push	ax
	and	al, 3ch
	aam	;
	org	$-1
	db	16
	shl	ah, 2
	or	ax, 0c3c3h
	mov	byte ptr loc1+1 - parmtable + 30h[bx], al
	mov	byte ptr loc2+1 - parmtable + 30h[bx], ah

	pop	bx

	sar	bl, 6
	; bx - pixel coords

	mov	si, 3c8h + 1078
	; cx - x counter
	; si - src img buffer

yloop:
      	mov	cl, 128
	and	bh, 7fh
xloop:
	push	bx
	add	bl, bl
	shr	bx, 1
	mov	al, [bx+si]
	pop	bx
	push	ax
loc1:
	inc	bl
	loop	xloop
loc2:
	inc	bh
	or	sp, sp
	js	yloop

        ;; copy screen --> bmp
	push	0A2d6h
	pop	es
	mov     di, (320*127)	; [ES:DI] --> screen(x:96,y:36)
yclop:
        mov     cl, 128
xclop:
	pop	[si]
	movsb	; screen
	loop	xclop
        sub     di, 320+128 ; next screen line
        jnc     yclop

        ;; read <key> from STDIN ;;
        mov     ah, 08h
        int     21h

        ;; check for quit [SPACE] key ;;
;	add	al, 50h
	cmp	al, ' '
	jne	MainLoop

;--------------------------------------------------------------------
; Quit - Save BMP <output> file then exit to DOS ;;
;--------------------------------------------------------------------
	push	ds
	pop	es
        pop     dx

        ;; Create <output> file ;;
	mov	al, 3
	cbw

fileop:
        ; set video mode
        int     10h

	mov	al, ' '
	mov	di, dx
fs1:	scasb
        js      fs1
        mov     byte ptr [di-1], ch

	push	cx
	repe	scasb
	dec	di
	pop	ax
	add	ax, 3c40h ; -> 3d3fh on first call
	mov	bh, al
	salc

        int     21h
	xchg	ax, bx

        ; read/write
;	mov	dx, 0a2d6h-1078
	mov	dx, 3c8h
        mov     cx, BMP_FILESIZE
        int     21h

	ret

; ---------------------------------------------------------------

parmtable:
	;	ystart, xstart, yopc, xopc
	db	00110110b; y flip
	db	00000100b; rot 180
	db	00111110b; down
	db	11000011b; rot 90
	db	11001110b; left
	db	11001100b; xmirror
	db	11101110b; right
	db	00000100b; rot 180
	db	10111110b; up
	db	00111001b; rot 270
lid:
	db	11111110b; identity
;	inc	bl	; c3 00
;	dec	bl	; cb 10
;	inc	bh	; c7 01
;	dec	bh	; cf 11

;bmpbuffer	db 36h  dup (?)
;bmppalette	db 256*4 dup (?)
;bmpimage	db 128*128 dup (?)

	end	start


