[bits 16]
[org 256]

header   equ 436h
filesize equ 4436h

mask     equ 07f7fh
image    equ 01000h
cimage   equ 0a2d6h-filesize
loadarea equ image-header

start:
        pushf
        pop     bx
        or      bh, 01h
        push    bx
        popf

        mov     al, 13h
        mov     bp, 82h
        mov     bx, 3f3dh     ; 3d->open, 3f->read
        call    dostuff

        mov     si, image       
        mov     di, cimage
        rep     movsb      

        mov     es, di

        mov     dx, 3c8h
        salc
        out     dx, al
        inc     dx
setpal: mov     cl, 12
@@out:  out     dx, al
        loop    @@out
        inc     al
        jnz     short setpal

        mov     ch, 001h        ;cx=y adder [y01x00]
        xor     bx, bx          ;bx=origin  [00,00]
        cwd
        inc     dx              ;dx=x adder [y00x01]

mainloop:
        mov     di, 320*127
        mov     si, image
@@draw: and     bx, mask
        push    bx
        shl     bl, 1
        shr     bx, 1
        mov     al, [bx+cimage]
        pop     bx
        stosb
        mov     [si], al
        inc     si
        call    mleft        
        test    si, 07fh
        jnz     @@draw
        ;call    mdown
        add     bl, cl
        add     bh, ch
        sub     di, 320+128        
        jae     @@draw

        mov     ah, 08h
        int     21h

        sub     al, '0'
        js      quit
        mov     ah, 1

;        xchg    ax, bx     
;        xor     bl, [byte bx+foo]
;        xchg    ax, bx

        xor     al, [byte eax+(jumptbl-start)]
        js      @@nosw

        xchg    cx, dx
        or      al, 80h
        call    ax
        xchg    cx, dx
        db      0b8h    ; mov ax, immed16
@@nosw: call    ax
        jmp     short mainloop

jumptbl:
        db (yflip-start  & 7fh) ^ 0 ;*           0000e .
        db (rot180-start      ) ^ 1 ;?+180       0001o
        db (mdown-start  & 7fh) ^ 2 ;*           0010o .
        db (rot90-start  & 7fh) ^ 3 ;?+90        0011e .
        db (mleft-start       ) ^ 4 ;            0100o
        db (xflip-start       ) ^ 5 ;            0101e
        db (mright-start      ) ^ 6 ;            0110e
        db (rot180-start      ) ^ 7 ;?-180       0111o
        db (mup-start    & 7fh) ^ 8 ;*           1000o .
        db (rot270-start      ) ^ 9 ;?-90 (270)  1001e



quit:   mov     bx, 403ch       ; 3c->create, 30->write

        mov     ax, 3
dostuff:int     10h

        mov     dx, bp
@@find: inc     bp
        cmp     byte [bp-1], 20h
        ja      @@find
        mov     byte [bp-1], ah

        xor     cx, cx
        mov     ah, bl
        int     21h
        xchg    ax, bx

        mov     dx, loadarea
        mov     cx, filesize
        int     21h      
        retn

mright:
mup:
        sub     bl, dl
        sub     bh, dh
_retn:  retn

rot180:
        call    rot90
rot270:
rot90:
        xchg    cx, dx
xflip:
yflip:
        neg     dl
        neg     dh        
mleft:
mdown:
        add     bl, dl
        add     bh, dh
        retn



