	page	240, 132
;ENTRY.ASM	15-OCT-2001	Boreal
;Hugi 15 Compo
;
;Assemble with:
; tasm /m
; tlink /t
;
;Usage:
; ENTRY infile.bmp   outfile.bmp
;
;This program loads a 128x128 grayscale .bmp file. The keys '0'..'9'
; transform and translate the image. The spacebar saves the result
; to the outfile then returns to DOS.
;
;The keys make sense if you look at the keypad (Num Lock on!)
;					Ŀ
;					rotate  move	rotate 
;					 +180'   /\	  +90' 
;						   	  ccw	
;		    Ŀ		Ĵ
;		    789		 move  	 move	
;		    Ĵ		< x-flip  >
;		    456			  <->  	
;		    Ĵ		Ĵ
;		    123		rotate    	rotate 
;		    Ĵ		 -180'   \/	  -90' 
;		     0 .			 move	  cw	
;		    		Ĵ
;						     ^		
;					    y-flip  	unused 
;  [SPACEBAR] = QUIT				     v		
;					

debug	equ	0			;required for Turbo Debugger etc.

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h			;this is a COM file so skip the PSP
go:
	if	debug
	xor	ax, ax
	xor	bx, bx
	mov	cx, 00FFh
	mov	dx, cs
	mov	si, 0100h
	mov	di, -2
	mov	bp, 095Ah
	cld
	endif
;ax=0, bx=0, cx=00FFh, dx=cs, si=0100h, di=-2, bp=09xxh, sp=-2,
;df=0, [FFFEh]=0, [0]=CDh [1]=20h

;(ah=0)
	mov	al, 13h			;set mode 13 hex (320x200x256c)
	int	10h

;Set up color registers with gray shades identical to the bmp palette
	mov	al, 82h			;point to file name on command line
	xchg	ax, si			;al:=0; si:=0082h
	mov	dx, 3C8h
	out	dx, al			;must set reg 3C8 to 0 else colors wrong
	inc	dx
;(al=0, ch=0)
sp10:	mov	cl, 12
sp20:	out	dx, al
	loop	sp20			;cx--
	inc	ax
	jns	sp10

	mov	ah, 3Dh			;function code to open input file
	mov	bh, 3Fh			;function code to read input file
	call	fileIO
	push	si			;save pointer to output file name

corner	equ	36*320 + 96		;offset to upper-left corner of image
	push	0A000h + corner/16	; (corner is evenly divisible by 16)
	pop	es
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Draw bitmap on VGA screen (note: BMP image is upside down!)
dbm00:	mov	di, 163*320+96-corner	;point to bottom left corner of image
	mov	si, bp			;offset bmpImage
dbm10:	mov	cx, 64			;copy one line of bmpImage to screen
	rep movsw			;es:[di++]:= ds:[si++]; cx--
	sub	di, 320+128 		;next screen line
	jae	dbm10
;(cx=0)
	mov	ah, 08h			;read key from stdin
	int	21h

	sub	al, '0'
	js	DoQuit			;quit if spacebar

;(al = 0..9)
;Transform/translate screen image into bmpImage using xform table values
	mov	bx, offset xform
	xlat				;al:= xform table entry
	xor	di, di
					;for Y coord (hi 7 bits) := 0 to 127...
					;for X coord (lo 7 bits) := 0 to 127...
xf10:	mov	cl, 2			;set 2x loop counter (ch=0)
xf20:	mov	bx, di			;x (low 7 bits)
	test	al, 40h
	je	xf30
	shr	bx, 7			;y (high 7 bits)
xf30:
	cbw				;complement if bit 7 set
	xor	bl, ah

	push	ax			;do shift
	and	al, 03h			;get 2, 1, 0
	dec	ax			;    1, 0, -1
	add	bl, al
	pop	ax

	and	bx, 7Fh			;wrap within range 0..127
	ror	al, 4			;get y-axis xform bits

	xchg	bx, si			;swap x & y axes
	loop	xf20			;cx--

	imul	si, 320			;y*320 + x = source pixel index
	mov	bl, es:[bx+si]		;fetch source pixel
	mov	[di+bp], bl		;store in bmpImage
	inc	di
	jns	xf10			;loop for all pixels, and then some
	jmp	dbm00			;go display result
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Quit - Copy bmpBuf to output file then exit to DOS
DoQuit:	mov	ax, 0003h		;restore text mode
	int	10h

	mov	ah, 3Ch			;function code to create output file
	mov	bh, 40h			;function code to write output file
;(cx=0)					;sets 'archive' attribute on output file
	pop	si			;get output file name from command line
					;fall into fileIO...
;-------------------------------------------------------------------------------
;Read and write bmp file
;
fileIO:
;Skip leading spaces in file name on command line
fio05:	mov	dx, si
	lodsb				;al:= ds:[si++]
	sub	al, 20h
	jbe	fio05

;skip to space or cr
fio10:	lodsb				;al:= ds:[si++]
	sub	al, 20h			;al:= 0 when ah=3Dh (open input file)
	ja	fio10

	mov	[si-1], dh		;terminate file name (dh=0)
	int	21h

	xchg	bx, ax			;bx:= handle; ah:= function code
	mov	cx, bmpEnd-bmpBuf
	lea	dx, [bp-bmpImage+bmpBuf] ;bp-436h
	int	21h
	ret

;Table to transform image
;		~xVt~yHz		 KEY COMMAND
xform	db	00010101b		;'0' y-flip
	db	10010101b		;'1' rotate +180
	db	00001101b		;'2' move down
	db	11011001b		;'3' rotate -90 (clockwise)
	db	00011110b		;'4' move left
	db	10011101b		;'5' x-flip
	db	00011100b		;'6' move right
	db	10010101b		;'7' rotate -180
	db	00101101b		;'8' move up
	db	01010001b		;'9' rotate +90 (counter clockwise)

bmpImage	equ	095Ah		;(aprox loc) image (upside down!)
bmpPal		equ	bmpImage-256*4	;palette
bmpBuf		equ	bmpPal-54	;header
bmpEnd		equ	bmpImage+128*128

cseg	ends
	end	go
