#! /bin/sh
# This sed script takes a transformation as input
# and generates all the equivalent ones.
# Use like this:
#
#    echo VX | sed -f equiv.sed | sed -f equiv.sed | sort | uniq
#
# for clockwise 90 degrees rotation

# sed script that ensures that the syntax is correct,
# and pads the line to eight characters

pad='
/^[V-]\?[D-]\?[U-]\?[X-]\?[V-]\?[D-]\?[U-]\?[X-]\?$/!d

s/^\([^V-]\)/-\1/
s/^\(.\)\([^D-]\)/\1-\2/
s/^\(..\)\([^U-]\)/\1-\2/
s/^\(...\)\([^X-]\)/\1-\2/
s/^\(....\)\([^V-]\)/\1-\2/
s/^\(.....\)\([^D-]\)/\1-\2/
s/^\(......\)\([^U-]\)/\1-\2/

s/$/--------/
s/\(........\).*/\1/
'

# sed script that modifies the transform but leaves
# the result unchanged
equiv='
h
# Group transformations that are far
g; s/----\(....\)/\1----/p
g; s/\(.\)----\(...\)/\1\2----/p
g; s/\(..\)----\(..\)/\1\2----/p
g; s/\(...\)----\(.\)/\1\2----/p

# Separate transformations that are near
g; s/\(.\)\(...\)----/\1----\2/p
g; s/\(..\)\(..\)----/\1----\2/p
g; s/\(...\)\(.\)----/\1----\2/p
g; s/\(....\)----/----\1/p

# Add bogus DOWN+UP transformations
g; s/^\(.\)--/\1DU/p
g; s/--\(.\)$/DU\1/p
g; s/^\(.\)-\(.\)--\(.\)-/\1D\2--\3U/p
g; s/^\(.\)\(.\)----\(.\)/\1\2U--D\3/p

# Add bogus VERTICAL+VERTICAL or EXCHANGE+EXCHANGE transformations
g; s/^\(...\)-----/\1X---X/p
g; s/^-----\(...\)/V---V\1/p

# Change DOWN+VERTICAL to VERTICAL+UP and similar
g; s/D\(.\)-V\(.\)-/-\1-V\2U/p
g; s/\(.\)U-V-\(.\)/\1--VD\2/p
g; s/\(.\)--VD\(.\)/\1U-V-\2/p
g; s/-\(.\)-V\(.\)U/D\1-V\2-/p
g
'

echo $1 | \
  sed -e "$pad" -e "$equiv" | \
  sed -e "$equiv" | \
  sed -e "$equiv" | \
  sed -e "$equiv" | sort | uniq
