; hugicompo#15 entry by obertraumfu:hrer alvaro acwellan
; reachme: alvaro84@mailbox.hu
;
; (140 bytes)
;
; some interesting facts:
; buffer addresses are extensively reused (segment as well as offset)
; file open/r|w code also reused
; its palette handling snows on my tnt2 (16k palregisters per frame=)
; a previous version used self-modifying code for the main loop (i liked that)
; it was raining all day :(
; it's a bit hard to code on the school keyboards when you have inch-long nails
; code IS art!
; 'rightup', in fact, points to the bottom of the picture =)
; vorpekkat maasi - punt kerho pktat kutyainnen vaaui!
; nem kevesen lehettek bent, de be kell jelentenem: ezeknek befellegzett.
; [egymegegyszer ezer meg egy szeptember eleven] (ehm, nem perverz egy cseppet?
; nem kell egy eszperente vers? nem? nekem sem...)
; na: agyatlan balga arkangyal tatvakat aszal sajtnak. nagy kajla barna hallal
; balra hajtja a tatvakat, majd hamar arrabaktat. hatvan gramm vajat rak a
; tatvakra, azalatt balra csavarja a nagy barna kart, haljanak a tatvak. a
; tatvak bajban vannak, s a bajban jajgatnak. hallja a nagy tatv, jajgatnak
; a tatvak. arrabaktat, s hajbakap az arkangyallal. hasbacsapja, talapzatra
; ragasztja.
; the above ~: a brainless stupid archangel dehydrates tatvs to make cheese
; of them. (s)he drives them to the left with a big brown fish, then (s)he also
; goes leftwards. (s)he puts sixty grams of butter onto the tatvs, while (s)he
; turns the big brown handle to the left, let them die. the tatvs are in
; trouble and they are screaming. the big tatv hears this and quickly goes
; there and beats up the archangel. and so on...
; glossary: tatv: kind of undead monster, (c) wyc ~1996
;
; greetinx part:
; - the biggest one flies to shr, who first talked me about hugicompo, and MUCH
;   more :) s kszi a fejtrt a sorballtott rabokrl, pont jl jtt :)
; - another one to chut. why not? :) i could have seen him if i would be @ home
;   when he tried to deliver those SIMMs
; - yet another jmps to all members of molecoola, my team (yes, same as shr's
;   one )
; and so on. ( adok may be bored =)

; assumed:
; DF = clear (increment) [copy direction]
; BX = 0x00xx (BX is normally 0) [for 1st FCB address]
; SI<= 0x01FF (0x0100 according to the rules) [for 1st transformation cmd]

org 100h

rightup equ (36+128)*320+96+128-80	; draw start addr
bmp1 equ 36*320+96+128-80		; nail buffer1 start to draw end
bmp equ bmp1-1078			; load bmp HERE

; opens the input file using 'filerutin' (combined file reading/writing
; and vmode switching procedure) - parameters:
; AL = Video mode
; AH = 1st int21 function (fopen/create)
; BX = filename address (1st/2nd FCB) [BH=0 assumed]
; CH = 2nd int21 function (fread/fwrite)
; CL (optional) = attribute for create

start:
	mov ch,0x3F		; set registers as above
	mov bl,0x5d+8
	mov ax,0x3d13		; filemode is a bit strange, but it worx
				; even for system/readonly files
				; (at least in a DOS window, not in pure
				; cmdline nor real DOS - it's a dirty opt!)
	call filerutin		; open/read

; registers used in the main loop:
; AL = temp (pixel); AH = 8 (int21 command, cwd helper)
; BX = picture address, loop counter
; CL = rotation value; CX = amount of bytes 2 copy / ES source
; DX = temp (extracted command) | 3C8/3C9 for palette
; SI(h) = command (a harmless 01 @ start) / buffer2 address (copy source)
; DI = screen address, buffer1 address @ loop end
; ES = screen

tf1_pre:
	mov cx,0xa005		; set registers as above
	mov es,cx
	mov di,rightup
	mov bx,-16384
	mov ah,8
tf1:
	push bx			; bx will be totally punished...
	shl bx,1		; decompose address > coords
	shl bh,1

	test bl,bl		; check if a new line is needed
	jnz nxwrap		; no X wraparound
	sub di,320+128		; adjust screen address

nxwrap:	mov dx,si		; extract displacement/flip parameters -> dh|dl
	sar dx,cl
	sar dl,cl

; no need of examination - the last sar have set C and P flags according to
; 'xchg?' and 'Xval+P' fields.

	jnc @add		; shifted out 0: add
	jpe @noxch		; remainder's parity even -> xor(flip)
	xchg bl,bh		; else: swap and flip
@noxch:	xor bx,dx
	cwd			; don't add after flip (cheapest mov dx,0)
@add:	add bx,dx

	shr bh,1		; convert back 2 addr
	shr bx,1

	mov al,[bmp1+bx]	; get source pixel
	pop bx			; original buffer address
	mov [bx+0xDBFE],al	; put in2 2nd buffer
	stosb			; and to the screen

@pal:	mov dx,3c8h		; i set a palette register for every
	out dx,al		; pixel, but who cares?
	inc dx			;
	shr al,2		; al is the color of the actual pixel
	out dx,al		; -> guaranted that every _visible_
	out dx,al		; pixel will be displayed correctly
	out dx,al		; (how to display invisible pixels?=)

	inc bx
	jnz tf1

; copy back buffer2 to buffer1

	mov si,	0x9BFE		; SI + CX = needed AX
	push ds			; back 2 normal DS/ES 
	pop es			;
	rep movsb		; copies much more than needed (~40k),
				; but it's o.k. for it won't overwrite
				; PSP nor bmp header
				; have to move per byte for ~40k words would
				; be too much plus this leaves the chance to
				; start buffer2 @ odd addresses

; get a key from stdin

	int 21h
	cmp al,32
	xchg ax,si
	mov si,[si+trans4m-0x831]	; get transformation command into SI(h)
	jne tf1_pre			; !=space - go and draw!

; pass file/vmode parz - BX = filename#2 (2nd FCB)
;			 CX = 0x4000 - fwrite | archive (it worx for 0, again)
;			 AX = 0x3c03 - create | textmode
;
; AX directly passed from SI after the memblock move

	mov bl,0x6D+8		; file#2
	mov ch,0x40

filerutin:
	pusha			; save AH for int21 (and everything for safe)
	cbw			; mov ah,0 (AL<80h)
	int 10h			; set vmode
	popa			; restore AH (++)
;	salc			; needed (only) to run under _real_ DOS

	shl dword [bx],8	; insert a '.' between filename and extension
	mov byte [bx],'.'	; in an FCB @ [bx-8]
	lea dx,[bx-8]

	int 21h			; fopen/create
	xchg ax,bx		; pass handle to bx
	xchg ax,cx		; set AH from CH
	mov dx,bmp		; address
	mov cx,17462		; and length
	int 21h			; fread/fwrite

; no int20h, nor ret. or, to be honest, ret is the 1st byte of data :)

trans4m:
; format: Yval(2) | 0 | Xval(2) | P | xchg? | x |
;
; Yval and Xval is shifted to be -2/+2. it somehow prevents overflows or so,
; and simplifies address extract/pack seqence by 1 instruction. 
; The value is added or XORed to the source coordinates - the 'xchg?'
; bit tells if you have to swap the coordinates before this. The code itself
; is branched to an ADD and an XOR path according to Xval+P bits' parity,
; where P simply adjusts the natural parity o Xval.

db 6*32 + 0*4 + 2 + 1	; '0' : flip Y 	(=ret)
db 6*32 + 7*4 + 2 + 0	; '1' : rot 180'
db 2*32 + 0*4 + 0 + 0	; '2' : scroll down
db 0*32 + 6*4 + 2 + 0	; '3' : rot -90'
db 0*32 + 2*4 + 0 + 0	; '4' : scroll left
db 0*32 + 7*4 + 2 + 0	; '5' : flip X
db 0*32 + 6*4 + 0 + 0	; '6' : scroll right
db 6*32 + 7*4 + 2 + 0	; '7' : rot 180'
db 6*32 + 0*4 + 0 + 0	; '8' : scroll up
db 6*32 + 1*4 + 2 + 0	; '9' : rot +90' ; ret

section .bss

; "and when the day arrives
; i'll become the sky
; and i'll become the sea
;
; and the sea will come to kiss me
; for i am going
; home
;
; nothing can stop me now"
