; Entry.asm
; Entry for HUGI SIZE CODING COMPETITION 14
;
; By: Kees Willem van der Meer
;     The Netherlands
;
; assemble with:
;   nasmw entry.asm -f bin -o entry.com
;
; Resulting com-file 303 bytes

; %define DEBUG

CommandTail		equ	80h
FileName		equ	CommandTail+2

Cr			equ	0dh
Lf			equ	0ah
CodeBase		equ	100h

; Hash value definitions
hA		equ	00Ah
hADCA		equ	0D1h
hADDW		equ	0F7h
hANDA		equ	0FFh
hDB		equ	0DBh
hGOSUB		equ	0C2h
hJP		equ	04Ch
hJPA		equ	0D6h
hJPBE		equ	099h
hJPC		equ	0D8h
hJPG		equ	0DCh
hJPGE		equ	0ECh
hJPL		equ	0E1h
hJPLE		equ	03Ch
hJPNC		equ	05Ah
hJPNO		equ	066h
hJPNP		equ	067h
hJPNS		equ	06Ah
hJPNZ		equ	071h
hJPOV		equ	07Dh
hJPP		equ	0E5h
hJPS		equ	0E8h
hJPZ		equ	0EFh
hLDA		equ	019h
hORA		equ	005h
hOSCALL		equ	0C6h
hPC		equ	09Fh
hPOPB		equ	096h
hPUSHB		equ	012h
hRDI		equ	033h
hRDSYS		equ	006h
hRETURN		equ	094h
hSBBA		equ	01Bh
hSTA		equ	031h
hSTATUS		equ	036h
hSTK		equ	03Bh
hWRI		equ	025h
hXORA		equ	035h

DestBufferSize	equ	4096
MaxSourceSize	equ	32*1024+1	; 32K + terminating 0
MaxLabel	equ 	50
LabelSize	equ	32

SourceBuffer	equ	38a5h	
LabelTable	equ 	(SourceBuffer+MaxSourceSize) | 1fh

          	; AL = 00 if first FCB has valid drive letter,  FF if not
		; AH = 00 if second FCB has valid drive letter, FF if not
		; assume valid drive letters
          	; BX = 0000, CX = 00FF, DX = xxxx, DX  = CS = DS = ES = SS = PSP, 
          	; 0080 <= DX <=9000
          	; SI = 0100, DI = FFFE, BP = 09xx, SP = FFFE, IP = xxxx0100

          	org	100h
%ifdef DEBUG
		xor	ax, ax
		xor	bx, bx
		mov	cx, 00ffh
		mov	si, 100h
%endif		
		shr	si, 1			; si:=80h command tail		
		lodsb
		xchg	ax, bx			; ax := 0; bx: length of command tail excluding Cr (bx>=3)
		mov	[si+bx], al		; Terminate filename with 0

		std
		mov	cx, 0fffeh-EndOfSignature
		rep	stosb			; clear memory (al=0)
		cld		
		inc	byte [DestBuffer+0f05h]

		mov	dx, FileName
		mov	ah, 3dh			; 8.3 filename->no drive letter->al=0
		int	21h			; Open Source File; ignore errors

		; May assume anything about extension so assume extension .sam 
		; change 'am' to 'pu'
		mov	word [si+bx-2], 'pu'
		xchg	ax, bx			; bx := Handle; (ax:=length of command tail)

		; Create SPU-file
		; assume dx=FileName
		mov	ah, 3ch			; Create file (cx=0: no attributes)
		int	21h			; Create Spew File; ignore errors
		push	ax			; push Handle
		
		; Read source file to Source buffer
		; assume bx = source handle
		mov	ah, 3fh
		mov	dx, SourceBuffer	; 38a5
		dec	cx			; read ffff bytes max
		int	21h			; Handle in bx

		; ------------
		; Parse source
		; ------------
ParseSource
		; assume carry clear
		mov	di, DestBuffer+CodeBase	; set di to start of code-1
		mov	si, SourceBuffer-1	; set si to start of source-2

CopyString	equ	$-2		; Dummy code:
		db	04h, 75h	; add	al, 75h
		db	0fbh		; sti
		; When jumping to CopyString:
		; CopyString
		; 		movsb 
		; 		cmp	[si], al
		; 		jne	CopyString
SkipLine		
		lodsb				; First char read is 0 (source-1)
		cmp	al, Cr			; so continue
		ja 	SkipLine
NewLine		
		xor	bx, bx			; bx = operation being parsed
ParseNextChar		
		; Read prefix char
		; assume first char not part of instruction
		lodsb
		cmp	al, Cr
		je	NewLine		
		cmp	al, "'"
		je	CopyString

		cbw				; ah := 0 (assume al<128)
		cwd				; dx := 0
		xor	cx, cx

		mov	bp, si			; bp := source position
		push	ax			; push prefix char
		; -----------------------------------------------------------
		; Read a string of alphanumeric chars and change to lowercase
		; Put length of string in dx and convert to immediate value in cx
		; -----------------------------------------------------------
ReadAlphaNum		
		lodsb
		cmp	al, '@' 
		jbe	.NoAlpha
		or	al, 20h			; to lowercase
		mov	byte[si-1], al		; store in source
		sub	al, 'a'-0ah
.UpdateValue
		shl	cx, 4
		add	cl, al			; cx holds possible immediate value
		inc	dx
		jmp	short ReadAlphaNum
.NoAlpha
		sub	al, '0'
		cmp	al, 9
		jbe	.UpdateValue		; Not alphanum if < '0'
.LoopEnd
		dec	si			; Unget last char

		; cx = immediate value
		; dx = length of string

		pop	ax			; Pop prefix char

		; Prefix char can be 0, ' ', #, %, ;, @

		cmp	al, ";"
		ja	ReadLabel
		je	SkipLine
		cmp	al, '#'
		xchg	ax, cx			; ax := immediate value; cl := prefix char
		je	StoreInstr		; Store immediate value in ax
		jcxz	StoreSPU		; Prefix char = 0

		pushf
		; -----------------------------------
		; Calculate hash from immediate value
		; Put index of hash in bp
		; -----------------------------------
		aad	3			; al=hash
		xor	bp, bp
.FindHash		
		inc	bp
		cmp	byte [bp+HashTable], al	; compare with hash value in dl
		jne	.FindHash
.NotFound	
		popf

		lea	ax, [bp + 0f00h-1]
		ja	StoreInstr		; Store register
		
		; Prefix char = ' ' here
		
		dec	dx
		js	ParseNextChar		; No string after prefix char
		; ----------------
		; Read instruction
		;-----------------			
ReadInstruction
		xchg	ax, bp			; ax := Hash index of instruction
		cmp	al, ReturnIndex		; is instruction RETURN ?
		xchg	ax, bx			; bx := Hash index; ax := 0
		jne	ParseNextChar		; Return is stored immediately
		; assume ax=0
StoreInstr
		; Calculate opcode from index in hashtable (bx)
		; put opcode in dl
		sub	bl, DbIndex
		je	.StoreDb		; DB
		; ax = 12 bits address, is 16 bit number > 0, so
		cwd				; dl (dx) := 0
		jc	.DoStore		; OSCALL and JP
		shld	dx, bx, 20		; dl := bl << 4
		sub	bl, ReturnOffset
		jc	.DoStore		; GOSUB (10) .. XORA (F0)
		mov	dl, 10h			
		je	.DoStore		; RETURN		
		lea	dx, [byte bx+0a0h-1]	; JPOV (A0).. JPG (AF)
		; Make address relative:
		sub	ax, di
		add	al, (DestBuffer-2) & 0ffh	; +28h
		xor	ah, ah
.DoStore
		stosb				; save lo byte of address
		xchg	ax, dx
		or	al, dh			; save high nibble of address and opcode
.StoreDb
		stosb
ParseNextChar2
		jmp	short ParseNextChar
		; ----------
		; Read label 
		; ----------
		; assume ah = 0
		; assume dx = label length (dh=0)
ReadLabel
		push	di			; Save di
		mov	di, LabelTable
.LabelLoop
		mov	cx, dx			; cx := label length
		mov	si, bp			; si := start of label in source
		mov	al, 1fh
		or	di, ax			; next label; labels in table aligned at xx1fh
		
		cmp	byte [di], ah		; is empty label?
		jne	.TestLabel
	; Label not found
		or	bx, bx
		jne	.NoDefinition		; if operation being parsed then label reference
	; Store label			
		rep	movsb
		stosb				; Terminate with 01fh
		pop	ax			
		stosw				; store address with label
		xchg	di, ax			; restore di
		; Restart parsing if label definition is stored to resolve possible
		; forward references to this label
		jmp	ParseSource
.TestLabel
		repe	cmpsb
		jne	.LabelLoop		; Not equal: next label
		scasb				; check if terminated by 01fh 
		jne	.LabelLoop		; Not complete: next label
		mov	ax, word[di]		; ax := address	of label
		sub	ax, DestBuffer		; ax := offset in DestBuffer
.NoDefinition
		rep 	lodsb			; skip to end of label in source
		pop	di			; Restore di
		or	bx, bx			; Instruction is being parsed?
		je	ParseNextChar2		; bx=0: Label definition	
		jmp 	short StoreInstr
		; -----------------------
		; Store SPU-file and exit
		; -----------------------
		; assume cl=0
StoreSPU
		mov	ah, 40h
		pop	bx			; Pop handle
		mov	dx, DestBuffer
		mov	ch, DestBufferSize >> 8
		int	21h
		retn				; exit with int 20h (closes all files)
	
HashTable	equ	$-1
		db	hA		; F00
		db	hSTATUS		; F01
		db	hSTK		; F02
		db	hOSCALL		; 00xx    OSCALL xx               Use an OS call (int 21h service)
		db	hPC		; F04..F05
		db	hJP		; 0xxx    JP xxx                  Jump to new PC address
DbIndex		equ	$-HashTable
		db	hDB 
		db	hGOSUB		; 1xxx    GOSUB xxx               Go (call) a sub-routine
		db	hPUSHB		; 2xxx    PUSHB [xxx]             Push a byte onto the stack
		db	hPOPB		; 3xxx    POPB [xxx]              Pop a byte from the stack
		db	hLDA		; 4xxx    LDA [xxx]               Load A (accumulator) from memory
		db	hSTA		; 5xxx    STA [xxx]               Store A into memory
		db	hRDI		; 6xxx    RDI [(xxx)]             Read an indirect byte using mem-ptr
		db	hWRI		; 7xxx    WRI [(xxx)]             Write an indirect byte using mem-ptr
		db	hRDSYS		; 8xxx    RDSYS [0000:0xxx]       Read byte from system ram[0000:0xxx]
		db	hADDW		; 9xxx    ADDW [xxx],A            Add sign-extended A to word variable
		db	hADDW		; Dummy
		db	hADCA		; Bxxx    ADCA [xxx]              A + mem[xxx] + CF
		db	hSBBA		; Cxxx    SBBA [xxx]              A - mem[xxx] - CF
		db	hORA		; Dxxx    ORA  [xxx]              A OR mem[xxx]
		db	hANDA		; Exxx    ANDA [xxx]              A AND mem[xxx]
		db	hXORA		; Fxxx    XORA [xxx]              A XOR mem[xxx]

ReturnIndex	equ	$-HashTable
ReturnOffset	equ	ReturnIndex - DbIndex
		db	hRETURN		; 1000    RETURN                  Return from a GOSUB call

		db	hJPOV		; A0xx    JPOV +pp        	  jump if overflow
		db	hJPNO		; A1xx    JPNO +pp        	  jump if no-overflow
		db	hJPC		; A2xx    JPC  +pp        	  jump if carry
		db	hJPNC		; A3xx    JPNC +pp        	  jump if no-carry
		db	hJPZ		; A4xx    JPZ  +pp        	  jump if zero
		db	hJPNZ		; A5xx    JPNZ +pp        	  jump it non-zero
		db	hJPBE		; A6xx    JPBE +pp        	  jump if below or equal
		db	hJPA		; A7xx    JPA  +pp        	  jump if above
		db	hJPS		; A8xx    JPS  +pp        	  jump if sign=1
		db	hJPNS		; A9xx    JPNS +pp        	  jump if no-sign
		db	hJPP		; AAxx    JPP  +pp        	  jump if parity
		db	hJPNP		; ABxx    JPNP +pp        	  jump if no-parity
		db	hJPL		; ACxx    JPL  +pp        	  jump if less than
		db	hJPGE		; ADxx    JPGE +pp        	  jump if greater or equal
		db	hJPLE		; AExx    JPLE +pp        	  jump if less or equal
		db	hJPG		; AFxx    JPG  +pp        	  jump if greater than
		
DestBuffer	equ	($-$$)+100h
		db	Cr, Lf, 'Hugi Compo #14...', 1ah
EndOfSignature	equ	($-$$)+100h-1
