start_value     equ     '3'
end_value       equ     255

; ~~~~~~~~~~~~~~~~~~~~~~~~ place test code here ~~~~~~~~~~~~~~~~~~~~~~~~~~
test_code macro

        sub     al,'0'
        aam     11h
        daa
        aad     0ah

        endm
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

; ========================================================================
;
;          simple test-code program by TAD ( tad_uk@bigfoot.com)
;
; Insert your own test code in the above macro, compile and run.
;
; It enters with (EAX)=n (where n = START_VALUE ... END_VALUE) and displays
; the result in (EAX) and (FLAGS) together with Jcc instructions
; (e.g. if C=0 then NC is displayed).
;
; This was written so I could test out some nice 80x86 BCD instructions.
; e.g.
;       AAM 41h                 ; packs ASCII '0123456789ABCDEF' char(AL)
;       AAS                     ; into hex nibble 0..F hex
;       AAD 0Ah                 ; (NOTE: this allows bad chars --> hex  :(
; = 5 bytes
;
; or,
;       SUB     AL, '0'         ; also packs '0'...'F' into 0..F hex
;       AAM     11h             ;
;       DAA                     ; BUT, this rejects ALL non-hex chars
;       AAD     0Ah             ; by (AL) >= 10 hex :)
; = 7 bytes
;
; or,
;       SUB     AL, '0'
;       AAM     30h             ; # 'abcdef' --> 'ABCDEF'
;       AAD     10h             ; # lower-2-uppercase
;       AAM     11h
;       DAA
;       AAD     0Ah
; = 11 bytes
;
; have fun,
;       TAD
;
; ------------------------------------------------------------------------
;
; compile:
;       TASM testcode
;       TLINK /t testcode
;
; run:
;       TESTCODE >result.txt
;
; ========================================================================


        .MODEL TINY
        .DATA?
_input          dw      ?
_flags          dw      ?
_eax            dd      ?
printbuffer     db      100 dup (?)

        .DATA
;                        0 1 2 3 4 5 6 7 8 9 A B C D E F
Jcc_strings     db      'OVNOC NCZ NZBEA S NSPENPL GELEG '

        .CODE
        ORG 256
        .386
go:
        mov     eax, START_VALUE
testloop:
        mov     [_input], ax
        push    eax

        ;; run the test code ;;

        TEST_CODE

        ;; store the results ;;

        pushf
        pop     [_flags]
        mov     [_eax], eax

        ;; now print result of TEST_CODE ;;

        lea     di, printbuffer
        push    di
        call    Output
        pop     dx
        mov     cx, di
        sub     cx, dx
        mov     bx, 0001h               ; STDOUT
        mov     ah, 40h
        int     21h

        ;; repeat testing loop ;;
        pop     eax
        inc     eax
        cmp     eax, END_VALUE
        jbe     testloop
        ret

;; print the results of TEST CODE into[ES:DI] ;;
Output:
        mov     ax, [_input]
        call    Outhex2
        call    OutSpace

        mov     ax, [_input]
        call    OutASCII
        call    OutSpace
        mov     ax,' ='
        stosw
        mov     ax, word ptr [_eax+2]
        call    OutHex4
        mov     al, '-'
        stosb
        mov     al, byte ptr [_eax+1]
        call    OutHex2
        mov     al, '-'
        stosb
        mov     al, byte ptr [_eax]
        call    OutHex2
        call    OutSpace
        mov     al, byte ptr [_eax]
        call    OutASCII
        mov     ax, 2020h
        stosw
        mov     ax, ':f'
        stosw
        mov     ax, [_flags]
        call    OutHex4

        ;; print the Jcc taken jumps using _flags ;;

        mov     ax, 2020h
        stosw

        lea     si, Jcc_strings
        mov     cl, 070h
Jccloop:
        mov     byte ptr [smc], cl      ; self-mod Jcc below
        jmp     short $+2
        jmp     short $+2
        jmp     short $+2

        push    [_flags]
        popf                            ; do Jcc jump using flags
        lodsw
smc:    jnc     short TakeJump          ; <--- self-mod'd
        mov     ax, '--'
TakeJump:
        stosw
        mov     al, 20h
        stosb
        inc     cl
        jns     short Jccloop           ; 70..7F hex (JO, JNO...JG)

        mov     ax, 0A0Dh
        stosw
        ret

;; output(AL) - filter ASCII control-codes ;;
OutASCII:
        cmp     al, 20h
        ja      short OutAL
OutSpace:
        mov     al, 20h
OutAL:
        stosb
        ret

;; output(AX) as 4-digit hex ;;
OutHex4:
        push    ax
        mov     al, ah
        call    OutHex2
        pop     ax

;; Output(AL) as 2-digit hex ;;
OutHex2:
        aam     16
        call    SwapHex1
SwapHex1:
        xchg    ah, al
        cmp     al, 0Ah
        sbb     al, 69h
        das
        stosb
        ret

        end     go
