; silly, pointless and fun SPEW dis-a by TAD 2001 ( tad_uk@bigfoot.com )
;
; compile:
;       TASM dis
;       TLINK /t dis            <--- compile as .COM tiny proggy
;
; run:
;       DIS <spew filename> <start addr>
;
; e.g.
;       DIS demo.spu 1ea
;
; Greetz
;       Ruud, claw, Boreal, Sniper, Jibz, Chut, FirEdge, INT-E
;
;       and everyone else I forgot....
;

        .model tiny

; instruction strings are encoded by a left shift + 1 marker bit
; 
; char = 76543210  is stored as:-
;        6543210m       (m = end of string marker)
;

        .data
txt_RETURN      db      0A4h,08Ah,0A8h,0AAh,0A4h,09Dh

txt_OSCALL      db      09Eh,0A6h,086h,082h,098h,099h
txt_JP          db      094h,0A1h                       ; 0xxx
txt_GOSUB       db      08Eh,09Eh,0A6h,0AAh,085h        ; 1xxx
txt_PUSHB       db      0A0h,0AAh,0A6h,090h,085h        ; 2xxx
txt_POPB        db      0A0h,09Eh,0A0h,085h             ; 3xxx
txt_LDA         db      098h,088h,083h                  ; 4xxx
txt_STA         db      0A6h,0A8h,083h                  ; 5xxx
txt_RDI         db      0A4h,088h,093h                  ; 6xxx
txt_WRI         db      0AEh,0A4h,093h                  ; 7xxx
txt_RDSYS       db      0A4h,088h,0A6h,0B2h,0A7h        ; 8xxx
txt_ADDW        db      082h,088h,088h,0AFh             ; 9xxx
txt_JPcc        db      094h,0A1h                       ; Acpp  --> cc
txt_ADCA        db      082h,088h,086h,083h             ; Bxxx
txt_SBBA        db      0A6h,084h,084h,083h             ; Cxxx
txt_ORA         db      09Eh,0A4h,083h                  ; Dxxx
txt_ANDA        db      082h,09Ch,088h,083h             ; Exxx
txt_XORA        db      0B0h,09Eh,0A4h,083h             ; Fxxx

cc_strings      db      'OVNOC NCZ NZBEA S NSP NPL GELEG '
        
        .data?
spewimage       db      4096 dup (?)
linebuffer      db      100 dup (?)

TAB     equ     09h
SPACE   equ     20h

        
        .code
        .286
        org 256
go:
        ;; mark end of filename with 00 ;;

        mov     dx, 0082h
        mov     si, dx
nospace:
        lodsb
        cmp     al, 20h
        ja      short nospace
        mov     [si-1], ah
        mov     al, 0

        ;; try to find hex number after filename ;;
scanhex:
        shl     bx, 4                   ;; bx = number
        or      bl, al
        lodsb
        sub     al,'0'                  ;;  this nice piece of code
        aam     30h                     ;;  will convert the characters
        aad     10h                     ;;     '0123456789ABCDEF'
        aam     17                      ;;  or '0123456789abcdef'
        daa                             ;;  into a valid hex nibble 0..F
        aad     10                      ;; don't ya love those opcodes #;o)
        cmp     al, 0Fh
        jbe     short scanhex

        ;; load the .SPU file ;;

        mov     ax, 3D00h
        int     21h
        xchg    ax, bx
        jc      quit
        push    ax
        lea     dx, spewimage
        mov     cx, 4096
        mov     ah, 3Fh
        int     21h
        mov     ah, 3Eh
        int     21h

        ;; disassemble 20 instructions ;

        pop     bx                      ;; start addr
        mov     cx, 20
again:
        push    cx
        lea     di, linebuffer
        call    DisSpew
        mov     ax, 0A0Dh
        stosw
        mov     al, '$'
        stosb
        lea     dx, linebuffer
        mov     ah, 9
        int     21h
        pop     cx
        loop    again
quit:
        ret
        
DisSpew:
        mov     ax, bx
        call    OutHex4
        mov     al, TAB
        stosb

        mov     dx, word ptr spewimage[bx]
        inc     bx
        inc     bx
        
        mov     ax, dx
        call    OutHex4
        mov     al, TAB
        stosb

        mov     cx, dx
        shr     cx, 12
        cmp     dx, 1000h
        pushf
        push    cx
        lea     si, txt_RETURN
        jz      short wrtmnem           ; 1000 ?
        lea     si, txt_OSCALL
        or      dh, dh
        jz      short wrtmnem           ; 00xx ?

        ;; seach strings for Nth one ;;

        inc     cx
findmnem:
        lodsb
        shr     al, 1
        jnc     short findmnem
        loop    findmnem

        ;; unpack string chars ;;

wrtmnem:
        lodsb
        shr     al, 1
        stosb
        jnc     short wrtmnem
        pop     ax

        ;; check for JPcc (Acpp hex) instruction ;;

        cmp     al, 0Ah
        mov     ax, dx
        jnz     short not_JPcc          ; not 'JPcc' ?
        mov     si, dx
        shr     si, 8
        add     si, si
        add     si, offset cc_strings - (00A0h SHL 1)
        movsw
        cbw
        add     ax, bx
        xchg    ax, dx                  ; +pp
not_JPcc:
        popf
        jz      short _ret              ; 1000 ? (RETURN, has no operand)

        ;; display 3-digit operand ;;

        mov     al, TAB
        stosb
        push    dx
        mov     al, 0Fh
        and     al, dh
        call    OutHex1
        pop     ax
        jmp     OutHex2


; output(AX) as 4-digit hex ;
OutHex4:
        push    ax
        mov     al, ah
        call    OutHex2
        pop     ax

; output(AL) as 2-digit hex ;
OutHex2:
        aam     16
        call    SwapHex1
SwapHex1:
        xchg    ah, al

; output(AL) as 1-digit hex ;
OutHex1:
        cmp     al, 0Ah
        sbb     al, 69h
        das
        stosb
_ret:
        ret
        end go

