;  Ŀ
;            entry for HUGI size coding competition #14         
;  Ĵ
;      
;           T H E     S P E W     A S S E M B L E R           
;      
;  Ĵ
;             Size    303 bytes                                
;            Title    The Spew Assembler                       
;           Author    Espineter                                
;             Name    Antonio Jos Villena Godoy               
;            Email    espineter@yahoo.com                      
;          Country    Spain                                    
;      Competition    Hugi Size Coding Competition #14         
;  
.MODEL TINY                                      ; Thanks to Aphex
.386                                             ; and Boreal for
.CODE                                            ; the test suites
.STARTUP                                         ;
        b       EQU byte ptr                     ;allow bytes manipulating short
@cosa:  mov     cl,offset MSG-0ECh                ;to write header
        mov     di,01000h+offset @cosa-offset MSG  ;in SPU file
        rep     movsb                             ;transfer bytes
        mov     ch,11h                         ;now DI=1014, fill with zeroes
        push    cx                         ;push 1100h
        rep     stosw                  ;zeroes filled
        inc     b ds:[1F05h]        ;PC=100
        pop     di               ;di=1100h code starts here
        mov     dh,22h         ;dx=22XXh source buffer
        mov     ax,1A5Ch     ;1Ah=change DTA  5Ch FCB address
        int     21h        ;changing DTA
        cbw               ;AX=005Ch
        xchg    ax,dx    ;DX=005Ch, AX=22XXh
        xchg    ax,si     ;SI=22XXh, AX=01B8h
        xchg    ax,cx        ;CX=01B8h, AX=0000h
        mov     ah,0Fh          ;ah=0Fh open FCB file
        int     21h                ;file opened
        mov     ah,14h                ;ah=27h read FCB file, one record
        mov     b ds:[bx+6Bh],cl        ;lengt of record 0080 >> 8000
        int     21h                       ;file read
        mov     word ptr ds:[bx+66h],'UP'  ;changing filename for SPU file
        mov     ah,16h                    ;create file FCB
        int     21h                     ;file created
        inc     si                   ;contrarrest the dec si in the line 1 that always detect label
@caca:  pusha                     ;store all register in the stack
        mov     bh,0ACh        ;load bx for the symbol table
@ragain:and al,11011111b    ;filtering the space char ;here is a lodsb hide
        xor al,0Bh        ;filtering the ; char 1Bh > 10h
        mov [bx],al     ;store the symbol in the symbol table
        inc bx         ;point to the next symbol char
        cmp al,11h      ;finding the end of the symbol
        jnc @ragain-1    ;repeat if not found
        dec si            ;pointing to the last not terminal char
        mov [bx],di         ;and finally save the pointer of this symbol at the end of his name
        mov bl,0FFh           ;point to the next simbol
@buclep:mov dx,1000000000000b  ;DX=1000 for DTA and Return instruction
        mov cl,0F7h           ;initialize cl with symbol indicator, may be otherwise but is for compatibility in older version
        mov ah,[si]         ;read first column char
        sahf              ;actualize the flags with ah
        cbw             ;reset al
        jz @ragain-1   ;if symbol found, jmp to save it in the symbol table
        jc @1310        ;if 0D or 3B (CR or Comment) are odds jmp to 1310
@letra2:lodsb            ;read the next char
@let2:  and al,11011111b  ;parse to lowcase
        jz @subala       ;find EOF or space char
        sub al,'A'      ;if al > Z
        jns @letras    ;repeat loop
@tetas: xchg ax,cx      ;if other char found, pass the checksum to al
        mov cl,41         ;and the hash table has 40 bytes 17 ops + 1 directive + 16 conditional jmps + 4 registers + 2 emptys
        push di             ;save di
        mov di,offset DATU   ;now di points to the op table
        repnz scasb         ;find the checksum op
        pop di            ;restore di
        dec si          ;point to the last char read
        lodsb          ;read last char
        jcxz @1310      ;if comment found (not instruction) jmp to 1310
        loop @puting     ;if is not a RETURN jmp to puting
        xchg AX,DX         ;elsewhere (RETURN) put this CODE = 1000h
@result:stosw                 ;store word to target
@1310:  lodsb                    ;finding a LF char
        sub al,10                   ;that is the end of the line
        jnz @1310                      ;if not, repeat
DATU    db 074h,0CFh,0B0h,04Fh,04Ah       ;074 is a jz buclep cf is not a valid opcode checksum
        db 0BEh,06Ch,045h,065h,0E8h,06Fh     ;all main opcodes minus JPOV 
        db 0C3h,057h,04Bh,03Dh,06Dh,051h,08Dh  ;this is the hash table
        db 0AFh,016h,0BCh,0E9h,077h,0E0h,0EAh    ;here are all 
        db 072h,0D1h,06Eh,0CEh,06Bh,07Dh,0F4h     ;the opcodes directives and  
        db 0C7h,064h,0DEh,07Bh,0D2h,0C9h,0D8h,83h  ;register
@letras:rol cl,1                                  ;algebraic conversion hash for
        sub cl,al                               ;the ops and registers checksum and shifted
@subala:or al,[si]                           ;check if EOF (End Of File) char = 0
        jnz @letra2                       ;if not close loop
@exit:  mov ah,1Ah                     ;elsewhere, end of pass and set DTA
        int 21h                     ;now DTA points DX = 1000h
        popa                     ;restore all registers
        loop @caca            ;make cx passes cx is the long of the source / 128
        mov ah,28h         ;FCB write file
        mov cl,32       ;write 4096 bytes
        int 21h        ;bytes writed and exit, find the ret in the obten routine
@obten: mov cl,3       ;this routine convert hexadecimal to binary, cl=3 digits
@obten3:shl dx,4        ;shift the nibbles read
        lodsb             ;read byte
        and al,11001111b    ;Thanks TAD
        aam 65                ;for the idea using aam and aad
        aad 10                  ;i have optimized 2 bytes
@stito: add dl,al                 ;actualize the total number
        loop @obten3                ;repeat 3 times
        xchg ax,dx                    ;parse result to ax
        ret                             ;end of routine, or of all (stk)=000  (000)=CD 20
MSG     db 13,10,'Hugi Compo #14...',26  ;header message
@puting:cmp al,39                       ;if is byte inmediate, not jumping
        loop @esp2                     ;if not DB directive jump to esp2
        jz @soncar                   ;jmp only if is a strig
@noson: call @obten                ;pass of hexadecimal to binary
        stosb                    ;actualize byte to target
        db 084h   ;jmp @1310   ;jmp to 1310 with test ah,xxxx ah=0 > zf=1
@soncar:movsb                ;parse byte
        cmp al,[si]       ;is char 39 '
        jz @1310        ;jmp to 1310
        jnz @soncar   ;if not repeat
@putita:dec ax      ;al=al-1 here is a STC instruction putita-1
        sbb ax,di  ;al= labelPC-actualPC-2
        mov ah,dl ;opcode to ah
        ret        ;return
@esp2:  mov ch,0Fh   ;then ah=0Fh for registers
        xchg ax,cx      ;move op to al
        add al,256-40+6   ;if is a register trasform al to 0-4
        jc @nosape         ;and jmp to nosapa to actualize directly
        db 68h              ;PUSH @result
        dw offset @result  ;for jumping and utilize obten routine
        add al,17         ;actualize the rest of ops to 0-16
        jc @despcu       ;if not conditional jmp, jmp to despcu
        add al,0B1h    ;if conditional jmp put high nibble C and low +1
@despcu:xchg ax,dx   ;passing to dx
        cmp cl,'%'  ;look the char in the operand
        jz @subala ;if is a %, decode hash the register
        jc @obten   ;if is less than % would be #, immed
@simbol:push bx      ;else is a @ label, save bx
        MOV BH,0ACh   ;point to symbol table
@saca2: mov bl,0FFh    ;first byte
        push si         ;pushing pointers
@cobu:  lodsb            ;read byte
        and al,11011111b  ;filter to space
        xor al,0Bh         ;filter to comment
        inc bx              ;point next char
        jz @fas3             ;if all symbol are compared jmp to end
        cmp b [bx],11h        ;find the terminal byte
        jc @fas2               ;if terminal byte found jmp to fas2
        cmp al,[bx]             ;compare bytes
        jz @cobu                 ;if source and target bytes are equals, compare next bytes
        db 03Dh                   ;cmp ax,XXXX jmp to saca2
@fas2:  ADD al,0EFh                ;find other terminal byte
@fas3:  pop si                      ;restore si
        jc @saca2                    ;if terminal bytes are found then
        inc bx                        ;label match
        dec dl                         ;decrement opcode and cond jmps ajusted
        mov ax,[bx]                     ;read the symbol numeric pointer
        pop bx                           ;recoverin bx
        js @putita-1                      ;if not cond jmps jmp nosape
@nosape:shl dl,4                           ;pass opcode
        add ah,dl                           ;for the rest of instructions
        ret                                  ;not conditional jumps
END ;=====================;That's all folks
