\HASH.XPL
\Program to search for perfect hash codes

\The XPL0 compiler (XPLX.EXE) used for this program can be downloaded from:
\ http://www.idcomm.com/personal/lorenblaney/

inc	\cxpl\codesi;

char	HT(34);			\hash code table
int	I, J, K, Found;


func	ROL(B);			\Rotate byte left
int	B;
begin
B:= B << 1;
if B > $FF then
	begin
	B:= B + 1;
	B:= B & $FF;
	end;
return B;
end;


func	ROL2(B);		\Rotate byte left with input carry
int	B;
begin
B:= B << 1;
if B > $FF then
	begin
	B:= B + 2;
	B:= B & $FF;
	end;
return B;
end;


func	ROR(B);			\Rotate byte right
int	B;
begin
if B & $01 then B:= B ! $100;
B:= B >> 1;
return B;
end;


func	ROR2(B);		\Rotate byte right with carry
int	B;
begin
if B & $01 then
	begin
	B:= B ! $100;
	B:= B >> 1;
	B:= B + 1;
	B:= B & $FF;
	end
else	B:= B >> 1;
return B;
end;


proc	Hash;			\Generate hash codes in HT
int	I, N, H, T C, M;
char	S;

begin
T:= [	"ADCA	0B0h",
	"ADDW	090h",
	"ANDA	0E0h",
	"DB	0FFh",
	"GOSUB	010h",
	"JP	000h",
	"JPA	0A7h",
	"JPBE	0A6h",
	"JPC	0A2h",
	"JPG	0AFh",
	"JPGE	0ADh",
	"JPL	0ACh",
	"JPLE	0AEh",
	"JPNC	0A3h",
	"JPNO	0A1h",
	"JPNP	0ABh",
	"JPNS	0A9h",
	"JPNZ	0A5h",
	"JPOV	0A0h",
	"JPP	0AAh",
	"JPS	0A8h",
	"JPZ	0A4h",
	"LDA	040h",
	"ORA	0D0h",
	"OSCALL	000h",
	"POPB	030h",
	"PUSHB	020h",
	"RDI	060h",
	"RDSYS	080h",
	"RETURN	010h",
	"SBBA	0C0h",
	"STA	050h",
	"WRI	070h",
	"XORA	0F0h"];

M:= 0;
for N:= 0, 34-1 do
	begin
	S:= T(N);
	H:= 0;
	I:= 0;
	loop	begin
		C:= S(I);
		I:= I + 1;
		if C = $09 then quit;
		\H:= H<<1 | (C-K);
		\H:= H | ((C+K) & $FF); must shift
		\H:= H<<1 + ((C-K)&$FF);  \\good K=1 works
		\H:= ROL(H) + ((C-K)&$FF);
		\H:= ROR(H) + ((C-K)&$FF);
		\C:= C & $1F;
		\H:= H<<1 + ((C+K)&$FF);
		\H:= ROL2(H) + ((C+K)&$FF);
		\H:= ROR2(H) + ((C+K)&$FF);

		C:= C & $FF;
		\H:= ROL(H) | ((C-K)&$FF);
		H:= H<<1 + ((C+K)&$FF);
		end;
	HT(M):= H;
	M:= M + 1;
	end;
end;	\Hash


begin	\Main
for K:= 0, 255 do
	begin
	Hash;

	\Are there any doubles?
	Found:= true;
	for I:= 0, 34-1 do
		begin
		if HT(I) = 0 \no opcode\ then Found:= false;
		if HT(I) = $FF \jmp\ then Found:= false;
		for J:= 0, 34-1 do
			begin
			if I # J then
				begin
				if HT(I) = HT(J) then Found:= false;
				end;
			end;
		end;
	if Found then [Hexout(0, K); Text(0, "    ")];
	end;
Crlf(0);
end;	\Main
