	page	240, 132
;ENTRY.ASM		Boreal		loren_blaney@idcomm.com
;HC14 SPEW Assembler
;
;Assemble:
; tasm /m
; tlink /t
;
;Run:
; ENTRY FILENAME.SAM
;			 +-----------+
;	FILENAME.SAM --> | ENTRY.COM | --> FILENAME.SPU
;			 +-----------+
;
SymSize	equ	50	;maximum number of names in symbol table (SymTbl)

	.model tiny
	.code
	.486
	org	100h
start:
	if 0				;TD debug
	xor	ax, ax
	xor	bx, bx
	mov	cx, 00FFh
	mov	dx, cs
	mov	si, 0100h
	mov	di, -2
	mov	bp, 0956
	cld
	endif

;(ax=0, bx=0, cx=00FFh, di=-2, df=0)
	mov	bl, 82h			;point to file name on command line
	mov	dx, bx			;save pointer for "open input file" cmd
	push	bx			;save pointer for "open output file" cmd
	add	bl, [bx+di]		;add length, bx points to last char + 2
	and	[bx+di], cx		;terminate file name with a 0

	mov	di, offset OutBufZ	;clear OutBuf, SymTbl & terminate InBuf
	mov	ch, high((TheEnd-OutBufZ)/2)+1
	rep stosw			;[di++]:= 0

	mov	ah, 3Dh			;open input (.SAM) file pointed to by dx
	int	21h			;al = 0 = normal file

	mov	dx, offset InBuf	;point to input buffer (= 5550h = 'UP')
	mov	word ptr [bx-3], dx	;change extension from 'SAM' to 'SPU'
;(cx=0)
	xchg	bx, ax			;get handle into bx
	dec	cx			;read entire file; cx:=FFFFh
	mov	ah, 3Fh			;read in .SAM file
	int	21h
;(ax = number of bytes transferred < 32K; ax<8000h)

;Register usage:
; bx =  program counter (PC)
; si -> current position in source file (InBuf)
; bp -> current position in symbol table (SymTbl)

DoPass:	mov	bx, 100h		;initialize program counter (PC)
	mov	si, offset InBuf	;point to start of source code
	mov	bp, offset SymTbl	;point to start of symbol table
DoLine	equ	$-2			;SymTbl location = 3CB4h = mov ah, 3Ch
;	mov	ah, 3Ch			;function code to create file (for cwd)
	cwd				;clear hash accumulator (ax<8000h)
	xor	cx, cx			;cx:= 0
	lodsb				;get first char on the line; al:= [si++]
	cmp	al, 8			;end of file (=0)?
	jae	GoPass			;jump if not

	bts	word ptr [OutBuf+0F05h], cx ;set PC register in SPEW to 0100h
	jnc	DoPass			;loop one time

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Write OutBuf to output (.SPU) file
;ah=3Ch, cx=0 = normal file (archive)
	pop	dx			;get pointer to output file name (.SPU)
	int	21h			;create file
	xchg	bx, ax			;get handle
	mov	ah, 40h			;write file
	mov	dx, offset OutBuf
	mov	ch, 10h			;write 4K bytes; cx:= 1000h = 4096
	int	21h
	ret				;exit to DOS

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;LABEL - Store label and its value into the symbol table
GoPass:	jp	Opcode			;40h-08=38h=odd (CR, space, ; give even)
	mov	di, bp			;insert label into the symbol table
	add	bp, 18			;point to next entry in SymTbl
	mov	[di], bx		;store label's PC value
	scasw				;di+=2 (preserve '@' in al)
	push	offset Opcode		;return here (avoids a jmp--ugly as sin)
					;store label's name
;-------------------------------------------------------------------------------
;Copy the string pointed to by si into the location pointed to by di.
; Terminate on a space, semicolon, CR, or 0.
; Converts string to lowercase.
; Output: al = terminator character
;	  si -> terminating character + 1
;	  di -> last char copied + 1
;
CopyStr:
CopyL:	stosb				;[di++]:= al
	lodsb				;al:= [si++]
	or	al, 20h			;shift A..Z to lowercase; 0..9 unchanged
	cmp	al, 3Bh			;';' semicolon (comment)?
	je	CopyD			;exit if so
	cmp	al, 30h			;space, CR or 0 terminates
	jae	CopyL			;else loop
CopyD:	ret

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;OPCODE - Convert opcode mnemonic to hash code, skip spaces before and after
OpL:	dec	ax
	shl	dl, 1			;calculate hash value (which gives
	add	dl, al			; unique hash codes for each mnemonic)
OpSp:	lodsb				;get next character; al:= [si++]
Opcode:	and	al, 0DFh		;force character to uppercase
	je	OpSp			;jump if space char--skip 'em
	cmp	al, '@'			;loop if alpha (exit if ; or CR)
	ja	OpL
	push	dx			;save hash code (0=no mnemonic)
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;OPERAND - value is output in dx register
	cwd				;assume no operand; dx:= 0
	je	IsLabel			;is operand a label (@)?
	cmp	al, '#'-20h		;is it an immediate value?
	je	IsNum
	jp	OperDone		;jump if no operand (0Dh, or 3Bh)
	cmp	al, "'"-20h		;is it a string?
	je	IsStr
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Set dx to SPEW register address
;NAME   LEN	ADDR
; A      1	0F00
; PC     2	0F04
; STK    3	0F02
; STATUS 6	0F01
IsReg:	mov	dx, 0FA0h		;dh:= 0Fh
IsRegL:	shr	dl, 1			;shift pattern ->
	lodsb				;al:= [si++]
	cmp	al, 'A'			;loop for length many (+1) characters
	jae	IsRegL
	and	dl, 07h			;mask off possible garbage
	jmp	OperDone
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Read in 3 ASCII hex digits and convert the value to binary in dx
;(cx=0)
IsNum:
IsNumL:	lodsb				;al:= [si++]
	and	al, 0CFh		;convert ASCII 0..9 to binary & shift up
	aam	41h			;convert A..F to 101h..106h
	aad	10			;add 10 if A..F (thanx TAD!)
	shl	dx, 4
	or	dl, al
	inc	cx			;loop 3 times: cx = 0, 1, 2
	jnp	IsNumL
	jmp	OperDone
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;DB String
IsStrL:	mov	[bx+offset OutBuf], al	;store char in output buffer
	inc	bx			;bump PC
IsStr:	lodsb				;al:= [si++]
	cmp	al, "'"			;is it the close quote?
	jne	IsStrL			;loop if not
	pop	ax			;discard opcode hash & balance stack
	jmp	GenOpD
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Read in and look up label name in symbol table; return its value in dx
IsLabel:mov	di, offset SymEnd+2	;copy label to the end of SymTbl
	push	di			;save location of our label
	call	CopyStr			;label is already terminated with zeros
	pop	di			;point to label
	push	si			;save InBuf pointer
	mov	si, offset SymTbl	; will always find at least our copy
	mov	cl, SymSize+8+1		;search symbol table (& copy) for label
LabelL:	lodsw				;get symbol's value
	pusha				;save cx, si, di
	mov	cl, 8			;compare 16 characters
	repe cmpsw			;[si++] = [di++]
	popa
	lea	si, [si+16]		;point to next symbol entry (w/o status)
	loopne	LabelL
;(won't find forward-referenced labels on pass 1, except our copy at the end)
	xchg	dx, ax			;get symbol's value into dx; ax:=0
;(SymSize+8 >= cx >= 8 because of our copy of label at the end)
;	mov	cl, 8			;erase label location for next time
	rep stosw			;[di++]:= ax
	pop	si			;restore pointer into InBuf
OperDone:
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;GENERATE CODE - dx = operand value (= 0 if no operand)
	pop	ax			;al:= mnemonic's hash value
	mov	cl, 16+16+3		;look it up in opcode table
	mov	di, offset OpTbl
	repne scasb
	jne	GenOpD			;jump if not found (no opcode)
	xchg	ax, cx			;al:= opcode value (>>4)

	lea	di, [bx+offset OutBuf]	;di:= pointer to code in OutBuf
	inc	bx			;bump PC for first byte

	cmp	al, 0Ah			;DB instruction?
	je	DoGen			;jump if so--go store dx (dh=0)

	inc	bx			;bump PC for second byte

	test	al, 10h			;conditional jump instruction (JPcc)?
	je	NotJPcc			;jump if not
	add	al, 0A0h-10h		;adjust opcode (A0..AF)
	sub	dx, bx			;calculate relative address
					; if dh=FFh then carry is set
	db	0B9h			;skip 2 bytes w/o status (= mov cx, imm)
NotJPcc:
	shl	al, 64h			;clears carry (& MSB of OSCALL & RETURN)
					;actually shifts by 4 (except on 8086)
					;64h = fs segment override, not used
	adc	dh, al			;combine opcode and operand and carry
DoGen:	xchg	ax, dx			;generate code for normal instruction
	stosw				;[di++]:= ax
GenOpD:
D10:	lodsb				;eat rest of line, including CR LF
	sub	al, 0Ah
	jne	D10
	jmp	DoLine			;loop for next line

;-------------------------------------------------------------------------------
;Opcode hash table. The hash code is looked up and the corresponding index
; provides the opcode. (A separate program was used to search for this perfect
; hashing function.)
;
OpTbl	equ	$-1	;the above jmp = 0FFh, which is not in the table
	db	037h	;RETURN    1000
	db	0D1h	;OSCALL    00xx

	db	008h	;JPG       AFrr
	db	05Eh	;JPLE      AErr
	db	054h	;JPGE      ADrr
	db	00Dh	;JPL       ACrr
	db	06Dh	;JPNP      ABrr
	db	011h	;JPP       AArr
	db	070h	;JPNS      A9rr
	db	014h	;JPS       A8rr
	db	002h	;JPA       A7rr
	db	04Ah	;JPBE      A6rr
	db	077h	;JPNZ      A5rr
	db	01Bh	;JPZ       A4rr
	db	060h	;JPNC      A3rr
	db	004h	;JPC       A2rr
	db	06Ch	;JPNO      A1rr
	db	075h	;JPOV      A0rr

	db	0D2h	;XORA      Fxxx
	db	0FAh	;ANDA      Exxx
	db	01Ah	;ORA       Dxxx
	db	056h	;SBBA      Cxxx
	db	0D0h	;ADCA      Bxxx
	db	0C7h	;DB
	db	0E8H	;ADDW      9xxx
	db	072h	;RDSYS     8xxx
	db	042h	;WRI       7xxx
	db	012h	;RDI       6xxx
	db	02Eh	;STA       5xxx
	db	0F2h	;LDA       4xxx
	db	08Fh	;POPB      3xxx
	db	0A7h	;PUSHB     2xxx
	db	001h	;GOSUB     1xxx
	db	0E1h	;JP        0xxx

;-------------------------------------------------------------------------------
;This is the signature that is placed in the first part of the .SPU file.
; This area is overwritten on startup by the EMUlator, so it can be almost
; anything. Sniper chose to place some information/advertisment text and the
; EOF char (ASCII 1Ah) so the DOS TYPE command will display the text.
OutBuf	db	13, 10, 'Hugi Compo #14...', 1Ah
OutBufZ	db	4096-20 dup (?)		;output buffer (.SPU file)

	org	3CB4h			;(= mov ah, 3Ch)
SymTbl	db	SymSize*18 dup (?)	;SimSize 16-character symbols + value
SymEnd	equ	$			;last location in SymTbl +1
;There must be at least (SymSize+8)*2 bytes available here

	org	5550h			;5550h = 'UP' (as in 'SPU')
InBuf	db	32768 dup (?)		;input buffer (.SAM file--at least 32K)
TheEnd	equ	$
	end	start
