	page	240, 132
;EXAMPLE.ASM	08-NOV-00
;Example program for the Hugi Size Coding Compo #13 (the unlucky compo?)
;This is a version of the Soko-Ban game.
;Coded by Boreal, with inputs from Bonz & Metalbrain. Thanx guys!

;REVISIONS:
;05-NOV-00, Conditional assembly option to make "keys" tester files.
;08-NOV-00, The makekeys option uses '2' instead of the bell to advance to
; the next level.
;
;"Soko ban" is Japanese for "warehouse man". Use the arrow keys to move
; the man and push the yellow boxes onto the light blue loading docks. Only
; one box can be pushed at a time.
;
;Start by typing "example a" at the DOS prompt. "a" is the starting level.
; You can start at any level a-z or 0-9. If a level is not specified (such
; as when running from Windows) then "a" is used. When a level is completed,
; the next level (b) loads automatically.
; 
;If you make a mistake, such as pushing a box into a corner, you can undo
; moves with the Backspace key. The Esc key terminates the program.
;
;					Ŀ
;Assemble with:				 0 0 
; tasm /m entry				\___/
; tlink /t entry			
;					Soko Ban
;
makekeys equ	0			;make keys output file

;
;Colors:
Black	equ	0
Blue	equ	1
Green	equ	2
Cyan	equ	3
Red	equ	4
Magenta	equ	5
Brown	equ	6
White	equ	7
Gray	equ	8
LBlue	equ	9			;light blue
LGreen	equ	0Ah
LCyan	equ	0Bh
LRed	equ	0Ch
LMagenta equ	0Dh
Yellow	equ	0Eh
BWhite	equ	0Fh			;bright white

;Objects:
ManSym	equ	LBlue*100h+02h		;man symbol code
BoxSym	equ	Yellow*100h+0FEh
WallSym	equ	Red*1000h+White*100h+0B0h
FloorSym equ	White*1000h+20h
DockSym	equ	Cyan*1000h+20h

	.386
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h
Start:	cmp	byte ptr ds:[80h], 2	;is there a file name on command line?
	jne	NoName
	mov	al, ds:[82h]		;use it if so, else use default name
	mov	FileName, al
NoName:
GameLoop:
	mov	ax, 3D00h		;open input file containing floor plan
	mov	dx, offset FileName
	int	21h
	jc	AllDone			;exit program if no more levels
	push	ax			;save file handle

	mov	ax, 1			;set 40-column text mode
	int	10h
	mov	ah, 1			;turn off irritating flashing cursor
	mov	ch, 20h
	int	10h

;Convert symbols in file to more colorful characters on screen
	mov	ax, 0B800h		;point to text screen
	mov	es, ax
	mov	di, (4*40+10)*2		;cursor to line 4, column 10 (start @ 0)
ReadLoop:
	mov	ah, 3Fh			;read a character from file
	pop	bx			;get handle
	push	bx
	mov	cx, 1			;number of bytes
	mov	dx, offset Buffer
	int	21h
	cmp	ax, 0			;number of bytes actually read
	je	ReadDone		;if none then done
	mov	al, Buffer		;get symbol

	cmp	al, 0Dh			;if carriage return then move to start
	jne	cvt1			; of next line down (cursor is already
	add	di, 20*2		; at column 20)
	jmp	ReadLoop
cvt1:
	cmp	al, 0Ah			;ignore line feeds
	jne	cvt2
	jmp	ReadLoop
cvt2:
	cmp	al, 20h			;space character = floor
	jne	cvt3
	mov	ax, FloorSym
	jmp	cvt9
cvt3:
	cmp	al, 22h			;background symbol
	jne	cvt4
	mov	ax, 20h
	jmp	cvt9
cvt4:
	cmp	al, '#'
	jne	cvt5
	mov	ax, WallSym
	jmp	cvt9
cvt5:
	cmp	al, '!'
	jne	cvt6
	mov	ax, DockSym
	jmp	cvt9
cvt6:
	cmp	al, '&'
	jne	cvt7
	mov	ax, FloorSym-20h+ManSym	;man on floor
	mov	si, di			;record location of man in si
	jmp	cvt9
cvt7:
	cmp	al, '$'
	jne	cvt8
	mov	ax, FloorSym-20h+BoxSym	;box on floor
	jmp	cvt9
cvt8:
	cmp	al, '%'
	jne	cvt9
	mov	ax, DockSym-20h+BoxSym	;box on loading dock
cvt9:
	stosw				;write colorful character to screen
	jmp	ReadLoop

ReadDone:
	mov	ah, 3Eh			;close file handle
	pop	bx
	int	21h

	mov	al, FileName		;display file name (= current level)
	mov	ah, LRed		; in light red
	mov	es:[0], ax		; in upper-left corner

	mov	MoveCntr, 0		;initialize move counter
	call	ShowCntr		; and display it

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
MainLoop:
	mov	ah, 0			;get command from keyboard
	int	16h


	if	makekeys
;Record keystrokes in redirected DOS output file, "keys"
; The arrow keys are converted to their ASCII numeric equivalents
	pusha
	cmp	al, 0			;non-ASCII character?
	jne	key10			;jump if not--use ASCII code

;Scan Code   Index   Direction
;   48h        0       up       '8'
;   4Bh        1       left     '4'
;   4Dh        2       right    '6'
;   50h        4       down     '2'
	mov	al, ah
	sub	al, 48h
	shr	al, 1
	mov	bx, offset Movetbl
	xlat	cs:0
key10:
	mov	ah, 02h			;output ASCII to stdout
	mov	dl, al
	int	21h
	popa
	endif


	cmp	al, 08h			;backspace = undo last move
	je	Undo

	cmp	al, 1Bh			;esc = exit program
	je	AllDone

;Arrow keys = direction to move man
; si = current man location
; bx = possible new man location
; di = possible new box location
	cmp	ah, 4Bh			;left
	jne	key1
	lea	bx, [si-2]
	lea	di, [bx-2]
	jmp	key9
key1:
	cmp	ah, 4Dh			;right
	jne	key2
	lea	bx, [si+2]
	lea	di, [bx+2]
	jmp	key9
key2:
	cmp	ah, 48h			;up
	jne	key3
	lea	bx, [si-40*2]
	lea	di, [bx-40*2]
	jmp	key9
key3:
	cmp	ah, 50h			;down
	jne	MainLoop		;illegal keys are ignored
	lea	bx, [si+40*2]
	lea	di, [bx+40*2]
key9:
;Save current state for Undo command
	push	word ptr es:[si]	;save man and his background
	push	word ptr es:[bx]	;save contents at new man location
	push	word ptr es:[di]	;save contents where box might go
	push	si			;save location of man
	push	bx			;save new location of man
	push	di			;save new location of box
	push	MoveCntr		;save move counter

	inc	MoveCntr		;count move

;Make actual move
	mov	al, es:[bx]		;is new man location on floor or dock?
	cmp	al, 20h
	je	MoveMan			;jump if so

	cmp	al, low BoxSym		;is a box being pushed?
	jne	SkipUndo		;jump if not -- can't move

	mov	al, es:[di]		;is new box location on floor or dock?
	cmp	al, 20h
	jne	SkipUndo		;jump if not -- can't move

	and	word ptr es:[di], 0F000h ;move box (keep background color)
	or	word ptr es:[di], BoxSym
MoveMan:
	mov	byte ptr es:[si], 20h	;blank out old location
	and	word ptr es:[bx], 0F000h ;move man (keep background color)
	or	word ptr es:[bx], ManSym
	mov	si, bx			;update man's location
	jmp	SkipUndo

Undo:	cmp	sp, 0FFFEh		;skip if nothing to undo
	je	SkipUndo		;(don't blow the stack)
	pop	MoveCntr		;restore state for previous move
	pop	di
	pop	bx
	pop	si
	pop	word ptr es:[di]
	pop	word ptr es:[bx]
	pop	word ptr es:[si]
SkipUndo:
	call	ShowCntr		;display move counter

;Detect if level is finished
;Go back to MainLoop if any dock isn't loaded with a box
	mov	di, 24*40*2
fin:	mov	ax, es:[di]		;get character cell location
	and	ah, 0F0h		;is it a dock location?
	cmp	ah, high DockSym
	jne	fin10			;jump in not
	cmp	al, low BoxSym		;is there a box on it?
	jne	MainLoop		;loop back if not
fin10:	sub	di, 2			;next cell
	jne	fin

	mov	ah, 2			;else beep speaker

	if	makekeys
	mov	dl, '2'
	else
	mov	dl, 7
	endif
	int	21h

	mov	sp, 0FFFEh		;(don't blow the stack)

	mov	ah, 0			;wait for keystroke
	int	16h			; (and admire your handiwork)

	inc	FileName		;form next file name for next level
	jmp	GameLoop		;loop for all levels
AllDone:
	mov	ax, 3			;restore 80-column text mode
	int	10h
	mov	ah, 4Ch			;exit program
	int	21h

;--------------------;
;Display move counter;
;--------------------;
ShowCntr:
	pusha
	mov	ax, MoveCntr
	mov	di, 39*2		;set cursor to upper-right corner
	mov	bx, 10
mc10:	cwd
	idiv	bx
	add	dl, '0'
	mov	dh, Yellow
	mov	es:[di], dx		;write digit
	sub	di, 2
	cmp	ax, 0
	jne	mc10
	stosw				;blank possible digit when undoing moves
	popa
	ret


FileName db	'A', 0			;default file name
Buffer	 db	0			;for reading file
MoveCntr dw	0			;move counter

	if	makekeys
MoveTbl	db	'8', '4', '6', 0, '2'
	endif
cseg	ends
	end	Start
