; Entry.asm
; Entry for HUGI SIZE CODING COMPETITION 13
;
; By: Kees Willem van der Meer
;
; assemble with:
;   nasmw entry.asm -f bin -o entry.com
;
; Resulting com-file 215 bytes

; Map symbols
mFloor			equ	20h	; 0010 0000
mDock			equ	21h	; 0010 0001
mBackground		equ	22h	; 0010 0010
mWall			equ	23h	; 0010 0011
mBox			equ	24h	; 0010 0100
mDockedBox		equ	25h	; 0010 0101
mMan			equ	26h	; 0010 0110
mDockedMan		equ	27h	; 0010 0111

; Ascii codes
Cr			equ	0Dh	; 0000 1101
Lf			equ	0Ah	; 0000 1010
Bell			equ	7
			; flags	bits      sz a  p c
; Characters
Space			equ	20h	; 0010 0000
Screen			equ	0B0h	; 1011 0000
Square			equ	0FEh	; 1111 1110
Face			equ	02	; 0000 0010

; Colors
Black			equ	0	; 0000
Cyan			equ	3	; 0011
Red			equ	4	; 0100
White			equ	7	; 0111
LightBlue		equ	9	; 1001
LightRed		equ 	0Ch	; 1010
Yellow			equ	0Eh	; 1110

; Scan codes
CrUp			equ	48h	; 0100 1000
CrLf			equ	4Bh	; 0100 1011
CrRg			equ	4Dh	; 0100 1101
CrDn			equ	50h	; 0101 0000
BkSp			equ	0Dh	; 0000 1101
Esc			equ	1	; 0000 0001
			; flags bits      sz a  p c

CommandTail		equ	80h
FileName		equ	CommandTail+2

		; si=100
		
		org   0100h
		push	word 0B800h
		pop	es			; load es with address video memory

		shr	si, 1			; si := 80h : CommandTail
		lodsw
		sahf				; ah = Space or Cr
		pop	ax			; one word (0) on stack initially
		jnc	NewGame			; if Cr then
		mov	byte [si], 'A'		;   set filename to 'A'
NewGame:
		pushaw				; push initial registers
						; ax = 0; bx = 0; cx = 00FF; dx = PSP
						; si = 82; di = FFFE; bp = 09xx; sp = FFF0
		int 	10h			; set mode 0

		xchg	bp, ax			; reset move counter in bp; int 10h ah=0
						; does not modify ax
		mov	dx, si			; Set up dx for FileOpen
		lodsb				; Load file name
		mov	ah, LightRed
		xchg	[es:bx], ax		; Show filename and set ax to 7020h
		mov	[si], bl		; Terminate filename with 0

		mov	ah, 3Dh			; open file; al = 20h = ReadOnly+DenyWrite
		int	21h

		jnc	GameLoop		; check result of int 21h; start game if success
Quit:						
		mov	ax, 3
		int 	10h			; video mode 3
		int	20h			; = db Space
SymbolTable	equ $-1
		;db Space
		db (White<<4) + White		; 79h = 0111 0111
		db Space
		db (Cyan<<4) + White		; 39h = 0011 0111
		db Space
		db (Black<<4) + Black 		; 00h = 0000 0000
		db Screen
		db (Red<<4) + White 		; 47h = 0100 0111
		db Square
		db (White<<4) + Yellow 		; 7eh = 0111 1110
		db Square
		db (Cyan<<4) + Yellow 		; 3eh = 0011 1110
		db Face
		db (White<<4) + LightBlue	; 79h = 0111 1001
		db Face
		db (Cyan<<4) + LightBlue	; 39h = 0011 1001
						; Flags sz a  p c
NextFile:
		; reset stack pointer
		mov	sp, -16
		popaw			; load initial registers
		inc	byte [si]	; increment level filename
		jmp	short NewGame
GameLoop:
		; second time ah = scancode->invalide handle
		xchg	ax, bx			; store filehandle in bx
		mov	ah, 3Fh			; read from file 
		mov	cx, (17*20)*2 + 17*2 - 2; During drawing of screen:
						; Each map symbol passes 2 LOOP's
						; Each Cr or Lf passes 1 LOOP
						; Ignore last CrLf: Algorithm
						; must end with map symbol
		mov	dx, cx			; dx (Buffer) = 712 = 
						; PSP + 456 is beyond end of code					
		int	21h
		mov	ah, 3Eh
		int	21h

		; Draw screen
		mov	si, dx			; Buffer
		mov	di, ((4*40)+10)*2-20	; = 320
Skip20:
		lea	di, [di+20]
Next:
		lodsb				; read map symbol
		cbw
		test	al, 0F0h
		loope	Skip20			; loop if Cr or Lf
		shl	ax, 1
		xchg	bx, ax
		
		mov	ax, [SymbolTable-40h+bx]; read ax from SymbolTable
				
		sahf				; store attribute in Flags
		jnc	EndTests
		jp	NoMan
		push	si			; push position of man
NoMan:	
		jz	EndTests
		cwd				; set dx to 0 if dock without box found
EndTests:	
		stosw	
		loop	Next	

		pop	si			; si = man position-1
		dec	si
			
		dec	dx			; SF set if dock without box found
		pushf				; push result and D-flag
		std				; set D-flag for showing counter

		mov	ah, 2	
		mov	dx, (19h<<8) | Bell
		js	ShowCounter	

		; Game over: Make sound (ah=2 dl=Bell)
		int	21h		
ShowCounter:
		; Hide cursor by setting it to line 25 (ah=2 bh=0 dh=19h)
		int 	10h
		
		; Show move counter in bp
		mov	di, 39*2
		mov	ax, bp
		mov	bl, 10			; bh = 0
PrevDigit:
		cwd				; set dx to 0
		div	bx			; divide ax by 10
		xchg	ax, dx
		add	ax, (Yellow<<8)|'0'	; add '0' to remainder and Yellow fgcolor
		stosw
		xchg	ax, dx
		or	ax, ax			; set zero flag if ax = 0
		jnz	PrevDigit
		stosw				; ax = 0

		int 	16h			; ah=0: read keyboard
						; ah=ScanCode of key read
						; al=ascii

		popf				; Pop result of game-over test and reset D-Flag
		jns	NextFile		; Game over: next level

		sahf				; Store scan code in flags register
		mov	bl, 1
		ja	Undo			; CF=0 and ZF=0 for BackSpace (0Dh)
		jnz	Quit			; ZF=1 for cursor keys

		; load bx with delta for move
		; bl=1
		jc	LeftOrRight
		mov	bl, 22
LeftOrRight:
		cmp	ah, CrRg
		jae	RightOrDown	
		neg	bx
RightOrDown:
		lea	di, [si+bx]		; di = New man position

		clc				; signal first pass	
SwapSymbols:	
		; load symbols from map on first pass
		; write symbols to map on second pass or after Undo
		xchg	ah, [si]		; ah = man symbol
		xchg	al, [di]		; al = symbol at new man position
		xchg	dl, [di+bx]		; dl = symbol at new box position
NoUndo:		
		jc	GameLoop		; Jump on second pass
		
		pushaw				; push all symbols and positions 

		inc	bp			; increment move counter
		
		cmp	al, mDock		; Move if new man position = Floor or Dock
		jbe	MoveMan
		cmp	al, mWall		; No move if new man position = Wall (or Background)
		jbe	ChangeMap
		cmp	dl, mDock		; No move if new box-position <> Floor or Dock
		ja	ChangeMap		

		add	dl, mBox-mFloor		; Add box to new box-position
		add	al, mFloor-mBox		; Subtract box from old box-position
MoveMan:
		; add man to new man-position in al and
		; subtract man from old man-position in ah
		add	ax, ((mFloor-mMan)<<8) | (mMan-mFloor)
		
		jmp	short ChangeMap 
Undo:		
		cmp	bp, bx			; bx=1, carry if move counter=0 
		jc	NoUndo			; then no move
		popaw				; pop all symbols and positions and move counter
ChangeMap:
		stc				; Signal second pass
		jmp	short SwapSymbols
