; Hugi Size Coding Competition #13

;         fabled's entry



[bits 16]

[org 100h]



start:

        ;-----------------Point ES to video memory

        push    word 0b800h

        pop     es



        ;-----------------Set DTA to DS:DX

        mov     ah, 01Ah

        int     21h



readfile:

        ;-----------------Initialize filename & SP

        xor     di, di

        xor     sp, sp

        mov     si, 0005dh

        mov     ax, 04120h

        cmpxchg byte [si], ah



        ;-----------------Open & read file

        mov     dx, 05ch

        mov     ah, 0fh

        int     21h

        mov     [si-1+0fh], ah          ;record size to 0f80h

        cbw                             ;ax = -1 or 0

        inc     ax                      ; 0=>error, 1=>ok

        jz      quit



        ;-----------------Initialize display

        int     10h                     ;set 40x25 mode



        mov     ax, 210ch               ;random read

        movsb                           ;write the letter of filename

        stosb                           ;attribute of filename on screen

        int     21h                     ;read the entire map

        cwd                             ;clear moves counter



        xchg    ax, cx

        mov     ah, 01h                 ;010h / 1, attribute for filename

        int     10h                     ;turn off irritating flashing cursor



updateScreen:

        ;-----------------Convert map & display it

        mov     si, cs

        mov     cx, 374-2*17            ;length of the map minus linefeeds

        mov     di, (4*40+10)*2 -20     ;cursor to line 4, column 10 (start @ 0)

adjust: add     di, 20        

read:   lodsb

        sub     al, 20h

        js      adjust

        cbw

        add     al, (conv-start+100h)/2

        mov     ax, [2*eax]

        stosw

        loop    read



        ;-----------------Find the position of man

        std

find:   lodsb

        cmp     al, 25h

        jle     find

        inc     si



        ;-----------------Write moves counter

        pusha                           ;need dx and di

        mov     di, 39*2                ;set cursor to upper-right corner

        mov     cl, 10

        xchg    ax, dx

mc10:   cwd

        idiv    cx

        xchg    ax, dx

        add     ax, 00E30h

        stosw                           ;write digit

        xchg    ax, dx

        or      ax, ax

        jnz     mc10

        stosw

        popa



        ;-----------------Check for solved maze

        mov     ch, 4                   ;Area to search

        mov     ax, 00239h              ;Attribute of dock without box

                                        ;(+function for beep)

        repne   scasb                   ;Find them

        cld

        je      dokey                   ;Found orphan docks?



        ;-----------------Beep the speak

	mov	dl, 7

	int	21h



        ;-----------------New file name

        inc     byte [05dh]



        ;-----------------Read a key

dokey:  cbw                             ;ah=0

	int	16h

        jne     readfile                ;change level if level complete



        ;-----------------Check for control keys

        cmp     al, 1Bh ;esc = exit program

quit:   mov     cx, 3

        jne     noquit

        xchg    ax, cx                  ;restore 80-column text mode

        int     10h

        int     20h



noquit:

;;        cmp     al, 08h ;backspace = undo

;;        jne     noundo

        jnp     noundo



        dec     dx

        js      nomove



restor: pop     si

        pop     word [si]

        loop    restor



j_updateScreen:

        jns     updateScreen



noundo:

        ;-----------------Convert arrow key to adder

        mov     al, ah

        sub     al, 04ch

        sahf

        cbw

        jc      lr

        sar     ax, 1

        imul    ax, byte 11

lr:     



        ; Positions in the plan; not the display



        xchg    ax, bp

        lea     di, [si+bp]



        mov     bx, si

store:  push    word [bx]

        push    bx

        add     bx, bp

        loop    store



        mov     al, 000000110b          ;06, value for map manipulation



        cmp     byte [di], 023h         ;what type?

        je      nomove                  ;==>wall?

        jb      moveMan                 ;==>floor or dock?

                                        ;==>it must be box



        test    byte [di+bp], al           ;floor or dock?

        jnz     nomove                  ;==>no, can't move



        or      byte [di+bp], 004h         ;change to have box



moveMan:

        or      byte [di], al           ;change to have man

        sub     byte [si], al           ;remove man



nomove:

        inc     dx                      ;increment moves counter

        jns     j_updateScreen





;      Space   20  0000   Floor           White background       20 70

;        !     21  0001   Loading dock    Cyan background        20 30

;        "     22  0010   Background      Black background       20 07

;        #     23  0011   Wall            White screen on red    B0 47

;        $     24  0100   Box on floor    Yellow box on white    FE 7E

;        %     25  0101   Box on dock     Yellow box on cyan     FE 3E

;        &     26  0110   Man on floor    L.Blue face on white   02 79

;        '     27  0111   Man on dock     L.Blue face on cyan    02 39



;align 2

conv

        ;dw 07020h

        db 077h

        dw 03920h

        dw 00720h

        dw 047b0h

        dw 07efeh

        dw 03efeh

        dw 07902h

        dw 03902h



