        segment code
        assume cs:code,ds:code
        org 100h
        .586

        s       equ     short
        b       equ     byte ptr
        w       equ     word ptr
        d       equ     double ptr
        o       equ     offset
        salc    equ     db 0d6h
        level   equ     01fch

@start:
        int     10h
@readparam:
        mov     al,[bx+5dh]
        cmp     al,20h
        jne     @gotname
        mov     al,'A'
@gotname:
        push    ax
        mov     dx,sp
        mov     ax,3d00h
@openfile:             
        int     21h    
        mov     dh,high level
        jc      @quit
        xchg    ax,bx  
@readfile:             
        mov     ch,3eh
        mov     ah,03fh
        int     21h    
@closefile:            
        int     10h    
        xchg    ax,cx  
        int     21h    
@setscreenbase:        
        push    0b800h 
        pop     es  
@resetcounter:      
        cwd                     ; dx=counter=0
        pop     ax
        pop     di
        push    di
        push    ax
        mov     ah,0ch
        stosw

@displaylevel:
        mov     si,level-1
        mov     cx,17*20   
        mov     di,300  
        xor     bp,bp
@endofline:
        lodsb                  
        add     di,40          
@show:                  
        lodsb           
        cbw
        add     al,072h
        jns     @endofline  
        shl     ax,1        
        xchg    ax,bx       
        mov     ax,[bx +72h]

        stosw                  

        sahf
        jp  @nothing
        jz  @nodock
        inc     bp
@nodock:
        dec     ax              ; test for man
        jpe     @nothing        
        push    si              ; found one.
@nothing:
        loop    @show          

@displaycounter:
        mov     di,78
        mov     cl,10
        push    dx
        xchg    ax,dx
        std
@divloop:
        cwd
        div     cx
        xchg    ax,dx
        add     ax,0e30h     
        stosw
        xchg    ax,dx
        or      ax,ax
        jnz     @divloop
        rep     stosw
        cld
        pop     dx

@restoreman:
        pop     si             
        dec     si             

@checkwon:
        dec     bp
        jns     @readkey       
        mov     sp,0fffch
        mov     al,07          
        int     29h            
        int     16h            
        pop     ax
        inc     ax
        jmp     @gotname       
@readkey:
        int     16h            
@checkkey:
        inc     ax
        jpe     @undo          
@move:
        shr     ax,9           
        jnz     @dontquit
@quit:
        mov     al,3           
        int     10h            
        int     20h            

@keytab:
        db -22,-1    
        db 1,0       
@convert:                             
        db 016h,077h         ;0111 0111  e
        db 000h,039h         ;0011 1001  e
        db 000h,004h         ;0000 0100  e
        db 0B0h,047h         ;0100 0111  e
        db 0FEh,07Eh         ;0111 1110  o
        db 0FEh,03Eh         ;0011 1110  o
        db 002h,079h         ;0111 1001  o
        db 002h,039h         ;0011 1001  o


@dontquit:
        mov     bl,low (o @keytab)-24h  ; bh=1
        xlat                    
        cbw                     
        xchg    ax,bx           
        lea     di,[si+bx]      

@savemove:
        mov     al,[di]
        mov     cl,[di+bx]
        mov     ah,[si]
        pusha

@checkpossible:
        cmp     al,23h      
        je      @forget         
        jb      @moveman        

@checkbox:
        cmp     b [di+bx],23h
        jge     @forget
@movebox:
        sub     al,4
        add     b [di+bx],4     
@moveman:
        add     al,6        
        sub     b [si],6        
@forget:
        inc     dx
        jmp     @kickit1
@undo:
        dec     dx              
        js      @forget
        popa
        mov     [si],ah
        mov     [di+bx],cl
@kickit1:
        mov     [di],al
@forget1:
        jmp     @displaylevel

        code ends
        end @start

                                



                                

