;Soko-Ban Game
;coded by
; Boreal (general idea & reference) and
; Bonz (general rewrite & size optimization)
;
; 404 Boreal's code
; 251 first version sent to Adok
; 250 store filename in BX (done to show up CMPXCHG, also saved me a byte...)
; 249 use CX left by INT 21h/AH=3Fh to load SI
; 246 use yellow+'0' left by move printing as counter to find empty dock
; 242 use PUSHA for undo stack (16*4000=64000 bytes)
; 241 use sign flag rather than carry to detect if CR/LF or not
; 235 draw floors & empty docks with a blue foreground
; 234 back to using SCAS for searching empty dock
; 232 use a MOV (shared with undo) to show the man
; 225 use the contents of AX to move the man and to do comparisons
; 224 only set the attribute (CH) of the mask used to move boxes
; 223 store Keys at the beginning of the program
; 222 use STOSW in the undo routine
; 220 parse keys from the scan codes
; 219 use the "transform next instruction" trick in the parsing routine
; 218 use DEC to test whether undo is possible
; 217 preserve all registers while a level is loaded and played
; 216 do INT 29H before reaching the `end' label
; 215 no more CMPXCHG sorry -- I needed AX = 0 to save two bytes; I lost
;     one because the CMPXCHG sequence was a byte smaller, net result = -1.
;     This was tricky: I could not leave Keys where it was, because
;     executing the data modified AX; now I have to put it exactly at 012Eh,
;     which I could (luckily) do easily, without losing bytes... I did this
;     optimization on the last day, when I was sure I could not make it
;     better, because I cannot imagine how painful it would make further
;     debugging!!!

;Assemble with:
; nasm -fbin -oentry.com entry

;Circumvent nasm's inefficient encodings for, respectively,
;mov	ax, [bx+%1]
;mov	di, [bx+%1]
;mov	[bx+%1], di

%define SET_AX_FROM_BX_PLUS	db 8bh, 47h,
%define SET_SI_FROM_BX_PLUS	db 8bh, 77h,
%define MOV_DI_TO_BX_PLUS	db 89h, 7fh,

;Colors:
Cyan	 equ	3
Red	 equ	4
White	 equ	7
LBlue	 equ	9
LRed	 equ	12
Yellow	 equ	14

DockAttr equ	Cyan*10h+LBlue
XorAttr	 equ	LBlue^Yellow

FloorSym equ	White*1000h+LBlue*100h+00h	 ;32 space
DockSym  equ	Cyan*1000h+LBlue*100h+00h	 ;33 !
BlackSym equ	0h				 ;34 "
WallSym	 equ	Red*1000h+White*100h+0B0h	 ;35 #
BoxSym	 equ	White*1000h+Yellow*100h+0FEh	 ;36 $
BDSym	 equ	Cyan*1000h+Yellow*100h+0FEh	 ;37 %
ManSym	 equ	White*1000h+LBlue*100h+02h	 ;38 &

	org	100h
Entry:

	push	word 0b800h		;point to text screen
	pop	es

	mov	bl, [bx+5dh]		;load
	cmp	bl, 20h			;is length zero? if so set carry
	jne	go
	mov	bl, 41h

go:
	pusha				;push the registers, including the
					;file name, on the stack

	int	10h			;set mode 0 (it's B/W but no one cares)

	xchg	bx, ax			;file name in AX
	mov	ah, LRed		;show it on the screen
	stosw				;set DI=0 (was FFFEh)
	stosw				;top-left corner

	xchg	si, ax			;set AX = 100h
	mov	ch, 20h			;turn off pesky blinking cursor
	int	10h

	mov	ax, 3d00h		;open file containing floor plan
	mov	dx, 0fff6h		;file name is on the stack

	push	ss			;here data segment = code/stack segment
	pop	ds
	int	21h

	xchg	bx, ax			;get handle in AX if a file was found
	jnc	load			;exit program if no more levels

quit:
	; if we get here from above, ax is a file handle which is < 256
	; if we get here because ESC has been pressed, ax = 0

	mov	al, 3			;restore 80-column text mode
	int	10h
	int	20h

Keys:	; This must be EXACTLY at 12eh (that's why XCHG BX, AX is above)
	db	-80, -2
	db	2, 0, 80

	; This is a nice place for Symbols, too.
Symbols:dw	FloorSym, DockSym, BlackSym, WallSym, BoxSym, BDSym, ManSym

end:
	mov	al, 7			;do a beep
	int	29h
	int	16h			;we know that AH = 0
	mov	sp, 0ffeeh		;clear undo stack
	popa				;get old values of registers back
	inc	bx			;form file name for next level
	jmp	short go

load:
	mov	ah, 3fh			;read 20xx bytes (CX) from file
	mov	dx, cx			;offset is also 20xx
	int	21h
	xchg	cx, ax			;number of bytes actually read in CX
	xchg	si, ax			;offset (was in DX=CX) in SI

	mov	ah, 3eh			;close the file
	int	21h


;convert symbols in file to more colorful characters on screen

	mov	di, (4*40+10)*2		;cursor to line 5, column 10

showloop:
	lodsb				;get a symbol
	cbw

	add	al, 60h			;is it >= space? If so, al is signed
	xchg	bx, ax			;(in the meanwhile put it in bp)
	jns	cr_lf			;no, at end of line

	shl	bx, 1			;reference a word
	SET_AX_FROM_BX_PLUS Symbols - Entry ;get a symbol
	MOV_DI_TO_BX_PLUS Last - 100h   ;map symbol to its last occurrence
	stosw				;write colorful character to screen

	db	32h			;transform next in xor al,[bp+di+14c7]
cr_lf:	add	di, byte 10*2		;move 20 pos. (10 with cr, 10 with lf)
	loop	showloop

	SET_SI_FROM_BX_PLUS LastMan - 6ah ;get initial position of man

	push	es			;here data segment = video segment
	pop	ds

playsoko:
	xor	bp, bp			;zero move counter

mainloop:
	mov	ax, bp			;display move counter
	mov	di, 39*2		;set cursor position
	mov	bx, 10
	mov	cx, Yellow * 256 + '0'	;attribute and ASCII delta (0E30h)
print:
	cwd
	idiv	bx
	or	dx, cx			;set attribute
	mov	[di], dx		;write digit
	dec	di
	dec	di
	or	ax, ax			;until we have a remainder of zero
	jnz	print
	stosw				;blank possible digit when undoing moves

;detect if level is finished (all boxes on docks, i.e. no 39h attributes)
;out of mainloop if no box is still on the floor. we start scanning at
;the move counter (pointed to by di).  pages we don't use are all set to
;2007h (white-on-black space).

;	mov	cx, 24*40		;not needed, cx is greater than this
	mov	al, DockAttr
	add	di, bx			;skip the move counter, where 39h might
					;be used as the character rather than
					;the attribute
	repne	scasb			;scan for an empty dock
	jcxz	end			;if not found, level has ended

					;gets here with ah = 0
	int	16h			;get command from keyboard
	shr	ax, 9			;work on the scan codes
	jz	quit			;esc (scan code 1) = exit program
	cmp	al, 14/2		;backspace (scan code 14) = undo last move
	ja	arrow			;other keys are considered to be arrows

	dec	bp			;has any move been done?
	js	playsoko		;if so, set BP=0 without undoing anything
	popa				;restore state for previous move
	mov	[bx+di], dx		;where box might have gone
	stosw				;restore old man location

; The old man position is always clear when undoing -- otherwise the
; man would have been over a box or a wall.  So the foreground color
; is always already set to light blue (floors have a light blue
; foreground color which is not seen).

showman:
	mov	[si], cl		;and finally the man
	jmp	short mainloop


arrow:					;parse arrow keys
	mov	bh, 1			;set bx = 10ah so that bx+36 is Keys
	cs xlatb			;why that `b' in `xlatb'?!?!?
	cbw

	xchg	bx, ax			;bx = delta to new man location
	lea	di, [bx+si]		;di = possible new man location
					;si = current man location

;check if a move is possible and if so do it

	mov	cx, [si]		;load man and its background
	mov	ax, [di]		;new man location
	mov	dx, [bx+di]		;where box might go
	pusha				;save state for this move

	inc	bp

	; CX contains 3902h (man on dock) or 7902h (man on floor)
	;
	; 		39h		79h		02h
	;	    CF	OF  SF	    CF	OF  SF	    CF	OF  SF
	;  00h	    Y   N   Y	    Y   N   Y	    Y   N   Y
	;  B0h	    N   Y   N	    N   Y   N	    N   N   Y
	;  FEh	    N   N   Y	    N   N   Y	    N   N   Y

	cmp	al, ch			;is new man location on wall?
	jo	mainloop		;jump if so -- can't move
					;is box being pushed?
	jb	movman			;jump if not

	cmp	dl, cl			;is new box location on floor or dock?
	ja	mainloop		;jump if not -- can't move

	mov	ah, XorAttr		;mask to move the box (AL is always a box)
	xor	[di], ax		;blank out old location
	xor	[bx+di], ax		;move box (keep background color)
movman:
	xor	[si], cl		;blank out old man location
	mov	si, di			;update man's location
	jmp	short showman		;go draw the face

Last	equ	0a0h
LastMan	equ	Last+12

