
; Soko-Ban game by Aphex for Hugi Compo #13
; Compile: tasm /m entry
;	   tlink /t/x entry

p286
model tiny
codeseg
startupcode

start:	
	mov	bp, 902h		; bp -> pointer
	rol	si, cl
	cmpsb				; test if cmd line :)
	lodsb
	mov	al, 41h			; al = default file name
	je	nocmd                   
	lodsb   			; al = input-ed file name
nocmd:
	mov	[bx], ax
getfile:
	mov	si, bx
	mov	ah, 6Ch			; open file fct
	cwd
	inc	dx			; dx = 1
	int	21h
	jc	exitsoko		; if error then exit

	xchg	bx, ax			; bx = file handle, ax = 0
	int	10h			; set video mode to 0

	xchg	cx, ax			; cx = stdin
	mov	ah, 46h			; redirect the file to stdin
	int	21h

	xchg	di, ax			; di -> left corner
	mov	dx, 0B800h
	mov	es, dx			; es -> video seg
	movsb				; write level name
	mov	ax, 20Ch		; ah = cursor fct, al = color
	stosb

	int	10h			; clear cursor
	dec	dx
	mov	di, 140h		; di -> video offset
nextline:
	add	di, 20
readmore:	
	mov	ah, 6         		; read fct
	int	21h
	mov	ah, 3Eh			; close file fct
	jz	levelok
	aad	50h
	add	ax, ax	
	cmp	al, 12
	ja	nextline
	jne	noman
	push	di
	db	0D6h			; salc (al = 0)
noman:
	add	al, low (offset convsym - 100h)
	xchg	si, ax			
	movsw				; put char on screen
	jmp	readmore

exitsoko:
					; ax is either 2 (file not found)
					; either 29 (Esc key aad-ed w/ 2)							
	mov	al, 3			; set video mode to 3
	int	10h
levelok:
	int	21h			; DOS call :)
	push	es			
	pop	ds
	pop	bx			; get man pos
	xor	sp, sp                  ; set stack for level

undo:
	or	sp, sp			; check if stack is empty
	je	displaymv
	pop	dx			; restore state
	pop	bx
	pop	si
moveit:
	xor	[bx], dx
	or	[si], dx
	pop	bx
displaymv:	
	or	[bx], bp		; draw man in new pos
	mov	di, 39*2		; upper-right corner
	mov	cl, 10
	xor	ax, ax
	sub	ax, sp
	shr	ax, 3			; ax = - sp / 8
mc10:	
	cwd
	idiv	cx
	or	dx, 0E30h
	mov	[di], dx
	dec	di
	dec 	di
	or	ax, ax
	jne	mc10				
	stosb
checkdock:
	test	byte ptr [di], 46h	; is it any free dock location?
	je	waitkey
	scasw				; next cell
	cmp	bp, di
	jnc	checkdock

	xchg	bx, ax			; set bx = 0

	mov	ax, 0E07h		; beep
	int	10h
	cbw				; wait key fct
	push	cs
	pop	ds
	inc	byte ptr [bx]		; set next file name

waitkey:
	int	16h
p386
	jc	getfile			; if level ready go to next
p286

	mov	dl, 0FEh		; dx = 0EFE
	xor	[bx], bp		; clear man position

	cmp	al, 8   		; check if backspace
	je	undo			; then undo move
	aad	2			; get extended key code * 2
	jns	exitsoko
	sub	al, 2*4Ch		; normalize al to -8, -2, 2, 8
	test	al, 2
	jne	stepready			
	imul	cl
stepready:		
	cbw				; ax = al
	xchg	di, ax                          
	push	bx
	add	bx, di
	push	bx
	lea	si, [bx + di]
	push	si
	mov	cl, [bx]
	xor	cl, dl			; check if move allowed
	jnp	move			; if yes display man
	cmp	[si], cl                ; check cl = [di] = 0 
					; (cl can be either 0, either 4E)
	je	pushbox			; if yes then push box
	sub	bx, di
move:
	cwd
pushbox:
	push	dx			; move mask
	push	bx			; dummy, just to be popped after move
	jmp	moveit
convsym:
	dw	7000h, 3000h, 0720h, 47B0h, 7EFEh, 3EFEh
		; floor: attr 7x, cell 20 | 00
		; dock:	 attr 3x, cell 20 | 00
		; wall:  attr 47, cell B0
		; bkgr:  attr 0x, cell 20 | 00
		; box:   attr xE, cell FE
		; man:	 attr x9, cell 02
end start