	page	240, 132
;ENTRY.ASM	17-DEC-00
;Entry for the Hugi Size Coding Compo #13 -- The Soko-Ban Game.
; by Boreal
;
;"Soko ban" is Japanese for "warehouse man". Use the arrow keys to move
; the man and push the yellow boxes onto the light blue loading docks. Only
; one box can be pushed at a time.
;
;Start by typing "entry a" at the DOS prompt. "a" is the starting level.
; You can start at any level a-z or 0-9. If a level is not specified (such
; as when running from Windows) then "a" is used. When a level is completed,
; the next level (b) loads automatically.
; 
;If you make a mistake, such as pushing a box into a corner, you can undo
; moves with the Backspace key. The Esc key terminates the program.
;
;					Ŀ
;Assemble with:				 0 0 
; tasm /m entry				\___/
; tlink /t entry			
;					Soko Ban
;Register usage
; ax = scratch
; bx = file handle, move offset (+/-2 or +/-80)
; cx = 00FFh, 000Ah, also = 1 = number of bytes to read in
; dx = pointer to file name and buffer, remainder
; si = pointer to man's location on screen
; di = pointer to text screen, possible new man location
; bp = move counter

	.386
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg
;also assume ah=0, bx=0, cx=00FFh, df=0

	org	100h
Start:	push	0B800h			;point to text screen
	pop	es

;	mov	al, ds:[5Dh]		;get file name from command line, if any
;	cmp	al, 'A'			;set carry flag if no file name entered
;	adc	al, 1Fh			;convert space to A; A-Z to lowercase
;	mov	[bx], ax		;set up ASCIIZ string at 0000h (ah=0)
;***
	mov	al, ds:[5Dh]		;get file name from command line
	cmp	al, 20h			;was there one?
	jne	GotName			;jump if so
	mov	al, 'A'			;else use default file name
;(ah=0, bx=0)
GotName:dec	ax
	mov	[bx], ax		;set up ASCIIZ string at 0000h

GameLoop:
	push	cs			;restore ds
	pop	ds

;Zero all registers
Game10:	push	0			;cx=00FFh first time; =000Ah afterwards
	loop	Game10			; (stack will never overflow into code)
	popa				; (65536 - 4000*16 = 1536)
	pop	sp			;initialize 'undo' stack; sp:= 0
;(di=0)
	inc	byte ptr [di]		;form next file name for next level
;(al=0, dx=0)
	mov	ah, 3Dh			;open input file containing floor plan
	int	21h			;dx = 0 = pointer to file name
	jc	Exit			;exit program if no more levels
	xchg	bx, ax			;save file handle in bx
;(ax=0)
	int	10h			;set 40-column text mode (clear counter)

;Display file name (= current level) in upper-left corner in light red
;(si=di=0)
	lodsb				;get file name; al <- ds:[si++]
	mov	ah, 0Ch			;light red
	stosw				;write file name; es:[di++] <- ax

;Convert characters in the input file to more colorful characters on screen
;(bx=handle, cx=0)
	mov	di, (4*40+10)*2 -20	;cursor to line 4, column 10 (start @ 0)
	inc	cx			;number of bytes to read in = 1
HalfLine:
	add	di, 20			;move to start of next line, from col 30
ReadLoop:
	mov	ah, 3Fh			;read a character from file (bx=handle)
	push	22h			;clear high byte, bkgnd char 4 last pass
	or	dx, sp			;point to "buffer"; dx:=-2, af:=0
	int	21h
	xchg	cx, ax			;see if 1 or 0 bytes were actually read
	pop	ax			;get symbol (=22h if none read in)
;(af=0)
	aaa				;al:= al & 0Fh
	jc	HalfLine		;jump if CR (0Dh) of LF (0Ah)
;(ah=0)
	add	al, (CharTbl-Start-100h)/2	; = (offset CharTbl) / 2
	shl	ax, 1			;double to index words
	xchg	si, ax			;move colorful character to screen
	movsw				;es:[di++] <- ds:[si++]
	inc	cx			;test for end of file; flags:=02h
	loop	ReadLoop

;flags=02h, bh=0, dx=-2, bp=0, si=CharTbl+4 (< 1A2h, the top-most man location)
	lahf				;ah:= 02h
	push	es			;point ds to text screen
	pop	ds

Read20:	inc	si			;set si to point to man (02h)
	cmp	[si], ah
	jne	Read20

;(ah=02, bh=0, dx=-2, bx=handle)
	mov	ch, 3Eh			;close file handle in bx
Int1021:int	10h			;set cursor off screen to hide it
	xchg	ax, cx
	int	21h

Undo:	test	sp, sp			;skip if nothing to undo
	je	Undo90			;(don't blow the stack)
	popa				;restore state
	mov	[bx+di], cx		;restore loc where box might have gone
	stosw				;restore location where man was
Undo80:	mov	[si], dl		;restore man (02h) colors are already ok
Undo90:

;Display move counter
ShowCnt:mov	ax, bp			;get move count
	mov	di, 39*2		;set cursor to upper-right corner
	mov	cx, 10			;set up divisor
sc10:	cwd				;dx:=0
	div	cx
	add	dx, 0E30h		;convert to ASCII and add yellow color
	mov	[di], dx		;write digit to screen
	dec	di			;move left to next higher digit posn.
	dec	di
	test	ax, ax			;(don't display leading zeros)
	jne	sc10
;(ax=0)
	stosw				;blank possible digit when undoing moves
;***
;	mov	dx, 0FA02h		;dl = 02 = man; dh = FA; used later

;Detect if level is finished
;Empty docks have attribute 39h (man passed thru)
;Full docks have attribute 3Eh (yellow box on cyan background)
fin10:	inc	di			;point to attribute byte
	cmp	byte ptr [di], 39h	;is it an empty dock (blue on cyan)?
	je	GetKey			;jump if so--level is not solved
	inc	di			;else check next character cell
	jns	fin10			;test all of video ram up thru 7FFFh

	mov	al, 07h			;beep speaker; al:=bell
	int	29h
;(zf=0)
GetKey:
;(ah=0, zf=1)
	int	16h			;get command from keyboard
	jne	GameLoop		;loop if level was finished (solved)
	sahf				;test scan codes with flag bits
	jz	ml05			;jump if arrow keys
	jp	Undo			;jump if Backspace, else must be Esc
Exit:	mov	ax, 0003h		;restore 80-column text mode
;(ch=0)
	jmp	Int1021			;exit program

	align	2			;CharTbl must be < 1A4h and be even
CharTbl	db	 00h, 79h		;space	floor
	db	 00h, 39h		; !	loading dock (man passed thru)
	db	 00h, 00h		; "	background
	db	0B0h, 47h		; #	wall
	db	0FEh, 7Eh		; $	box on floor
	db	0FEh, 3Eh		; %	box on loading dock
	db	 02h, 79h		; &	man on floor

;Arrow keys = direction to move man
;(al=0)
ml05:					;left & right key's LSB=1
	jc	ml10			;     up    left  right down
	 mov	al, 18			;ah = 48h   4Bh   4Dh   50h
ml10:	sub	ax, 4BFEh		;ah = -4    -1     1     4
	imul	ah			;ax =-80    -2     2    80

	xchg	bx, ax			;bx:= ax
	lea	di, [bx+si]		;di:= si + ax
; si = current man location
; bx = move offset (+/-2 or +/-80)
; di = possible new man location
; bx+di = possible new box location

;***
	mov	dx, 0FA02h		;dl = 02 = man; dh = FA; used later
;(dx=FA02h)
;Save current state for Undo command
	mov	ax, [di]		;save contents at new man location
	mov	cx, [bx+di]		;save contents where box might go
	pusha				;save loc of man, new loc of man & box
					; also save move counter
	inc	bp			;count move

;Make actual move on the screen
	sahf				;ah can = dock ?9h, wall 47h, or box ?Eh
	jnp	MoveMan			;jump if dock or floor (?9h)
	jc	ShowCnt			;jump if wall (47h)
;(al=FEh)				;else al = box (FEh)
	and	al, cl			;get new box loc; mov al, cl with status
	js	ShowCnt			;jump if box (FEh) or wall (B0h)
	sub	[bx+di], dx		;convert floor to box & keep background
	add	[di], dx		;convert box to floor & keep background
MoveMan:
;(al=0)
	xchg	si, di			;update man's location
	stosb				;blank out old man location with 00h
	jmp	Undo80			;go store man (02h) into [si]

cseg	ends
	end	Start
