	page	240, 132
;ENTRY.ASM	28-SEP-00
; by Boreal
;Display the Nth prime number.
; N is entered on the command line and is in the range 0..1000000.
;
;Assemble with:
; tasm /m entry
; tlink /t entry

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg
;also assume ax=0, cx=00FFh, [0000]=20CDh, df=0

	org	100h
start:
st10:	push	ax			;zero all the (extended) registers
	loop	st10			; especially eax, ecx, edx & ebp
	popad

;Read number (N) from command line and convert it to binary in ecx
	mov	si, 81h			;point to first char on command line
gn10:	imul	ecx, 10			; (leading space chars aren't a problem)
	add	ecx, eax
	inc	ax			;clear af
	lodsb				;get character; al:= ds:[si++]
	aaa				;al:= al&0Fh; if al>9 then cf:=1
	jnc	gn10			;loop until carriage return

;Register usage:
; eax = number to test for primeness
;  bx =
; ecx = count down of primes found so far
; edx = remainder, high word always = 0
;  si =
;  di =
; ebp = divisor, high word always = 0

	pop	ax			;eax:= 0
	jecxz	dn00			;if ecx = 0 then go display eax = 0

	inc	ax			;eax:= 1
;dx=0 initially
pr10:	inc	bp			;divisor = 2, 3, 5, 7, 9...
	or	bp, 1
	dec	dx			;rem < divisor < sqrt(16M) = 4000 < 2^15
	jns	pr30			;jump if rem was not 0 (possible prime)
pr20:	 inc	eax			;get next number to test for primeness
	 mov	bp, 2			;initialize divisor at 2
pr30:	xor	dx, dx			;(high word always = 0)
	push	eax			;number / divisor
	div	ebp
	cmp	eax, ebp
	pop	eax
	jae	pr10			;if quotient < divisor then have prime
	loopd	pr20			;loop until desired prime is found

;Display decimal number in eax with leading zeros followed by CR, LF
dn00:	mov	cl, 10			;display 10 digits
	mov	bp, cx			;divisor = 10
	push	bp			;LF = 10
	push	0Dh			;CR

dn10:	cdq
	div	ebp			;divide by 10
	or	dl, 30h			;convert to ASCII (flags = 06h)
	push	dx			;save on stack
	loop	dn10

	lahf				;ah:= 6 = direct console I/O function
dn20:	pop	dx			;get character
	int	21h			;output it
	dec	dx			;loop until 0
	jns	dn20
	ret				;return to location 0 (= int 20h)

cseg	ends
	end	start
