
	
;  Prime my pump, but it goes backwards...       ;
;             -- Blaine                          ;
;               "The Dark Tower" by Stephen King ;
	


	; ----========----========---- ;
	 ;                                     ;
	 ; Johnny L. Fencey's entry for HC #12 ;
	 ;                                     ;
	 ;       the prime number finder       ;
	 ;                                     ;
	; ----========----========---- ;


	
;  There are fifty ways to leave your lover...   ;
;             -- Simon and Garfunkel             ;
;                                                ;
	

	; ----========----========---- ;
	 ;                                     ;
	 ;       contacting the author         ;
	 ;                                     ;
	 ;               e-mail:               ;
	 ;     JeLlyFish.software@gmx.net      ;
	 ;                                     ;
	 ;             cell-phone:             ;
	 ;          +49-179-297 86 40          ;
	 ;                                     ;
	 ;             snail-mail:             ;
	 ;           Vinzent Hfler            ;
	 ;        Struppener Strae 27         ;
	 ;          D-01259 Dresden            ;
	 ;                                     ; 
	; ----========----========---- ;

; $Id: entry.asm 1.12 2000/09/20 16:49:31 JohnnyL.Fencey Exp $ ;

; $Log: entry.asm $
; Revision 1.12  2000/09/20 16:49:31  JohnnyL.Fencey
; Fixed typo. (DB 0D, 0Ah, '$' should have been read DB 0Dh, 0Ah, '$')
; Thanks, Adok.
;
; Revision 1.11  2000/09/19 07:27:54  JohnnyL.Fencey
; changed output code a little bit more, this saved two bytes, so current
; version is 106 bytes. Mmh.
;
; Revision 1.10  2000/09/18 21:17:04  JohnnyL.Fencey
; Totally revised the ouput-code saving six bytes. Down to 108 bytes.
; Still nine bytes to go to reach the personal target. Seems I'm running
; out of time...
;
; Revision 1.9  2000/09/07 11:34:09  JohnnyL.Fencey
; Saved one byte again. (lea r32, [mem16] / move r16, r16 is shorter than
; mov r16, imm16 / movzx r32, r8). Down to 114 bytes.
;
; Revision 1.8  2000/09/07 10:37:29  JohnnyL.Fencey
; Revised the command line loop.
; This save a jump, so I'm down... to 115 bytes. ;)
;
; Revision 1.7  2000/09/06 19:35:31  JohnnyL.Fencey
; Saved the mega amount of three bytes. 117 bytes. Still far too big.
; I really want to get below 100 bytes.
;
; Revision 1.6  2000/09/06 11:07:47  JohnnyL.Fencey
; Changed some comments, added some stupid fortunes.
;
; Revision 1.5  2000/09/06 07:50:11  JohnnyL.Fencey
; Couldn't sleep this night. The result is a working 120 byte version.
; Seems there's a lot of code to tweak...
;
; Revision 1.4  2000/09/05 17:02:07  JohnnyL.Fencey
; Gone to have some coffee...
; Just saved the file to have a backup.
; Nothings works yet. And it's faaar too biiig.
;
; Revision 1.3  2000/09/04 20:52:16  JohnnyL.Fencey
; Added _salc macro with IFDEFs (1 vs. 6 bytes)
; Added some "soon to be changed" debug code
;
; Revision 1.2  2000/09/04 12:25:32  JohnnyL.Fencey
; Changed position of logging, added author info
; and "niced up" the source file a little bit
;
; Revision 1.1  2000/09/04 10:11:59  JohnnyL.Fencey
; Initial revision

;-----------------------------------------------------------------------;
; with the right tools this code should assemble and link perfectly :-) ;
;                                                                       ;
; Try this:                                                             ;
;                                                                       ;
; TASM /ml /jIDEAL /w2 entry.asm                                        ;
; TLINK /t entry.obj                                                    ;
;-----------------------------------------------------------------------;

;========================;
; compilation directives ;
;========================;

USE_UNDOCUMENTED_OPCODES = 1
; DEBUG = 1

;========================================;
; some fu**ing macros...                 ;
; not intented for learning purposes :-) ;
;========================================;

;-------------------------------------------------;
; SALC, SETALC, whatchamacallit                   ;
; simply copies the carry bit to all 8 bits of AL ;
;-------------------------------------------------;

MACRO _salc
	IFDEF USE_UNDOCUMENTED_OPCODES
		DB 0D6h
	ELSE
		pushf
		mov     al, 0
		sbb     al, 0
		popf
	ENDIF
ENDM _salc

;----------------------------------------------;
; moves a constant value to a 32 bit register, ;
; using a minimum number of bytes (3...6)      ;
;----------------------------------------------;

MACRO Mov32 Reg32, Value
	IF (Value LT 256)
		xor     Reg32, Reg32

		IFIDNI <Reg32>, <eax>
			rb EQU al
			rw EQU ax
		ELSE
			IFIDNI <Reg32>, <ebx>
				rb EQU bl
				rw EQU bx
			ELSE
				IFIDNI <Reg32>, <ecx>
					rb EQU cl
					rw EQU cx
				ELSE
					IFIDNI <Reg32>, <edx>
						rb EQU dl
						rw EQU dx
					ELSE
						ERROR
					ENDIF
				ENDIF
			ENDIF
		ENDIF

		IF (Value EQ 1)
			inc     rw
		ELSEIF (Value NE 0)
			mov     rb, Value
		ENDIF
	ELSE
		mov     Reg32, Value
	ENDIF
ENDM Mov32

	
;  Carson's consolation:                         ;
;      Nothing is ever a complete failure.       ;
;      It can always be used as a bad example.   ;
	

MODEL TINY
P586N

CODESEG

	STARTUPCODE

;---DEBUG---v---

IFDEF DEBUG
	mov     si, 0100h
	mov     bp, 0900h
	mov     cx, 00FFh       ; register setup
ENDIF

;---DEBUG---^---

;/===                                     ===\;
; first convert the given command line number ;
; to a 32-bit value returned in EBX           ;
;\===                                     ===/;

	Mov32   eax, 0
	Mov32   ebx, 0

	shr     si, 1   ; because si= 0100h at startup, this
			; is equivalent to "mov si, 80h"
			; pointing SI to there means a command line with a
			; length of exactly 13 chars is interpreted as empty
			; but as this can't be considered valid input... ;-)
	; mov     si, 81h         ; first char of command line (which is
				; either white-space or a terminating 0Dh)
@@strloop:
	sub     al, '0'
	jb      SHORT @@ignore

	imul    ebx, ebx, 10d
	add     ebx, eax
@@ignore:
	lods    [BYTE si]
	cmp     al, 13d
	jne     SHORT @@strloop

@@gotit:
	_salc                   ; clear AL (carry=0)

	dec     ebx
	js      SHORT @@printout        ; empty commandline or 0 as parameter

;/===                                  ===\;
; now calculate the requested prime number ;
;\===                                  ===/;

	mov     di, bp                  ; bp= OFFSET PrimeTable

	Mov32   ecx, 2
@@prime:
	mov     eax, ecx
	test    di, di
	js      SHORT @@dontsave        ; don't write new prime if DI gets
					; larger than 8000h
	stos    [DWORD es:di]
@@dontsave:
	dec     ebx
	js      SHORT @@printout        ; ebx is already one less,
					; so test for SF, not ZF
@@restart:
	mov     si, bp
	inc     ecx
@@nextone:
	mov     eax, ecx

	cdq
	div     [DWORD si]
	cmp     [si], eax       ; IMO "cmp edx, eax" doesn't make much sense
				; but fact is: It works, too.
	lods    [DWORD si]      ; "add si, 4"
	jg      SHORT @@prime   ; must be "jge" if "cmp edx, eax" is used 

	test    dx, dx          ; remainder must be 16-bit, so a test for
	jnz     @@nextone       ; DX=0 is sufficient
	jmp     @@restart

;/===                                            ===\;
; convert it back to decimal string and print it out ;
;\===                                            ===/;

LABEL TenZero BYTE                      ; here the output is written backwards
	DB 0Dh, 0Ah, '$'                ; as code: "or ax, 240Ah", but this label
					; is never reached in codestream

@@printout:
	mov     di, OFFSET TenZero
	lea     ebx, [bx+11d]           ; ebx= (-1)+11d= 10d (div. by ten)
	mov     cx, bx                  ; cx= bx= 10 (ten zeroes)
@@next:
	cdq
	div     ebx
	dec     di
	add     dl, '0'
	mov     [di], dl
	loop    @@next
	
	mov     dx, di                  ; restore offset
	mov     ah, 9
	int     21h

	ret

END

			--- LAST WORDS ---


Don't get suckered in by the comments -- they can be terribly misleading.
Debug only code.

	-- Dave Storer


The code I write is self-explaining. So why bother commenting it?

	-- Johnny L. Fencey


Real programmers don't comment their code.
It was hard to write, it should be hard to understand.

	-- unknown


>Die Absicht hinter C war es, eine allgemeingueltige Maschinenspra-
>che zu erschaffen, nicht jedoch eine idiotensichere.

Mir war, als wollte man mit C eine hhere Programmiersprache schaffen.
So kann man sich tuschen. Danke fr die Aufklrung.

	-- L. Donnerhacke vs. H. Bonfigt in de.org.ccc, 2000/02/16 07:57 GMT

			--- THE - END ---
