; TinyPrime by Picard
; 78bytes "stable" version
; for Hugi Size Coding Competition 12  
; (works on win2k too, not cmdline dependent)

.MODEL TINY
.386
.CODE
.STARTUP

;assumed:
; bx = 00xx
; cx = 00xx
; si = 0100
; [0002] = <0
; [0000] = 20CD
; [FFFE] = 0000              
                  
;no 32bit instructions 
;-prime,-remainder table is after sp

	db      -13+'9',-10+'9'            ;newline characters
	mov	cl,10
Init:	dec	si                         ;init ascii out counter 
	mov	byte ptr [si],9
 	loop	Init
	pop	ax                         ;add sp,2

Count:  mov     bl,128                     ;decrement ascii cmdline
        add     bl,[bx]                    ;last charater in cmdline
Next:   mov     al,[bx]                    ;ascii dec
        dec     ax
        aas
        mov     [bx],al
        dec     bl
	jo      short Print                ;exit when [80h] decremented 
        jc      short Next
	cmp	bx,si                      ;if cmdline -> dec output too
        mov	bl,255                     ;output's last digit
	jl      short Next

        dec	cx                         ;16bit counter  
        mov     di,sp                      ;begining of table
        cwd                                ;clear dx (0 or -1)
UpdRem: inc     word ptr [di]              ;decrement -remainder
        jl      short UpdOk                ;if >= 0 -> remainder overflow
        mov     dx,[di+2]                  ;reset remainder to -prime
        mov     [di],dx                    ;(by the way set dx)
UpdOk:  add     di,4                       ;next item
        js      short UpdRem            

        inc     dx                         ;if dx>0 -> not a prime
        jl      short Next

        cmp     sp,10000h-546*4            ;let's limit our table to 546 items
        je      short Count
        push    cx                         ;add new -prime with initial -remainder
        push    cx                         ;(16bit is enough for 546. prime)
        jmp     short Count

PLoop:  xchg	ax,dx                      
	mov	ah,2        
	int	21h          
Print:  lodsb                              ;print -output digits
	neg	ax                         
	add	al,'9'
	jns	short PLoop                ;exit when we reach 'mov cl,10'
	int	20h                        ;can't use ret ([sp]<>0)
end               
