    ; Prime Number Finder by Roland Neul (Roland.Neul@post.rwth-aachen.de)
    ; Algorithm is roughly the same as found in the example
    ; Current size: 85
    ; Assemble: nasm -oentry.com entry.asm

    org 0x100

; Register assumptions: AX=0, BX=0, SI=0x0100, DI=0xFFFE
;                       BP=0x09??, [SP]=0x0000

; Get count from command line
; Size: 21 Bytes
; Assumes: AX=0, BX=0, SI=0x0100, DI=0xFFFE
; Sets: EAX=0, BX=0xFF07, ECX=count, SI=0x008?, DI=0
GetCount:
    cwde
    xor ecx,ecx
    cmpsw          ; DI=0, SI=0x0102
    shr si,1       ; SI=0x0081
.loop:
    imul ecx, BYTE 0x0A
    add ecx,eax
    lodsb
    sahf           ; clear auxiliary flag
    aas            ; al=al & 0x0F; if al > 9: ah--, al-=6, set carry
    jnc .loop
    xchg ax,bx     ; BX=0xFF07

; Get the count-th prime
; Size: 37 Bytes
; Assumes: EAX=0, ECX=count, DI=0, BP=0x09??
; Sets: EAX=prime, ECX=0, EDX=?, SI=?, DI=?
GetPrime:
    a32
    jcxz Convert
.next:
    inc eax        ; will always clear sign flag
    mov si,bp      ; see [1]
    mov [bp+di],eax
.loop:
    js .next       ; needs to be at the top because of the magic '2'
    cdq
    div DWORD [si]
    cmp eax,[si]   ; sets carry flag if divisor > sqrt(dividend)
    dec dx         ; sets sign flag if remainder=0 (see [2])
    lodsd
    mov eax,[bp+di]
    jnc .loop
    test di,di     ; see [1]
    js .nostore
    scasd
.nostore:
    a32
    loop .next

; Write prime followed by <CR><LF> to stdout and quit
; Size: 27 Bytes
; Assumes: EAX=prime, BX=0xFF07, ECX=0, [SP]=0x0000
Convert:
    mov cl,0x0A
    push cx
    mov dl,0x0D
.divloop:
    push WORD .outlp
    push dx
    cdq
    div ecx
    sub dl,0xD0
    adc bl,cl           ; 7 + 11 * (10 + 1) = 128 = 0x80
    jns .divloop
    mov ah,0x02
.outlp:
    pop dx
    int 0x21
    ret


; [1] - sqrt(15,485,863)=3935.2; the next prime is 3943 which is
;       the 547th. That means, we have to store at least 547
;       primes. Waiting until di becomes negative means we store
;       8192 (or less) primes and the current number. That's far
;       more than needed, but who cares. The point is, the current
;       number is stored between 0x09?? and 0x89??, which is safe.
; [2] - The maximum divisor is 3943 so the remainder has to be in
;       the range 0-3942. This means the sign flag will only be
;       set if the remainder was 0. "dec" does not affect the carry
;       flag.

