;
;     gyy   ygg ggy   gyg gygxcxggy cxsyggsxc
;     $$$   $$$ $$$   $$$ $$$   $$$    $$$
;   ;:$$$scx$$$:$$$:::$$$:$$$:cxgyg::::$$$:::;
;     $$$   $$$ $$$   $$$ $$$   $$$    $$$
;     SBS   SSB BBScxsSBS BSBsxcSSB xcsBSBsxc
;
;                 Compo #12 Entry
;
;   by Joergen Ibsen / Jibz <jibz@hotmail.com>
;

.model tiny
.586
.code
org 100h

start:
        ; get value from command line into ecx using fcb
        mov     si, 5dh                 ; first argument as fcb

        xor     ecx, ecx                ; ecx = 0
        xor     eax, eax                ; eax = 0

get_n:
        imul    ecx, 10
        add     ecx, eax

        lodsb                           ;
        sub     al, '0'                 ; high part of eax is still 0
        jns     get_n

        xchg    ax, bx                  ; eax = 0, since bx = 0

        mov     di, bp                  ; di -> table

        jecxz   print_result

        inc     ax                      ; eax = 1

find_next_prime:
        inc     eax                     ; eax = next number to test

        mov     si, bp                  ; si -> table

check_if_prime:
        cmp     si, di                  ; have we checked all primes?
        jae     is_prime

        movzx   ebx, word ptr [si]      ; get prime from table

        push    eax

        cdq
        div     ebx                     ; check if it divides eax

        lodsw                           ; si = si + 2

end_string:
        db      0dh, 0ah, '$'           ; newline and '$' for printing,
                                        ; translates to OR AX,240A

        pop     eax

        test    dx, dx                  ; dx = remainder < 4000
        jz      find_next_prime

        jmp     check_if_prime

is_prime:
        cmp     bh, 10h                 ; check if table is full
        jae     p_table_full

        stosw                           ; add prime to table

p_table_full:
        loopd   find_next_prime

print_result:
        mov     cl, 10                  ; ecx = 10
        mov     ebx, ecx                ; ebx = 10

        lea     di, end_string          ; di -> newline in string

get_next:
        cdq                             ; edx = 0
        div     ebx                     ; get reminder

        add     dl, '0'
        dec     di
        mov     [di], dl                ; add number to string

        loop    get_next

        mov     dx, di                  ; dx -> string start

        xchg    ax, bp                  ; ah = 09h
        int     21h                     ; print string
        ret                             ; exit

end start
