comment -Ŀ
	     entry for HUGI size coding competition #12         
  
  
         
              Prime Number Finder               
          
  
   history:
    2000/09/1x: several prime finders, but all too large or
                too slow ... and all at least 50+6 bytes
    2000/09/20: first working version, 88 bytes; runs in 230
                seconds on my P200MMX, which is fast enough
    2000/09/20: 87, 85, 83, 82
    2000/09/21: 81. oops, all above versions contained a bug.
    2000/09/21: 82, 81, 80
    2000/09/22: 79, 78 (too slow), 79
    2000/09/26: added some more comments
    2000/09/27: 78, 77, too slow again (94.5 seconds), 78
  
-
.model tiny
.486
.code
	ZPONE   = 0    ; 0th prime = 1 instead of 0, saves 2 bytes
	SLOW    = 0
.startup
; assumes:
; - command line consists only of spaces, followed by digits, followed
;   by 0Dh (no trailing spaces), thus
;   ax == 0000h (no invalid drive letter can occur)
;   bx == 0000h
; - si == 0100h
; - sp == FFFEh
; - bp == 09xxh
; - command line is no longer than 15 characters, including spaces
; - the number given is <= 1000000
s:
@add:   cwde                    ; high(eax) = 0
	or      word ptr [di],240Ah
	imul    ecx,ecx,10
	add     ecx,eax
	inc     bl
	jge     @add
; the above loop does this:
; - the first time it's executed: set bx = 0081h, ecx = 0
; - after the first time: inc bx, ecx = 10*ecx+eax
; - clear af ("inc bl" does that, as long as 80h<bl<90h;
;   this is why "command line length <= 15" is needed)
	mov     al,[bx]         ; get one digit
	aaa                     ; space -> 0, digit -> digit value, 0Dh -> cf
	jnc     @add

	lodsw                   ; ax = 9866h
@init:  push    ax              ; init data array, build it on the stack
	dec     ax
	dec     ax
	jnz     @init           ; sp = 679Ah

IF      ZPONE
	inc     ecx             ; 0th prime == 1
; note: the "obvious" optimization of replacing the loopd below by dec ecx, jns
; will not work because the value of ecx is needed in the output routine
ELSE
	jecxz   @print          ; handle ecx == 0
	inc     ax              ; eax = 1
ENDIF

@next:  inc     eax             ; check next number
	pop     dx              ; dx = 2
	mov     di,sp           ; di = data = ???
	push    dx              ; (below: i == (di-???)/2)
@test:  cmp     [di],ax         ; test n < eax, where n  data[i] (mod 65536)
	jns     @skip           ; such that n is as near to eax as possible
	add     [di],dx         ; if yes, advance to next multiple of i+
@skip:  inc     dx              ; dx = i+3
	scasw                   ; data[i++] == ax? (does i+2 divide eax?)
	je      @next           ; yes -> no prime, check next number
IF      SLOW
	cmp     bp,di
ELSE
	cmp     dh,10h
ENDIF
	js      @test           ; check up to 10??h
	loopd   @next           ; search ecx-th prime

@print: push    cx              ; terminate program, but first ...
	push    5               ; call 5, but first create string
@prtl:  mov     cl,10           ; ecx = 10
	cdq                     ; edx = 0
	idiv    ecx
	add     dl,30h          ; calculate digit
	mov     [si],dl         ; put digit in string
	dec     si              ; point si to next character
	dec     bx
	loopne  @prtl           ; do 8?h chars; set cl=9
	mov     dl,-7           ; let dx point to string
	ret
end
