; Hugi size coding compo #12 entry, rev.04
; Nth prime number finder
; Copyright 2000 by gbm <gbm@ii.pw.edu.pl>
	.model	tiny
	.386
	.code
	org	100h
	;EAX = xxxx****
	;AL = 00 if first FCB has valid drive letter,  FF if not
	;AH = 00 if second FCB has valid drive letter, FF if not
	;EBX = xxxx0000
	;ECX = xxxx00FF
	;EDX = xxxxxxxx
	;ESI = xxxx0100
	;EDI = xxxxFFFE
	;EBP = xxxx09xx
	;ESP = xxxxFFFE
	;EIP = xxxx0100

start:
	cwde
	xor	ecx, ecx
	mov	si, 5dh

argchar:
	imul	ecx, 10
	add	ecx, eax
	lodsb
	sub	al,'0'
	jae	short argchar

	; eax = 000000xx, ecx = N, esi = 0xx
	xchg	ax, bx	; eax = 0
	jecxz	gotit
	mov	di, bp
	inc	ax
	inc	ax

isprime:
	or	di, di
	js	short ispr2
	stosd
ispr2:
	loopd	next_candidate

	; eax = prime, ecx = 0, edx = 0000xxxx
gotit:
	mov	cl, 10	; ecx = 10
	push	cx
	mov	ebx, ecx	; ebx = 10
	push	13

pushdigit:
	cdq
	div	ebx
	add	dl, '0'
	push	dx
	loop	pushdigit

	mov	ah, 6

shnext:
	pop	dx
	int	21h
	cmp	al, 10
	jne	short shnext
	ret


next_candidate:
	inc	eax
	mov	si, bp
	; check if eax is prime
chk_next_div:
	cdq
	push	eax
	div	dword ptr [si]		; edx = 00000xxx
	cmp	dword ptr [si], eax
	lodsd
	pop	eax
	ja	short isprime
	dec	dx
	jns	short chk_next_div
	jmp	short next_candidate

	end	start
