; Hugi Compo #12
; Prime number finder
; by Fred, frederic_perriot@hotmail.com
; assemble with nasm -o entry.com prime.asm

; Thanks to all compo coders for making it fun
; Perl! Porsche! chocolate! SoftIce!

org 100h
        push    bx                      ; put null dword at FFFCh
        mov     di, sp                  ; di = FFFCh
        db      0Dh, 0Ah, '$'           ; or ax,240Ah
        mul     dword [di]              ; edx = eax = 0
read:
        imul    ecx, [di]               ; reset ecx at first pass, then *10
        mov     byte [di], 10
        add     ecx, eax                ; accumulate digit
        inc     si                      ; reset auxiliary carry
        mov     al, [si-80h]            ; read digit
        aaa                             ; carry iff end of line (0Dh)
        jnc     read
        xchg    bx, ax                  ; ax = 0, bx = 103h
        db      67h                     ; nasm bug. the version of nasm that
                                        ; I am using codes loop on ecx
                                        ; correctly with a 67h prefix, but
                                        ; wrongly codes jecxz with a 66h
                                        ; prefix
        jcxz    output                  ; 0 or empty line -> output eax = 0
        inc     ax

; For each candidate sieve by all primes recorded plus 10, which is OK
; because 10 is not prime
; Sieve from smaller to larger prime, for speed. +2bytes :(

next_cand:
        inc     eax                     ; candidate = 2, 3, 4, 5...
        mov     si, di                  ; si = FFFCh
sieve:
        pushad
        div     dword [si]              ; remainder fits in dx
        dec     dx
        popad
        js      next_cand               ; divisible => next candidate
        add     si, di                  ; si -= 4
        cmp     si, sp                  ; sieve downto sp
        jae     sieve
        test    sp, [bx]                ; stop stacking primes at F5F0h
                                        ; with prime 4787
        jz      dont_record
        push    eax
dont_record:                            
        loop    next_cand, ecx

; Write result to 102h, 101h, 100h, FFh,... with a big left zero-padding :)

output:
        db      0B1h            ; mov cl,imm8        
cdig:
        pop     ax              ; 58h
        div     dword [di]      ; still dword 10 at di
        push    ax
        xchg    dx, ax
        cwd
        or      ax, 930h        ; prepare ah=9 for output
        dec     bx
        mov     [bx], al
        loop    cdig

        mov     dl, 0F9h        ; output 10 digits
        int     21h
        ret                     ; last ax pushed was 0
