; assemble with
; nasm -fbin -oentry.com entry.asm

segment .text
bits 16
org 100h

;--------------------------------- FIXES SECTION START -----------

; Using A32 instead of `db 067h' doesn't work (jumps a byte after
; what we need)
%macro LOOPD 1
	db	067h
	LOOP	%1
%endm

%macro JECXZ 1
	db	067h
	JCXZ	%1
%endm

;--------------------------------- FIXES SECTION END --------------

; Change 0-->1 to debug the program
%if 0
	MOV	BP, 900h
	XOR	AX, AX
	XOR	BX, BX
	MOV	CX, 0FFh
	MOV	DX, 1703h
	MOV	SI, 100h
	MOV	DI, SP
%endif

base	EQU	300h		   ; Start...
end	EQU	base+1200	   ; and end of table

@push0:	PUSH	BX		   ; Thanks to claw for this!
	LOOP	@push0		   ; 255 times -- more than enough
	POPAD			   ; Clear all 32 bit registers

	MOV	SI, 5Dh		   ; SI points to first FCB
	MOV	BL, 10		   ; Radix, used throughout

@get:	IMUL	ECX, EBX
	ADD	ECX, EAX	   ; Sum last digit
	LODSB			   ; Get next digit
	SUB	AL, 30h		   ; Subtract excess
	JAE	@get		   ; Loop if a digit

	XCHG	AX, BP		   ; Zero out AX
	JECXZ	@print		   ; If ECX=0 print zero

	MOV	DI, base	   ; Ptr. to current end
	INC	AX		   ; 1 = first prime-1

@next:	MOV	SI, base	   ; Prime to be tested against
	INC	EAX		   ; Increment the number to be tested

@test:	CMP	SI, DI		   ; Are we at end of table?
	JAE	@prime		   ; No, divide
	PUSH	EAX		   ; Save the number being tested
	MOV	BP, [SI]	   ; Load a prime
	DIV	EBP		   ; Test this divisor
	LODSW			   ; Smaller than ADD SI, 2
	DEC	DX		   ; Is the remainder 0?
	CWD			   ;     Zero out EDX (AX < 32768)
	POP	EAX		   ;     (flags are being preserved)
	JS	@next		   ; If so we have a divisor
	JMP	SHORT @test	   ; Else try the next prime

@prime: CMP	DI, end		   ; Found 600 primes?
	JAE	@back		   ; Yes, loop
	STOSW			   ; No, store it
@back:	LOOPD	@next

@print: MOV	CX, BX		   ; 10 is also the number of printed digits
	PUSH	CX		   ; and LF too
	PUSH	BYTE 13		   ; Push CR
@store:	CDQ
	DIV	EBX
	OR	DL, 30h		   ; Make digit
	PUSH	DX		   ; Then save it
	LOOP	@store

	MOV	CL, 12		   ; 10 digits + final CR/LF
@ploop:	POP	DX		   ; Get remainders (in LIFO order)
	MOV	AH, 2
	INT	21H		   ; And print it
	LOOP	@ploop
	RET
