;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;=  This is Blue's entry to the Hugi-Size-Coding-Competition #12	     =
;-                                                                           -
;=  contact me via e-mail: blue@cs.tu-berlin.de                              =
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;=  use TASM to compile it ...                                               =
;-                                                                           -
;=  Size-History: 140->115->99->98->97->91->90->91->87			     =
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
IDEAL
P386
;-----------------------------------------------------------------------------
; Code ...
;-----------------------------------------------------------------------------
SEGMENT CompoCode PARA PUBLIC USE16
ASSUME  cs:CompoCode,ds:CompoCode
ORG 100h

Main:
 mov	si,81h			; start of commandline
 xor    ecx,ecx
 imul   ecx			; eax=edx=0
 
 CalcNrLoop:			; get parameter n
  imul   ecx,10
  add	 ecx,eax
  lodsb
  sahf				; clear adjust flag
  aaa				; and al,0Fh; cmp al,9; jbe CalcNrLoop
 jnc    CalcNrLoop   		; end of commandline ?

 ;---------------------------------------
 ; eax = 0103h
 ; ecx = prime number counter
 ; edx = 0
 ; cf=1; af=1
 ;---------------------------------------
 pop    ax
 jecxz	nthPrimeFound		; commandline empty or zero ?
 inc    ax

 TryNextNumber:
  inc	 eax			; eax = current test number
  mov	 bx,dx			; stack start
  CheckNumber:
   sub	  bx,4
   pushad			
   idiv   [DWORD PTR bx]	; divide by saved prime (prime is 16bit)
   dec    dx			; remainder > 0? -> search on
   popad			; (remainder is always 16bit)
  jns    CheckNumber
   
  cmp    bx,sp			; reached end of prime factors ? 
  jge    TryNextNumber 

  cmp    bh,0F6h		; save this prime for further calculations ?
  jb     DontSavePrime
   push   eax
  DontSavePrime:
  db     67h
 loop	TryNextNumber		; decrease prime counter

 ;---------------------------------------
 ; eax = n-th prime number
 ; ecx = 0
 ; edx = 0
 ;---------------------------------------
 nthPrimeFound:
 mov    cl,10
 push   cx			; push 0Ah
 push   0Dh
 mov    ebp,ecx
 CalcNumberLoop:
  cdq
  idiv	 ebp
  add	 dl,'0'
  push   dx
 loop   CalcNumberLoop 

 mov    cl,12
 PrintNumberLoop:
  pop    dx
  mov    ah,2
  int    21h
 loop   PrintNumberLoop

 int	20h			; return to dos
 
ENDS CompoCode
;-----------------------------------------------------------------------------
END Main
;-----------------------------------------------------------------------------
