
; NthPrime by Aphex for Hugi Compo 12
; compile: tasm /m entry
;	   tlink /t/x entry
; assumes: cs = ds = es = ss
;  	   bx = 0, cx = 0FFh
;	   bp = 9xxh word aligned
;	   sp = 0FFFEh, [sp] = 0
;	   df = 0
;          one command line argument with no extra spaces
; size: 88 bytes

p286
model tiny
codeseg
startupcode

mintable	equ	548			; table space
						; a value that assures 
						; all prime nrs lesser than
						; sqrt ( 15485863 )
minbp		equ	900h                    ; min value of bp
maxpv		equ	minbp - 2 * mintable	; max table pointer value

start:
decsp:
	push	bx				; decrease stack top adding 0-s
	loop	decsp				; for 255 times
	push	bp				; save table of prime nr pointer
	or	ax, 240Ah			; 0Dh, 0Ah, '$' = end of string
p386
	popad                                   ; zero all 386 regs but edi = bp
	mov	fs, di  	                ; fs -> table 
	mov	si, 81h				; si -> cmdline
getcmdline:
	imul	ecx, ecx, 10			; ecx *= 10
	add	ecx, eax			; ecx += eax
	inc	ax				; AF = 0 (for aaa)
	lodsb					; get char from command line
	aaa					; ax = digit value (space = 0)
	jnb	getcmdline			; get next char while <> 0Dh
						; now ecx contains n
	std					; reverse storing	
	stosw					; put 103h into table
	push	ax				; save 103h as output offset
	aad	7                               ; set ax to 10
	xchg	bx, ax				; ax = 0, bx = 10
	jecxz	primeready			; if ecx is 0 then output 0
	inc	ax				; ax = 1
nextnr:
	inc	eax				; next number
	mov	si, fs				; si -> table
checkprime:
	cdq					; edx = 0
	mov	bp, [si]			; ebp = prime nr from table
	push	eax				; save eax
	div	ebp				; get modulo in dx 
						; modulo < word ptr [si]
						; modulo is a word!
	lodsw                                   ; move to next pos in table
	pop     eax				; restore all
	dec	dx				; is modulo equal to 0	
	js	nextnr				; if exact div then get next nr
	cmp	si, di				; last pos in table?
	ja	checkprime                      ; if so then get next nr
	cmp	di, maxpv			; table reached max dim?
	jbe	lookfornextprime                ; if yes then look for next prime
	stosw            			; else put prime in table
lookfornextprime:
	db	67h				; 386 address prefix
						; makes loop decrease ecx
	loop	nextnr				; get next nr
primeready:	
	pop	di				; di = 103h -> output offset
	mov	cl, 0				
	org	$-1  				; cx it will contain 92h
						; > 10, < 100h 
						; so it will preserve ds:0 for ret
nextdigit:
	xchg	dx, ax				; restore ax 
						; (not executed first time!)
	pop	dx                              ; edx = 0
						; we got some 0-s on the stack!
	div	ebx	                        ; get decimal digit (ebx = 10)
	xchg	dx, ax                          ; ax = nr modulo 10
	add	ax, 930h                        ; adjust to ASCII in al 
						; set ah to write string func
	stosb                                   ; write in string
	loop 	nextdigit                       ; get next digit
	mov	dl, 103h - 9                    ; dx -> output string
	int	21h				; DOS call	
	ret					; exit to DOS
end start

